/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.ModelPackage;
import com.ibm.team.workitem.common.internal.util.DiffUtils;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class WorkItemDiffReport {
    private static Set<EStructuralFeature> CUSTOM_ATTRIBUTES_FEATURES = new HashSet<EStructuralFeature>();
    private Set<String> fAffectedAttributes = new HashSet<String>();
    private Set<String> fAffectedSyntheticAttributes = new HashSet<String>();
    private final IWorkItemCommon fWorkItemCommon;
    private final IWorkItem fBaseState;
    private final IWorkItem fNewState;

    static {
        ModelPackage model = ModelPackage.eINSTANCE;
        for (String property : IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES) {
            CUSTOM_ATTRIBUTES_FEATURES.add(model.getWorkItem().getEStructuralFeature(property));
        }
    }

    public WorkItemDiffReport(IWorkItem baseState, IWorkItem newState, IWorkItemCommon workItemCommon) throws TeamRepositoryException {
        this.fBaseState = baseState;
        this.fNewState = newState;
        this.fWorkItemCommon = workItemCommon;
        Assert.isTrue((baseState.getClass() == newState.getClass() ? 1 : 0) != 0);
        Collection<String> baseProperties = ItemProfile.computeProfile(baseState).getProperties();
        Collection<String> newProperties = ItemProfile.computeProfile(newState).getProperties();
        HashSet<String> diff = new HashSet<String>(newProperties);
        diff.removeAll(baseProperties);
        Assert.isTrue((diff.size() == 0 ? 1 : 0) != 0);
        this.computeAttributeDiffs((EObject)baseState, (EObject)newState);
        this.computeSyntheticAttributeDiffs(baseState, newState);
    }

    public IWorkItem getBaseState() {
        return this.fBaseState;
    }

    public IWorkItem getNewState() {
        return this.fNewState;
    }

    public Set<String> getAffectedAttributes() {
        return this.fAffectedAttributes;
    }

    public Set<String> getAffectedSyntheticAttributes() {
        return this.fAffectedSyntheticAttributes;
    }

    private void computeAttributeDiffs(EObject baseState, EObject newState) {
        HashSet features = new HashSet(newState.eClass().getEAllStructuralFeatures());
        for (EStructuralFeature feature : features) {
            Object baseValue = baseState.eGet(feature);
            Object newValue = newState.eGet(feature);
            if (CUSTOM_ATTRIBUTES_FEATURES.contains(feature) && newValue instanceof EMap) {
                for (Object key : ((EMap)newValue).keySet()) {
                    if (!(key instanceof String)) continue;
                    if (!(baseValue instanceof EMap) || !((EMap)baseValue).containsKey(key)) {
                        this.fAffectedAttributes.add((String)key);
                        continue;
                    }
                    if (DiffUtils.equals(((EMap)baseValue).get(key), ((EMap)newValue).get(key), true)) continue;
                    this.fAffectedAttributes.add((String)key);
                }
                continue;
            }
            if (DiffUtils.equals(baseValue, newValue, feature.isOrdered())) continue;
            this.fAffectedAttributes.add(feature.getName());
        }
    }

    private void computeSyntheticAttributeDiffs(IWorkItem baseState, IWorkItem newState) throws TeamRepositoryException {
        IProcessAreaHandle newPA;
        IProcessAreaHandle basePA = this.fWorkItemCommon.findProcessArea(baseState, null);
        if (!DiffUtils.equals(basePA, newPA = this.fWorkItemCommon.findProcessArea(newState, null), false)) {
            this.fAffectedSyntheticAttributes.add("teamArea");
        }
    }

    public static boolean linksUpdated(IWorkItemReferences baseWorkItemReferences, IWorkItemReferences newWorkItemReferences) throws TeamRepositoryException {
        List<IEndPointDescriptor> newEnpointTypes = newWorkItemReferences.getTypes();
        if (baseWorkItemReferences == null) {
            return newEnpointTypes.size() > 0;
        }
        List<IEndPointDescriptor> baseEnpointTypes = baseWorkItemReferences.getTypes();
        if (baseEnpointTypes.size() == newEnpointTypes.size()) {
            for (IEndPointDescriptor curEndpoint : newEnpointTypes) {
                if (baseEnpointTypes.contains(curEndpoint)) continue;
                return true;
            }
        } else {
            return true;
        }
        for (IEndPointDescriptor curEndpoint : newEnpointTypes) {
            if (WorkItemDiffReport.equalReferencesLists(baseWorkItemReferences.getReferences(curEndpoint), newWorkItemReferences.getReferences(curEndpoint))) continue;
            return true;
        }
        return false;
    }

    private static boolean equalReferencesLists(List<IReference> left, List<IReference> right) {
        if (left.size() != right.size()) {
            return false;
        }
        ArrayList<IReference> copy = new ArrayList<IReference>(right);
        int i = 0;
        while (i < left.size()) {
            IReference a = left.get(i);
            int index = WorkItemDiffReport.find(a, copy);
            if (index == -1) {
                return false;
            }
            copy.set(index, null);
            ++i;
        }
        for (IReference curr : copy) {
            if (curr == null) continue;
            return false;
        }
        return true;
    }

    private static int find(IReference a, List<IReference> list) {
        if (a == null) {
            return -1;
        }
        int k = 0;
        while (k < list.size()) {
            IReference b = list.get(k);
            if (b != null && (a.isItemReference() && b.isItemReference() ? ((IItemReference)a).getReferencedItem().sameItemId(((IItemReference)b).getReferencedItem()) : a.isURIReference() && b.isURIReference() && ((IURIReference)a).getURI().equals(((IURIReference)b).getURI()))) {
                return k;
            }
            ++k;
        }
        return -1;
    }
}

