/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.internal.query.AliasOperation;
import com.ibm.team.workitem.common.internal.query.ApprovalOperation;
import com.ibm.team.workitem.common.internal.query.AuthoredByOperation;
import com.ibm.team.workitem.common.internal.query.EqualsOperation;
import com.ibm.team.workitem.common.internal.query.ExistsOperation;
import com.ibm.team.workitem.common.internal.query.GtOperation;
import com.ibm.team.workitem.common.internal.query.GtOrEqOperation;
import com.ibm.team.workitem.common.internal.query.InCategoryOperation;
import com.ibm.team.workitem.common.internal.query.LikeOperation;
import com.ibm.team.workitem.common.internal.query.LinkExistsOperation;
import com.ibm.team.workitem.common.internal.query.ListContainsOperation;
import com.ibm.team.workitem.common.internal.query.LtOperation;
import com.ibm.team.workitem.common.internal.query.LtOrEqOperation;
import com.ibm.team.workitem.common.internal.query.PartOfIntervalOperation;
import com.ibm.team.workitem.common.internal.query.StateGroupEqualsOperation;
import com.ibm.team.workitem.common.internal.query.StringContainsOperation;
import com.ibm.team.workitem.common.internal.query.TeamAreaEqualsOperation;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.Messages;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AttributeOperation {
    private static final String OPERATOR_APP_REJECTED = "rejected by";
    private static final String OPERATOR_APP_APPROVED = "approved by";
    private static final String OPERATOR_APP_PENDING = "pending by";
    private static final String OPERATOR_APP_INVOLVE = "involve";
    private static final String OPERATOR_EXISTS = "exists";
    private static final String OPERATOR_CONTAINING = "containing";
    private static final String OPERATOR_NOT_CONTAINING = "not containing";
    private static final String OPERATOR_AUTHORED_BY = "authored by";
    private static final String OPERATOR_PART_OF = "is part of";
    private static final String OPERATOR_NOT_PART_OF = "is not part of";
    private static final String OPERATOR_IN_SUBTREE = "in subtree";
    private static final String OPERATOR_NOT_IN_SUBTREE = "not in subtree";
    private static final String OPERATOR_SM_OR_EQ = "smaller or equals";
    private static final String OPERATOR_GT_OR_EQ = "greater or equals";
    private static final String OPERATOR_SMALLER = "smaller";
    private static final String OPERATOR_GREATER = "greater";
    private static final String OPERATOR_BEFORE = "before";
    private static final String OPERATOR_AFTER = "after";
    private static final String OPERATOR_EQUALS = "is";
    private static final String OPERATOR_NOT_EQUALS = "is not";
    private static final String OPERATOR_MATCHES = "matches";
    private static final String OPERATOR_NOT_MATCHES = "does not match";
    private static final String OPERATOR_STARTS_WITH = "starts with";
    private static final String OPERATOR_ENDS_WITH = "ends with";
    private static final String OPERATOR_CONTAINS = "contains";
    private static final String OPERATOR_NOT_CONTAINS = "does not contain";
    private static final String OPERATOR_TA_EQUALS = "teamarea.equals";
    private static final String OPERATOR_TA_NOT_EQUALS = "teamarea.not.equals";
    private static final String OPERATOR_STG_EQUALS = "stategroup.equals";
    private static final String OPERATOR_STG_NOT_EQUALS = "stategroup.not.equals";
    private static final String OPERATOR_LINK_EXISTS = "link.exists";
    private static final String OPERATOR_LINK_NOT_EXISTS = "link.not.exists";
    private static final String OPERATOR_SM_OR_EQ_PLAIN = "smOrEq";
    private static final String OPERATOR_GT_OR_EQ_PLAIN = "gtOrEq";
    private static final String OPERATOR_SMALLER_PLAIN = "sm";
    private static final String OPERATOR_GREATER_PLAIN = "gt";
    private static Map<String, AttributeOperation> fgRegistry = new HashMap<String, AttributeOperation>();
    public static final AttributeOperation EQUALS = new EqualsOperation("is", "AttributeOperation.EQUALS", false);
    public static final AttributeOperation NOT_EQUALS = new EqualsOperation("is not", "AttributeOperation.NOT_EQUALS", true);
    public static final AttributeOperation MATCHES = new EqualsOperation("matches", "AttributeOperation.MATCHES", false);
    public static final AttributeOperation NOT_MATCHES = new EqualsOperation("does not match", "AttributeOperation.NOT_MATCHES", true);
    public static final AttributeOperation CONTAINS = new StringContainsOperation("contains", "AttributeOperation.CONTAINS", false);
    public static final AttributeOperation NOT_CONTAINS = new StringContainsOperation("does not contain", "AttributeOperation.NOT_CONTAINS", true);
    public static final AttributeOperation IN_CATEGORY = new InCategoryOperation("in subtree", "AttributeOperation.IN_SUBTREE", false);
    public static final AttributeOperation NOT_IN_CATEGORY = new InCategoryOperation("not in subtree", "AttributeOperation.NOT_IN_SUBTREE", true);
    public static final AttributeOperation PART_OF_INTERVAL = new PartOfIntervalOperation("is part of", "AttributeOperation.PART_OF", false);
    public static final AttributeOperation NOT_PART_OF_INTERVAL = new PartOfIntervalOperation("is not part of", "AttributeOperation.NOT_PART_OF", true);
    public static final AttributeOperation AUTHORED_BY = new AuthoredByOperation("authored by", "AttributeOperation.AUTHORED_BY");
    public static final AttributeOperation CONTAINING = new ListContainsOperation("containing", "AttributeOperation.CONTAINING", false);
    public static final AttributeOperation NOT_CONTAINING = new ListContainsOperation("not containing", "AttributeOperation.NOT_CONTAINING", true);
    public static final AttributeOperation EXISTS = new ExistsOperation("exists", "AttributeOperation.EXISTS");
    public static final AttributeOperation LINK_EXISTS = new LinkExistsOperation("link.exists", "AttributeOperation.SET_EXIST", false);
    public static final AttributeOperation LINK_NOT_EXISTS = new LinkExistsOperation("link.not.exists", "AttributeOperation.SET_NOT_EXIST", true);
    public static final AttributeOperation TEAM_AREA_EQUALS = new TeamAreaEqualsOperation("teamarea.equals", "AttributeOperation.EQUALS", false);
    public static final AttributeOperation TEAM_AREA_NOT_EQUALS = new TeamAreaEqualsOperation("teamarea.not.equals", "AttributeOperation.NOT_EQUALS", true);
    public static final AttributeOperation STATE_GROUP_EQUALS = new StateGroupEqualsOperation("stategroup.equals", "AttributeOperation.EQUALS", false);
    public static final AttributeOperation STATE_GROUP_NOT_EQUALS = new StateGroupEqualsOperation("stategroup.not.equals", "AttributeOperation.NOT_EQUALS", true);
    public static final AttributeOperation INVOLVES = new ApprovalOperation("involve", "AttributeOperation.APPROVAL_INVOLVE", null);
    public static final AttributeOperation TO_BE_APPROVED_BY = new ApprovalOperation("pending by", "AttributeOperation.APPROVAL_PENDING_BY", WorkItemApprovals.PENDING_STATE);
    public static final AttributeOperation APPROVED_BY = new ApprovalOperation("approved by", "AttributeOperation.APPROVAL_APPROVED_BY", WorkItemApprovals.APPROVED_STATE);
    public static final AttributeOperation REJECTED_BY = new ApprovalOperation("rejected by", "AttributeOperation.APPROVAL_REJECTED_BY", WorkItemApprovals.REJECTED_STATE);
    public static final AttributeOperation STARTS_WITH = new LikeOperation("starts with", "AttributeOperation.STARTS_WITH", "%s%%"){

        @Override
        protected boolean internalEvaluate(String left, String right) {
            return left.startsWith(right);
        }
    };
    public static final AttributeOperation ENDS_WITH = new LikeOperation("ends with", "AttributeOperation.ENDS_WITH", "%%%s"){

        @Override
        protected boolean internalEvaluate(String left, String right) {
            return left.endsWith(right);
        }
    };
    public static final AttributeOperation SMALLER_OR_EQUALS_PLAIN = new LtOrEqOperation("smOrEq", "AttributeOperation.SMALLER_OR_EQUALS", false);
    public static final AttributeOperation GREATER_OR_EQUALS_PLAIN = new GtOrEqOperation("gtOrEq", "AttributeOperation.GREATER_OR_EQUALS", false);
    public static final AttributeOperation SMALLER_PLAIN = new LtOperation("sm", "AttributeOperation.SMALLER", false);
    public static final AttributeOperation GREATER_PLAIN = new GtOperation("gt", "AttributeOperation.GREATER", false);
    public static final AttributeOperation SMALLER_OR_EQUALS = new LtOrEqOperation("smaller or equals", "AttributeOperation.SMALLER_OR_EQUALS");
    public static final AttributeOperation GREATER_OR_EQUALS = new GtOrEqOperation("greater or equals", "AttributeOperation.GREATER_OR_EQUALS");
    public static final AttributeOperation SMALLER = new LtOperation("smaller", "AttributeOperation.SMALLER");
    public static final AttributeOperation GREATER = new GtOperation("greater", "AttributeOperation.GREATER");
    public static final AttributeOperation AFTER = new AliasOperation("after", "AttributeOperation.AFTER", GREATER_OR_EQUALS);
    public static final AttributeOperation BEFORE = new AliasOperation("before", "AttributeOperation.BEFORE", SMALLER_OR_EQUALS);
    private final String fDisplayNameKey;
    private final String fIdentifier;
    private final boolean fIsUnary;

    public static AttributeOperation find(String id) {
        if ("similar".equals(id)) {
            return CONTAINS;
        }
        return fgRegistry.get(id);
    }

    protected AttributeOperation(String identifier, String displayNameKey) {
        this(identifier, displayNameKey, false);
    }

    private AttributeOperation(String identifier, String displayNameKey, boolean isUnary) {
        this.fIdentifier = identifier;
        this.fDisplayNameKey = displayNameKey;
        this.fIsUnary = isUnary;
        fgRegistry.put(identifier, this);
    }

    public String getIdentifier() {
        return this.fIdentifier;
    }

    public String getDisplayName(LocalizationContext lc) {
        return Messages.getString(lc, this.fDisplayNameKey);
    }

    public String getDisplayName() {
        return Messages.getString(LocalizationContext.getDefault(), this.fDisplayNameKey);
    }

    public boolean isUnary() {
        return this.fIsUnary;
    }

    public boolean isNegation() {
        return false;
    }

    protected IPredicate invertNullAware(ITransformationContext context, IPredicate predicate) {
        IPredicate nullPredicate = null;
        if (context.getValue() != null) {
            nullPredicate = context.isField() ? context.getField()._isNull() : context.getReference()._isNull();
        }
        return nullPredicate == null ? predicate._not() : predicate._not()._or(nullPredicate);
    }

    protected INumeric createNumericInputArg(ITransformationContext context) {
        return this.createNumericInputArg(context, context.getValue());
    }

    protected INumeric createNumericInputArg(ITransformationContext context, Object value) {
        if (value instanceof Integer) {
            return context.getQuery().newIntegerArg();
        }
        if (value instanceof Long) {
            return context.getQuery().newLongArg();
        }
        if (value instanceof BigDecimal) {
            return context.getQuery().newBigDecimalArg();
        }
        throw new IllegalArgumentException("Numeric value must be Integer, Long or BigDecimal");
    }

    public abstract boolean evaluate(Object var1, Object var2, IEvaluationContext var3, IProgressMonitor var4) throws TeamRepositoryException;

    public abstract IPredicate getPredicate(ITransformationContext var1, IProgressMonitor var2) throws TeamRepositoryException;

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AttributeOperation) {
            return this.getIdentifier().equals(((AttributeOperation)obj).getIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getIdentifier().hashCode();
    }

    public boolean supportsMultiValuesPredicate(IQueryableAttribute attribute) {
        return false;
    }
}

