/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.internal.util.LocationUtil;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.ClientHttpUtil;
import com.ibm.team.repository.transport.client.IOAuthHandler;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.eclipse.core.runtime.IStatus;

public class OAuthUtil {
    public static final String OAUTH_CALLBACK_URL = "proxyCallback";
    private static final String X_OAUTH_AUTHORIZATION_URL = "X-jazz-web-oauth-url";
    private static final String OAUTH_CALLBACK = "oauth_callback";
    public static final String AUTHORIZED_REQUEST_TOKEN_PARAM_NAME = "oauth_token";
    public static final String REQUEST_TOKEN_SECRET_PARAM_NAME = "request_token_secret";
    public static final String OAUTH_PROVIDER = "oauth_provider";
    static Pattern _queryPattern = Pattern.compile("^(.*?)([?][^#]*)?(#.*)?$");

    public static int handleOAuthChallenge(int status, RemoteTeamServer remoteTeamServer, HttpMethod httpMethod, IOAuthHandler oauthHandler) throws MalformedURLException, URIException, TeamServiceException, UnsupportedEncodingException, URISyntaxException {
        return OAuthUtil.handleOAuthChallenge(status, remoteTeamServer, httpMethod, oauthHandler, true);
    }

    private static int handleOAuthChallenge(int status, RemoteTeamServer remoteTeamServer, HttpMethod httpMethod, IOAuthHandler oauthHandler, boolean allowRetries) throws MalformedURLException, URIException, TeamServiceException, UnsupportedEncodingException, URISyntaxException {
        AuthenticationException authEx;
        block22: {
            Header oauthUriHeader;
            IOAuthHandler.IResponse oauthAuthResponse = null;
            String[] oauthTokens = null;
            if (status == 401 && (oauthUriHeader = httpMethod.getResponseHeader(X_OAUTH_AUTHORIZATION_URL)) != null && oauthHandler != null) {
                String oauthUri = oauthUriHeader.getValue();
                if (oauthUri == null || oauthUri.length() == 0) {
                    throw new IllegalArgumentException(String.format("Missing value for %s header", X_OAUTH_AUTHORIZATION_URL));
                }
                oauthTokens = OAuthUtil.parseOAuthTokens(oauthUri);
                oauthAuthResponse = oauthHandler.authorize(oauthUri);
            }
            if (oauthAuthResponse == null || oauthAuthResponse.getCallbackURL() == null) {
                return status;
            }
            if (oauthAuthResponse.getStatus() != null && !oauthAuthResponse.getStatus().isOK()) {
                IStatus errorStatus = oauthAuthResponse.getStatus();
                throw new TeamServiceException(errorStatus.getMessage(), errorStatus.getException(), 401);
            }
            String tokenQuery = String.format("%s=%s", AUTHORIZED_REQUEST_TOKEN_PARAM_NAME, LocationUtil.encode((String)oauthTokens[0]));
            String secretQuery = null;
            if (oauthTokens[1] != null) {
                secretQuery = String.format("%s=%s", REQUEST_TOKEN_SECRET_PARAM_NAME, LocationUtil.encode((String)oauthTokens[1]));
            }
            String providerQuery = null;
            if (oauthTokens[2] != null) {
                providerQuery = String.format("%s=%s", OAUTH_PROVIDER, oauthTokens[2]);
            }
            String originalUri = httpMethod.getURI().getEscapedURI();
            String newUri = OAuthUtil.stripOAuthParms(originalUri);
            Matcher matches = _queryPattern.matcher(newUri);
            matches.matches();
            String prefix = matches.group(1);
            String query = matches.group(2);
            String fragment = matches.group(3);
            if (fragment == null) {
                fragment = "";
            }
            StringBuffer queryBuf = new StringBuffer();
            if (query != null) {
                queryBuf.append(query);
                queryBuf.append('&');
            } else {
                queryBuf.append('?');
            }
            queryBuf.append(tokenQuery);
            if (secretQuery != null) {
                queryBuf.append('&');
                queryBuf.append(secretQuery);
            }
            if (providerQuery != null) {
                queryBuf.append('&');
                queryBuf.append(providerQuery);
            }
            newUri = String.valueOf(prefix) + queryBuf.toString() + fragment;
            httpMethod.releaseConnection();
            httpMethod.setRequestHeader("Connection", "Close");
            httpMethod.setPath(newUri);
            TeamServiceCallContextImpl.setUpCall((HttpMethod)httpMethod);
            authEx = null;
            try {
                status = ClientHttpUtil.executeHttpMethod(remoteTeamServer, null, httpMethod, false, true);
            }
            catch (AuthenticationException e) {
                status = 401;
                authEx = e;
                if (allowRetries) {
                    try {
                        status = OAuthUtil.handleOAuthChallenge(status, remoteTeamServer, httpMethod, oauthHandler, false);
                    }
                    catch (Exception ex) {
                        int statusCode = -1;
                        if (ex instanceof TeamServiceException) {
                            statusCode = ((TeamServiceException)((Object)ex)).getStatusCode();
                        }
                        throw new TeamServiceException(ex.getMessage(), (Throwable)ex, statusCode);
                    }
                }
                httpMethod.setPath(originalUri);
                TeamServiceCallContextImpl.tearDownCall();
                break block22;
            }
            catch (IOException e) {
                try {
                    throw new TeamServiceException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    httpMethod.setPath(originalUri);
                    TeamServiceCallContextImpl.tearDownCall();
                    throw throwable;
                }
            }
            httpMethod.setPath(originalUri);
            TeamServiceCallContextImpl.tearDownCall();
        }
        if (status == 401 && authEx != null) {
            throw authEx;
        }
        return status;
    }

    private static String[] parseOAuthTokens(String uri) throws URISyntaxException, UnsupportedEncodingException {
        String name;
        StringTokenizer parmTokenizer;
        String oauthCallbackUri = null;
        String oauthSecret = null;
        String oauthToken = null;
        String oauthProviderUri = null;
        String[] tokens = new String[3];
        String queryString = new URI(uri).getRawQuery();
        StringTokenizer queryTokenizer = new StringTokenizer(queryString, "&");
        while (queryTokenizer.hasMoreTokens()) {
            parmTokenizer = new StringTokenizer(queryTokenizer.nextToken(), "=");
            if (parmTokenizer.countTokens() == 0) continue;
            name = parmTokenizer.nextToken();
            if (name.toLowerCase().equals(OAUTH_CALLBACK)) {
                oauthCallbackUri = LocationUtil.decode((String)parmTokenizer.nextToken());
                continue;
            }
            if (!name.toLowerCase().equals(AUTHORIZED_REQUEST_TOKEN_PARAM_NAME)) continue;
            oauthToken = LocationUtil.decode((String)parmTokenizer.nextToken());
        }
        if (oauthToken == null) {
            throw new IllegalArgumentException(String.format("Absence of oauth token in \"%s\" during OAuth parsing and redirection handling", uri));
        }
        if (oauthCallbackUri != null && (queryString = new URI(oauthCallbackUri).getRawQuery()) != null && queryString.trim().length() > 0) {
            queryTokenizer = new StringTokenizer(queryString, "&");
            while (queryTokenizer.hasMoreTokens()) {
                parmTokenizer = new StringTokenizer(queryTokenizer.nextToken(), "=");
                if (parmTokenizer.countTokens() == 0) continue;
                name = parmTokenizer.nextToken();
                if (name.toLowerCase().equals(REQUEST_TOKEN_SECRET_PARAM_NAME)) {
                    oauthSecret = LocationUtil.decode((String)parmTokenizer.nextToken());
                    continue;
                }
                if (!name.toLowerCase().equals(OAUTH_PROVIDER)) continue;
                oauthProviderUri = parmTokenizer.nextToken();
            }
        }
        tokens[0] = oauthToken;
        tokens[1] = oauthSecret;
        tokens[2] = oauthProviderUri;
        return tokens;
    }

    private static String stripOAuthParms(String uri) throws URISyntaxException, MalformedURLException, UnsupportedEncodingException {
        Matcher matches = _queryPattern.matcher(uri);
        matches.matches();
        String prefix = matches.group(1);
        String query = matches.group(2);
        String fragment = matches.group(3);
        if (fragment == null) {
            fragment = "";
        }
        if (query != null) {
            query = query.length() > 1 ? query.substring(1) : null;
        }
        Map queryParms = LocationUtil.parseQueryParameters((String)query);
        String queryString = LocationUtil.queryString((Map)queryParms, (String[])new String[]{OAUTH_PROVIDER, AUTHORIZED_REQUEST_TOKEN_PARAM_NAME, REQUEST_TOKEN_SECRET_PARAM_NAME});
        StringBuffer buf = new StringBuffer(prefix);
        if (queryString.length() != 0) {
            buf.append('?');
            buf.append(queryString);
        }
        buf.append(fragment);
        return buf.toString();
    }
}

