/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.Marshaller;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.ITeamService;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.ClientHttpUtil;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import com.ibm.team.repository.transport.client.ReleasingAndAbortingInputStream;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import com.ibm.team.repository.transport.internal.nls.Messages;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TeamRestServiceClient
implements ITeamRestServiceClient {
    private static final String UserAgent = TeamRestServiceClient.class.getName();
    private final RemoteTeamServer _remoteTeamServer;
    private final String _serviceBinding;

    public TeamRestServiceClient(RemoteTeamServer remoteTeamServer, Class<?> serviceClass, ClassLoader serviceClassLoader) {
        if (remoteTeamServer == null) {
            throw new IllegalArgumentException("remoteTeamServer must not be null");
        }
        if (serviceClass == null) {
            throw new IllegalArgumentException("serviceClass must not be null");
        }
        this._remoteTeamServer = remoteTeamServer;
        this._serviceBinding = serviceClass.getName();
    }

    public TeamRestServiceClient(RemoteTeamServer remoteTeamServer, String serviceBinding, ClassLoader serviceClassLoader) {
        if (remoteTeamServer == null) {
            throw new IllegalArgumentException("remoteTeamServer must not be null");
        }
        if (serviceBinding == null) {
            throw new IllegalArgumentException("serviceBinding must not be null");
        }
        this._remoteTeamServer = remoteTeamServer;
        this._serviceBinding = serviceBinding;
    }

    @Override
    public ITeamRestServiceClient.IRestClientConnection getConnection(Location loc) {
        if (loc == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        return new RestClientConnection(this._remoteTeamServer, this._serviceBinding, loc);
    }

    @Override
    public ITeamRestServiceClient.IRestClientConnection getConnection(URI relUri) {
        if (relUri == null) {
            throw new IllegalArgumentException("relative URI must not be null");
        }
        return new RestClientConnection(this._remoteTeamServer, this._serviceBinding, relUri);
    }

    public static class RestClientConnection
    implements ITeamRestServiceClient.IRestClientConnection {
        private final RemoteTeamServer _remoteTeamServer;
        private final String _repoUrl;
        private final String _serviceBinding;
        private final Location _loc;
        private final URI _relUri;
        private final HashMap<String, String> _headers = new HashMap();
        private ITeamRestServiceClient.IRestClientConnection.Response _response = null;
        private HttpMethod _httpMethod = null;
        private static final Log logger = LogFactory.getLog(TeamRestServiceClient.class);

        public RestClientConnection(RemoteTeamServer server, String serviceBinding, Location loc) {
            if (server == null) {
                throw new IllegalArgumentException("remoteTeamServer must not be null");
            }
            if (serviceBinding == null) {
                throw new IllegalArgumentException("serviceBinding must not be null");
            }
            if (loc == null) {
                throw new IllegalArgumentException("loc must not be null");
            }
            this._remoteTeamServer = server;
            this._repoUrl = server.getRepositoryURL();
            this._serviceBinding = serviceBinding;
            this._loc = loc;
            this._relUri = null;
        }

        public RestClientConnection(RemoteTeamServer server, String serviceBinding, URI relUri) {
            if (server == null) {
                throw new IllegalArgumentException("server must not be null");
            }
            if (serviceBinding == null) {
                throw new IllegalArgumentException("serviceClass must not be null");
            }
            if (relUri == null) {
                throw new IllegalArgumentException("relUri must not be null");
            }
            this._remoteTeamServer = server;
            this._repoUrl = server.getRepositoryURL();
            this._serviceBinding = serviceBinding;
            this._loc = null;
            this._relUri = relUri;
        }

        @Override
        public void addRequestHeader(String name, String value) {
            if (this._httpMethod != null) {
                throw new IllegalStateException("Cannot add request headers to a connection has been previously run");
            }
            if (name == null || name.length() == 0) {
                return;
            }
            if (value == null) {
                value = "";
            }
            this._headers.put(name, value);
        }

        @Override
        public ITeamRestServiceClient.IRestClientConnection.Response doGet() throws TeamServiceException, TeamRepositoryException {
            return this.doMethod((HttpMethod)new GetMethod());
        }

        @Override
        public ITeamRestServiceClient.IRestClientConnection.Response doOptions() throws TeamServiceException, TeamRepositoryException {
            return this.doMethod((HttpMethod)new OptionsMethod());
        }

        @Override
        public ITeamRestServiceClient.IRestClientConnection.Response doPost(InputStream content, long contentLength, String contentType) throws TeamServiceException, TeamRepositoryException {
            PostMethod postMethod = new PostMethod();
            InputStreamRequestEntity requestEntity = new InputStreamRequestEntity((InputStream)new BufferedInputStream(content, 16384), contentType);
            postMethod.setRequestEntity((RequestEntity)requestEntity);
            return this.doMethod((HttpMethod)postMethod);
        }

        @Override
        public ITeamRestServiceClient.IRestClientConnection.Response doPut(InputStream content, long contentLength, String contentType) throws TeamServiceException, TeamRepositoryException {
            PutMethod putMethod = new PutMethod();
            InputStreamRequestEntity requestEntity = new InputStreamRequestEntity((InputStream)new BufferedInputStream(content, 16384), contentType);
            putMethod.setRequestEntity((RequestEntity)requestEntity);
            return this.doMethod((HttpMethod)putMethod);
        }

        @Override
        public ITeamRestServiceClient.IRestClientConnection.Response doDelete() throws TeamServiceException, TeamRepositoryException {
            return this.doMethod((HttpMethod)new DeleteMethod());
        }

        private ITeamRestServiceClient.IRestClientConnection.Response doMethod(HttpMethod method) throws TeamServiceException, TeamRepositoryException {
            TeamRepositoryException caughtException;
            int status;
            block9: {
                if (this._httpMethod != null) {
                    throw new IllegalStateException("do* called multiple times on the same connection");
                }
                this._httpMethod = method;
                this.prepareMethod();
                status = -1;
                caughtException = null;
                try {
                    status = this.executeMethod();
                }
                catch (TeamRepositoryException e) {
                    caughtException = e;
                    if (!this._httpMethod.hasBeenUsed()) break block9;
                    status = this._httpMethod.getStatusCode();
                }
            }
            Header[] headers = this._httpMethod.getResponseHeaders();
            HashMap<String, String> headersMap = new HashMap<String, String>(headers.length);
            Header[] headerArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                headersMap.put(header.getName(), header.getValue());
                ++n2;
            }
            ReleasingAndAbortingInputStream responseStream = null;
            try {
                if (this._httpMethod.getResponseBodyAsStream() != null) {
                    responseStream = new ReleasingAndAbortingInputStream(this._httpMethod);
                }
            }
            catch (IOException e) {
                this._httpMethod.releaseConnection();
                throw new TeamServiceException(e.getMessage());
            }
            String statusText = null;
            if (this._httpMethod.hasBeenUsed()) {
                statusText = this._httpMethod.getStatusText();
            }
            this._response = new ITeamRestServiceClient.IRestClientConnection.Response(responseStream, headersMap, status, statusText, this.httpStatusToStatusCode(status));
            if (caughtException != null) {
                throw caughtException;
            }
            return this._response;
        }

        private ITeamRestServiceClient.IRestClientConnection.Response.StatusCode httpStatusToStatusCode(int retVal) {
            ITeamRestServiceClient.IRestClientConnection.Response.StatusCode statusCode;
            switch (retVal) {
                case 200: {
                    statusCode = ITeamRestServiceClient.IRestClientConnection.Response.StatusCode.OK;
                    break;
                }
                case 201: {
                    statusCode = ITeamRestServiceClient.IRestClientConnection.Response.StatusCode.CREATED;
                    break;
                }
                case 404: {
                    statusCode = ITeamRestServiceClient.IRestClientConnection.Response.StatusCode.NOT_FOUND;
                    break;
                }
                case 304: {
                    statusCode = ITeamRestServiceClient.IRestClientConnection.Response.StatusCode.NOT_MODIFIED;
                    break;
                }
                default: {
                    statusCode = ITeamRestServiceClient.IRestClientConnection.Response.StatusCode.ERROR;
                }
            }
            return statusCode;
        }

        @Override
        public void release() {
        }

        @Override
        public IItem unmarshall(InputStream response) throws TeamRepositoryException {
            if (response == null) {
                throw new IllegalArgumentException("response must not be null");
            }
            Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.EOBJECT_LITERAL);
            try {
                return (IItem)marshaller.demarshalInputStreamToObject(response);
            }
            catch (MarshallingException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }

        private Location boundLocation() {
            return Location.location((Location)this._loc, (String)this._repoUrl, (String)this._serviceBinding);
        }

        @Override
        public URI boundAbsoluteUri() throws TeamRepositoryException {
            if (this._loc != null) {
                return this.boundLocation().toAbsoluteUri();
            }
            String s = String.valueOf(this._repoUrl) + "service/" + this._serviceBinding + "/" + HttpUtil.trimLeadingSlash((String)this._relUri.toString());
            try {
                return new URI(s);
            }
            catch (URISyntaxException e) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.getServerString("TeamRestServiceClient.UriSyntaxError"), (Object)s, (Object[])new Object[0]), (Throwable)e);
            }
        }

        private void prepareMethod() throws TeamServiceException {
            this._httpMethod.setDoAuthentication(true);
            try {
                URI uri = this.boundAbsoluteUri();
                String formatString = "%s";
                if (uri.getQuery() != null) {
                    formatString = String.valueOf(formatString) + "?%s";
                }
                if (uri.getFragment() != null) {
                    formatString = String.valueOf(formatString) + "#%s";
                }
                try {
                    uri = new URI(String.format(formatString, uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment()));
                }
                catch (URISyntaxException e) {
                    logger.warn((Object)String.format("URISyntaxException parsing URI: %s", e.getMessage()));
                }
                this._httpMethod.setPath(uri.toASCIIString());
            }
            catch (IllegalStateException e) {
                throw new TeamServiceException(e.getMessage());
            }
            catch (TeamRepositoryException e) {
                throw new TeamServiceException(e.getMessage());
            }
            this._httpMethod.setRequestHeader("http.useragent", UserAgent);
            if (this._httpMethod.getRequestHeader("Accept") == null) {
                this._httpMethod.setRequestHeader("Accept", HttpUtil.MediaType.XML.toString());
            }
            if (this._httpMethod.getRequestHeader("Accept-Charset") == null) {
                this._httpMethod.setRequestHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
            }
            if (this._httpMethod.getRequestHeader("Accept-Language") == null) {
                ClientHttpUtil.setAcceptLanguageHeader(this._httpMethod);
            }
            this.addServiceVersionHeader(this._httpMethod, this._serviceBinding);
            String userid = this._remoteTeamServer.getUserid();
            ClientHttpUtil.addUseridHeader(userid, this._httpMethod);
            for (String key : this._headers.keySet()) {
                String value = this._headers.get(key);
                this._httpMethod.setRequestHeader(key, value);
            }
        }

        private void addServiceVersionHeader(HttpMethod method, String serviceName) {
            ITeamService teamService = this._remoteTeamServer.getServiceByName(serviceName);
            if (teamService == null) {
                return;
            }
            String version = teamService.getVersion();
            if (version != null && version.length() > 0) {
                method.addRequestHeader("X-com-ibm-team-service-version", version);
            }
        }

        private int executeMethod() throws TeamServiceException, TeamRepositoryException {
            int status = 500;
            TeamServiceCallContextImpl.setUpCall((HttpMethod)this._httpMethod);
            try {
                try {
                    status = ClientHttpUtil.executeHttpMethod(this._remoteTeamServer, null, this._httpMethod, false, true);
                    if (status == 404) {
                        throw new ItemNotFoundException(this._httpMethod.getPath());
                    }
                }
                catch (IOException e) {
                    throw new TeamServiceException(e.getMessage());
                }
                catch (TeamRepositoryException e) {
                    throw e;
                }
            }
            finally {
                TeamServiceCallContextImpl.tearDownCall();
            }
            return status;
        }

        public String toString() {
            return this._loc != null ? this._loc.toString() : this._relUri.toString();
        }

        @Override
        public String getServiceUri() {
            return this._serviceBinding;
        }

        @Override
        public ITeamRestServiceClient.IRestClientConnection.Response getResponse() {
            return this._response;
        }
    }
}

