/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def.scripted;

import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.air.property.prop_def.scripted.ScriptedPropInfoHelper;
import com.urbancode.persistence.IDGenerator;
import com.urbancode.persistence.hibernate.AbstractEntity;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="ps_scripted_prop_info", uniqueConstraints={@UniqueConstraint(columnNames={"prop_def_id"})})
public class ScriptedPropInfo
extends AbstractEntity<UUID> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @Type(type="uuid-char")
    protected UUID id = IDGenerator.createID();
    @NotNull
    @OneToOne(optional=false)
    @JoinColumn(name="prop_def_id", updatable=false)
    protected PropDef propDef = null;
    @NotNull
    @Column(name="source")
    protected String source = null;
    @Column(name="arguments")
    protected String arguments = null;
    @NotNull
    @Column(name="data_source_type")
    protected String dataSourceType = ScriptedDataSourceType.COMMAND.toString();
    protected transient ScriptedDataSourceType scriptedDatasourceType;
    @NotNull
    @Column(name="data_format")
    protected String formatName = HttpPropInfo.HttpDataFormat.JSON.toString();
    protected transient DataFormat format;
    @Column(name="base_path")
    protected String basePath = null;
    @Column(name="value_path")
    protected String valuePath = null;
    @Column(name="label_path")
    protected String labelPath = null;

    public ScriptedPropInfo() {
    }

    public ScriptedPropInfo(PropDef propDef) {
        this.propDef = propDef;
    }

    public ScriptedPropInfo(PropDef propDef, ScriptedPropInfo copy) {
        this.propDef = propDef;
        this.source = copy.source;
        this.arguments = copy.arguments;
        this.basePath = copy.basePath;
        this.valuePath = copy.valuePath;
        this.labelPath = copy.labelPath;
        this.setScriptedDataSourceType(copy.getScriptedDataSourceType());
        this.setFormat(copy.getFormat());
    }

    public UUID getId() {
        return this.id;
    }

    public PropDef getPropDef() {
        return this.propDef;
    }

    public void setPropDef(PropDef propDef) {
        this.propDef = propDef;
        if (this.propDef.getPropSheetDef() != null) {
            this.setDirty();
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
        this.setDirty();
    }

    public String getValuePath() {
        return this.valuePath;
    }

    public void setValuePath(String valuePath) {
        this.valuePath = valuePath;
        this.setDirty();
    }

    public String getLabelPath() {
        return this.labelPath;
    }

    public void setLabelPath(String labelPath) {
        this.labelPath = labelPath;
        this.setDirty();
    }

    public ScriptedDataSourceType getScriptedDataSourceType() {
        if (this.scriptedDatasourceType == null) {
            this.scriptedDatasourceType = ScriptedDataSourceType.valueOf(this.dataSourceType);
        }
        return this.scriptedDatasourceType;
    }

    public String getDataSourceType() {
        return this.dataSourceType;
    }

    public void setScriptedDataSourceType(ScriptedDataSourceType scriptedSourceType) {
        if (scriptedSourceType == null) {
            throw new IllegalArgumentException("Data format is required.");
        }
        this.scriptedDatasourceType = scriptedSourceType;
        this.dataSourceType = this.scriptedDatasourceType.toString();
        this.setDirty();
    }

    public void setDataSourceType(String sourceType) {
        if (StringUtils.isBlank((String)sourceType)) {
            throw new IllegalArgumentException("Type is required.");
        }
        this.dataSourceType = sourceType;
        this.scriptedDatasourceType = ScriptedDataSourceType.valueOf(sourceType);
        this.setDirty();
    }

    public DataFormat getFormat() {
        if (this.format == null) {
            this.format = DataFormat.valueOf(this.formatName);
        }
        return this.format;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormat(DataFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("Data format is required.");
        }
        this.format = format;
        this.formatName = format.toString();
        this.setDirty();
    }

    public void setFormatName(String formatName) {
        if (StringUtils.isBlank((String)formatName)) {
            throw new IllegalArgumentException("Type is required.");
        }
        this.formatName = formatName;
        this.format = DataFormat.valueOf(formatName);
        this.setDirty();
    }

    public List<PropDefAllowedValue> getAllowedValues(String rawData) {
        return new ScriptedPropInfoHelper().getAllowedValues(this, rawData);
    }

    private void setDirty() {
        if (this.propDef != null && this.propDef.getPropSheetDef() != null) {
            this.propDef.getPropSheetDef().getPersistenceData().setDirty(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataFormat {
        JSON,
        XML,
        LINE_SEPARATED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScriptedDataSourceType {
        COMMAND;

    }
}

