/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.faster;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.graph.query.Applyer;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Matcher;
import com.hp.hpl.jena.graph.query.QueryNode;
import com.hp.hpl.jena.graph.query.QueryTriple;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.mem.GraphTripleStoreBase;
import com.hp.hpl.jena.mem.faster.NodeToTriplesMapFaster;
import com.hp.hpl.jena.mem.faster.ProcessedTriple;
import java.util.Iterator;

public class FasterTripleStore
extends GraphTripleStoreBase
implements TripleStore {
    public FasterTripleStore(Graph parent) {
        super(parent, new NodeToTriplesMapFaster(Triple.Field.fieldSubject, Triple.Field.fieldPredicate, Triple.Field.fieldObject), new NodeToTriplesMapFaster(Triple.Field.fieldPredicate, Triple.Field.fieldObject, Triple.Field.fieldSubject), new NodeToTriplesMapFaster(Triple.Field.fieldObject, Triple.Field.fieldSubject, Triple.Field.fieldPredicate));
    }

    public NodeToTriplesMapFaster getSubjects() {
        return (NodeToTriplesMapFaster)this.subjects;
    }

    public NodeToTriplesMapFaster getPredicates() {
        return (NodeToTriplesMapFaster)this.predicates;
    }

    public NodeToTriplesMapFaster getObjects() {
        return (NodeToTriplesMapFaster)this.objects;
    }

    public Applyer createApplyer(ProcessedTriple pt) {
        if (pt.hasNoVariables()) {
            return this.containsApplyer(pt);
        }
        if (pt.S instanceof QueryNode.Fixed) {
            return this.getSubjects().createFixedSApplyer(pt);
        }
        if (pt.O instanceof QueryNode.Fixed) {
            return this.getObjects().createFixedOApplyer(pt);
        }
        if (pt.S instanceof QueryNode.Bound) {
            return this.getSubjects().createBoundSApplyer(pt);
        }
        if (pt.O instanceof QueryNode.Bound) {
            return this.getObjects().createBoundOApplyer(pt);
        }
        return this.varSvarOApplyer(pt);
    }

    protected Applyer containsApplyer(final ProcessedTriple pt) {
        return new Applyer(){

            public void applyToTriples(Domain d, Matcher m, StageElement next) {
                Triple t = new Triple(pt.S.finder(d), pt.P.finder(d), pt.O.finder(d));
                if (FasterTripleStore.this.objects.containsBySameValueAs(t)) {
                    next.run(d);
                }
            }
        };
    }

    protected Applyer varSvarOApplyer(final QueryTriple pt) {
        return new Applyer(){
            protected final QueryNode p;
            {
                this.p = pt.P;
            }

            public Iterator<Triple> find(Domain d) {
                Node P = this.p.finder(d);
                if (P.isConcrete()) {
                    return FasterTripleStore.this.predicates.iterator(P, Node.ANY, Node.ANY);
                }
                return FasterTripleStore.this.subjects.iterateAll();
            }

            @Override
            public void applyToTriples(Domain d, Matcher m, StageElement next) {
                Iterator<Triple> it = this.find(d);
                while (it.hasNext()) {
                    if (!m.match(d, it.next())) continue;
                    next.run(d);
                }
            }
        };
    }
}

