/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.common.internal.uritemplate.UriTemplateMatcher;
import org.apache.wink.server.handlers.HandlersChain;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.handlers.RequestHandler;
import org.apache.wink.server.internal.contexts.UriInfoImpl;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.registry.MethodRecord;
import org.apache.wink.server.internal.registry.ResourceInstance;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.apache.wink.server.internal.registry.SubResourceInstance;
import org.apache.wink.server.internal.registry.SubResourceMethodRecord;
import org.apache.wink.server.internal.registry.SubResourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindResourceMethodHandler
implements RequestHandler {
    private boolean isContinuedSearchPolicy;
    private static final Logger logger = LoggerFactory.getLogger(FindResourceMethodHandler.class);

    @Override
    public void handleRequest(MessageContext context, HandlersChain chain) throws Throwable {
        SearchResult result = context.getAttribute(SearchResult.class);
        ResourceInstance resource = result.getResource();
        if (resource.isExactMatch()) {
            logger.trace("Root resource @Path matches exactly so finding root resource method in {}", (Object)resource.getResourceClass().getName());
            this.handleResourceMethod(context, chain);
            return;
        }
        UriTemplateMatcher templateMatcher = resource.getMatcher();
        String tail = templateMatcher.getTail(false);
        if (tail == null) {
            tail = "";
        }
        if (tail.startsWith("/")) {
            tail = tail.substring(1);
        }
        logger.trace("Unmatched tail to the URI: {}", (Object)tail);
        List<SubResourceInstance> subResources = resource.getRecord().getMatchingSubResources(tail);
        logger.trace("Possible subresources found: {}", subResources);
        if (subResources.size() == 0) {
            result.setError(new WebApplicationException(Response.Status.NOT_FOUND));
            return;
        }
        List<SubResourceInstance> searchableSubResources = this.getSearchableSubResources(subResources);
        logger.trace("Possible searchable subresources found: {}", searchableSubResources);
        SearchResult.AccumulatedData originalData = result.getData();
        for (SubResourceInstance subResourceInstance : searchableSubResources) {
            SubResourceRecord subResourceRecord = subResourceInstance.getRecord();
            result.setData(originalData.clone());
            if (subResourceRecord instanceof SubResourceMethodRecord) {
                this.handleSubResourceMethod(subResourceInstance, subResources, context, chain);
                if (!result.isFound()) continue;
                return;
            }
            this.handleSubResourceLocator(subResourceInstance, subResources, context, chain);
            if (!result.isFound()) continue;
            return;
        }
    }

    private void handleResourceMethod(MessageContext context, HandlersChain chain) throws Throwable {
        ResourceRegistry registry = context.getAttribute(ResourceRegistry.class);
        SearchResult result = context.getAttribute(SearchResult.class);
        ResourceInstance resource = result.getResource();
        MethodRecord method = null;
        try {
            method = registry.findMethod(resource, context);
        }
        catch (WebApplicationException e) {
            result.setError(e);
            return;
        }
        result.setFound(true);
        result.setMethod(method);
        if (logger.isTraceEnabled()) {
            MethodMetadata metadata = method == null ? null : method.getMetadata();
            logger.trace("Found root resource method to invoke: {} ", metadata);
        }
        chain.doChain(context);
    }

    private void handleSubResourceMethod(SubResourceInstance subResourceInstance, List<SubResourceInstance> subResources, MessageContext context, HandlersChain chain) throws Throwable {
        ResourceRegistry registry = context.getAttribute(ResourceRegistry.class);
        SearchResult result = context.getAttribute(SearchResult.class);
        ResourceInstance resource = result.getResource();
        SubResourceRecord subResourceRecord = subResourceInstance.getRecord();
        String pattern = subResourceRecord.getTemplateProcessor().getPatternString();
        SubResourceInstance method = null;
        try {
            method = registry.findSubResourceMethod(pattern, subResources, resource, context);
        }
        catch (WebApplicationException e) {
            result.setError(e);
            return;
        }
        UriTemplateMatcher matcher = method.getMatcher();
        this.saveFoundMethod(result, matcher, method, context);
        if (logger.isTraceEnabled()) {
            MethodMetadata metadata = method == null ? null : method.getMetadata();
            logger.trace("Found subresource method to invoke: {} ", metadata);
        }
        chain.doChain(context);
    }

    private void handleSubResourceLocator(SubResourceInstance subResourceInstance, List<SubResourceInstance> subResources, MessageContext context, HandlersChain chain) throws Throwable {
        ResourceRegistry registry = context.getAttribute(ResourceRegistry.class);
        SearchResult result = context.getAttribute(SearchResult.class);
        UriTemplateMatcher matcher = subResourceInstance.getMatcher();
        this.saveFoundMethod(result, matcher, subResourceInstance, context);
        if (logger.isTraceEnabled()) {
            MethodMetadata metadata = subResourceInstance == null ? null : subResourceInstance.getMetadata();
            logger.trace("Found subresource locator to invoke: {} ", metadata);
        }
        chain.doChain(context);
        Object subResource = context.getResponseEntity();
        if (subResource == null) {
            logger.trace("Subresource returned was null so returning a 404 Not Found");
            result.setError(new WebApplicationException(Response.Status.NOT_FOUND));
            return;
        }
        ResourceRecord record = registry.getRecord(subResource, false);
        ResourceInstance resourceInstance = new ResourceInstance(subResource, record, matcher);
        result.getData().getMatchedResources().addFirst(resourceInstance);
        result.setFound(false);
        logger.trace("Re-invoking the chain (due to hitting a subresource locator method) with the new subresource instance {}", resourceInstance);
        this.handleRequest(context, chain);
    }

    private List<SubResourceInstance> getSearchableSubResources(List<SubResourceInstance> subResources) {
        LinkedList<SubResourceInstance> searchableSubResources = new LinkedList<SubResourceInstance>();
        if (!this.isContinuedSearchPolicy) {
            searchableSubResources.add(subResources.iterator().next());
        } else {
            searchableSubResources.addAll(subResources);
        }
        return searchableSubResources;
    }

    private void saveFoundMethod(SearchResult result, UriTemplateMatcher matcher, SubResourceInstance method, MessageContext context) {
        result.setFound(true);
        result.setMethod(method);
        matcher.storeVariables(result.getData().getMatchedVariables(), false);
        int offset = result.getData().calculateUriOffset();
        int headSegmentsCount = result.getData().addMatchedURI(matcher.getHead(false));
        List<PathSegment> segments = context.getUriInfo().getPathSegments(false);
        matcher.storeVariablesPathSegments(segments, offset, headSegmentsCount, result.getData().getMatchedVariablesPathSegments());
        UriInfoImpl uriInfoImpl = context.getAttribute(UriInfoImpl.class);
        if (uriInfoImpl != null && matcher.getVariables().size() > 0) {
            uriInfoImpl.resetPathParameters();
        }
    }

    @Override
    public void init(Properties props) {
        String property = props.getProperty("wink.searchPolicyContinuedSearch");
        this.isContinuedSearchPolicy = Boolean.valueOf(property);
    }
}

