/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.wink.common.internal.MultivaluedMapImpl;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.utils.ProviderUtils;
import org.apache.wink.server.handlers.AbstractHandler;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.internal.contexts.RequestImpl;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlushResultHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(FlushResultHandler.class);
    private static final RuntimeDelegate runtimeDelegate = RuntimeDelegate.getInstance();

    @Override
    public void handleResponse(MessageContext context) throws Throwable {
        int statusCode = context.getResponseStatusCode();
        if (statusCode < 0) {
            logger.trace("Status code was not set. Nothing to do.");
            return;
        }
        HttpServletResponse httpResponse = context.getAttribute(HttpServletResponse.class);
        if (httpResponse.isCommitted()) {
            logger.trace("The response is already committed. Nothing to do.");
            return;
        }
        logger.trace("Response status code set to: {}", statusCode);
        httpResponse.setStatus(statusCode);
        Object entity = context.getResponseEntity();
        boolean isOriginalEntityResponseObj = false;
        MultivaluedMap<String, Object> httpHeaders = null;
        if (entity instanceof Response) {
            Response response = (Response)entity;
            entity = response.getEntity();
            httpHeaders = response.getMetadata();
            isOriginalEntityResponseObj = true;
        }
        Type genericType = null;
        Annotation[] declaredAnnotations = null;
        SearchResult searchResult = context.getAttribute(SearchResult.class);
        if (searchResult != null && searchResult.isFound()) {
            Method reflectionMethod = searchResult.getMethod().getMetadata().getReflectionMethod();
            genericType = reflectionMethod.getGenericReturnType();
            declaredAnnotations = reflectionMethod.getDeclaredAnnotations();
        } else {
            declaredAnnotations = new Annotation[]{};
        }
        Class<?> rawType = null;
        if (entity instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)entity;
            entity = genericEntity.getEntity();
            rawType = genericEntity.getRawType();
            genericType = genericEntity.getType();
        } else {
            Class<?> clazz = rawType = entity != null ? entity.getClass() : null;
            if (isOriginalEntityResponseObj) {
                genericType = rawType;
            } else {
                Type type = genericType = genericType != null ? genericType : rawType;
            }
        }
        if (httpHeaders == null) {
            httpHeaders = new MultivaluedMapImpl<String, Object>();
        }
        if (entity == null) {
            logger.trace("No entity so writing only the headers");
            FlushResultHandler.flushHeaders(httpResponse, httpHeaders);
            return;
        }
        MediaType responseMediaType = context.getResponseMediaType();
        Providers providers = context.getProviders();
        MessageBodyWriter<?> messageBodyWriter = providers.getMessageBodyWriter(rawType, genericType, declaredAnnotations, responseMediaType);
        if (messageBodyWriter != null) {
            long size;
            if (logger.isTraceEnabled()) {
                logger.trace("Serialization using provider {}", (Object)messageBodyWriter.getClass().getName());
            }
            MultivaluedMap<String, Object> headers = httpHeaders;
            try {
                size = messageBodyWriter.getSize(entity, rawType, genericType, declaredAnnotations, responseMediaType);
            }
            catch (RuntimeException e) {
                ProviderUtils.logUserProviderException(e, messageBodyWriter, ProviderUtils.PROVIDER_EXCEPTION_ORIGINATOR.getSize, new Object[]{entity, rawType, genericType, declaredAnnotations, responseMediaType}, context);
                throw e;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{}@{}.getSize({}, {}, {}, {}, {}) returned {}", new Object[]{messageBodyWriter.getClass().getName(), Integer.toHexString(System.identityHashCode(messageBodyWriter)), Integer.toHexString(System.identityHashCode(entity)), rawType, genericType, declaredAnnotations, responseMediaType, size});
            }
            if (size >= 0L) {
                headers.putSingle("Content-Length", String.valueOf(size));
            }
            FlushHeadersOutputStream outputStream = new FlushHeadersOutputStream(httpResponse, headers, responseMediaType);
            if (logger.isTraceEnabled()) {
                logger.trace("{}@{}.writeTo({}, {}, {}, {}, {}, {}, {}) being called", new Object[]{messageBodyWriter.getClass().getName(), Integer.toHexString(System.identityHashCode(messageBodyWriter)), Integer.toHexString(System.identityHashCode(entity)), rawType, genericType, declaredAnnotations, responseMediaType, httpHeaders, outputStream});
            }
            try {
                messageBodyWriter.writeTo(entity, rawType, genericType, declaredAnnotations, responseMediaType, httpHeaders, outputStream);
            }
            catch (RuntimeException e) {
                ProviderUtils.logUserProviderException(e, messageBodyWriter, ProviderUtils.PROVIDER_EXCEPTION_ORIGINATOR.writeTo, new Object[]{entity, rawType, genericType, declaredAnnotations, responseMediaType, httpHeaders, outputStream}, context);
                throw e;
            }
            logger.trace("Flushing headers if not written");
            outputStream.flushHeaders();
            return;
        }
        logger.trace("Could not find a writer for {} and {}. Try to find JAF DataSourceProvider", (Object)entity.getClass().getName(), (Object)responseMediaType);
        DataContentHandler dataContentHandler = null;
        dataContentHandler = CommandMap.getDefaultCommandMap().createDataContentHandler(responseMediaType.getType() + "/" + responseMediaType.getSubtype());
        if (dataContentHandler == null) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("noWriterOrDataSourceProvider", entity.getClass().getName(), responseMediaType));
            }
            throw new WebApplicationException(500);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Serialization using data content handler {}", (Object)dataContentHandler.getClass().getName());
        }
        FlushHeadersOutputStream outputStream = new FlushHeadersOutputStream(httpResponse, httpHeaders, responseMediaType);
        if (logger.isTraceEnabled()) {
            logger.trace("{}@{}.writeTo({}, {}, {}) being called", new Object[]{dataContentHandler.getClass().getName(), Integer.toHexString(System.identityHashCode(dataContentHandler)), entity, responseMediaType.toString(), outputStream});
        }
        dataContentHandler.writeTo(entity, responseMediaType.getType() + "/" + responseMediaType.getSubtype(), outputStream);
        logger.trace("Flushing headers if not written");
        outputStream.flushHeaders();
    }

    private static void flushHeaders(HttpServletResponse httpResponse, MultivaluedMap<String, Object> headers) {
        RequestImpl.VaryHeader varyHeader;
        if (headers.get("Vary") == null && (varyHeader = RuntimeContextTLS.getRuntimeContext().getAttribute(RequestImpl.VaryHeader.class)) != null) {
            logger.trace("Vary header automatically set by a call to RequestImpl");
            headers.putSingle("Vary", varyHeader.getVaryHeaderValue());
        }
        logger.trace("Flushing headers: {}", headers);
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            for (Object val : values) {
                if (val == null) continue;
                RuntimeDelegate.HeaderDelegate<?> headerDelegate = runtimeDelegate.createHeaderDelegate(val.getClass());
                String header = headerDelegate != null ? headerDelegate.toString(val) : val.toString();
                httpResponse.addHeader(key, header);
            }
        }
    }

    @Override
    public void init(Properties props) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FlushHeadersOutputStream
    extends OutputStream {
        private boolean writeStarted = false;
        private final HttpServletResponse httpResponse;
        private final ServletOutputStream outputStream;
        private final MultivaluedMap<String, Object> headers;
        private final MediaType responseMediaType;

        public FlushHeadersOutputStream(HttpServletResponse httpResponse, MultivaluedMap<String, Object> headers, MediaType responseMediaType) throws IOException {
            this.httpResponse = httpResponse;
            this.outputStream = httpResponse.getOutputStream();
            this.headers = headers;
            this.responseMediaType = responseMediaType;
        }

        @Override
        public void write(int b) throws IOException {
            this.flushHeaders();
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.flushHeaders();
            this.outputStream.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.flushHeaders();
            this.outputStream.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.flushHeaders();
            this.outputStream.flush();
        }

        @Override
        public void close() throws IOException {
            this.flushHeaders();
            this.outputStream.close();
        }

        private void flushHeaders() {
            if (!this.writeStarted) {
                if (this.httpResponse.getContentType() == null) {
                    logger.trace("Set response Content-Type to: {} ", this.responseMediaType);
                    this.httpResponse.setContentType(this.responseMediaType.toString());
                }
                FlushResultHandler.flushHeaders(this.httpResponse, this.headers);
                this.writeStarted = true;
            }
        }
    }
}

