/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.log;

import java.util.List;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.server.internal.log.LogUtilities;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources {
    private static final Logger logger = LoggerFactory.getLogger(Resources.class);
    private final ResourceRegistry resourceRegistry;

    public Resources(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    public void log() {
        logger.trace("log() entry");
        try {
            if (logger.isInfoEnabled()) {
                List<ResourceRecord> resourceRecords = this.resourceRegistry.getRecords();
                this.logResourceInfo(resourceRecords);
                if (logger.isDebugEnabled()) {
                    if (resourceRecords.isEmpty()) {
                        logger.debug("There are no @javax.ws.rs.Path annotated classes defined in the application.");
                    }
                    LogUtilities.logResourceMetadata(resourceRecords, logger, false, false);
                }
            }
        }
        catch (Exception e) {
            logger.trace("Could not produce all the resource metadata.", e);
        }
        logger.trace("log() exit");
    }

    private void logResourceInfo(List<ResourceRecord> resourceRecords) {
        for (ResourceRecord record : resourceRecords) {
            try {
                String resourceClassName = record.getMetadata().getResourceClass().getName();
                ClassMetadata resourceMetadata = record.getMetadata();
                String resourcePath = resourceMetadata.getPath();
                logger.info(Messages.getMessage("serverRegisterJAXRSResourceWithPath", resourceClassName, resourcePath));
            }
            catch (Exception e) {
                logger.trace("Could not print all of the resource metadata.", e);
            }
        }
    }
}

