/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.jazz;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.apache.wink.client.ClientResponse;
import org.eclipse.lyo.client.exception.ResourceNotFoundException;
import org.eclipse.lyo.client.exception.RootServicesException;
import org.eclipse.lyo.client.oslc.OslcClient;
import org.eclipse.lyo.client.oslc.OslcOAuthClient;
import org.eclipse.lyo.client.oslc.jazz.JazzFormAuthClient;

public class JazzRootServicesHelper {
    private String baseUrl;
    private String rootServicesUrl;
    private String catalogDomain;
    private String catalogNamespace;
    private String catalogProperty;
    private String catalogUrl;
    private Collection<Object[]> catalogs = new ArrayList<Object[]>();
    String authorizationRealm;
    String requestTokenUrl;
    String authorizationTokenUrl;
    String accessTokenUrl;
    private static final String JFS_NAMESPACE = "http://jazz.net/xmlns/prod/jazz/jfs/1.0/";
    private static final String JD_NAMESPACE = "http://jazz.net/xmlns/prod/jazz/discovery/1.0/";
    private static final Logger logger = Logger.getLogger(JazzRootServicesHelper.class.getName());

    public JazzRootServicesHelper(String url, String catalogDomain) throws RootServicesException {
        this.baseUrl = url;
        this.rootServicesUrl = this.baseUrl + "/rootservices";
        this.catalogDomain = catalogDomain;
        if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/xmlns/cm/1.0/") || this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/cm#")) {
            this.catalogNamespace = "http://open-services.net/xmlns/cm/1.0/";
            this.catalogProperty = "cmServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/xmlns/qm/1.0/") || this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/qm#")) {
            this.catalogNamespace = "http://open-services.net/xmlns/qm/1.0/";
            this.catalogProperty = "qmServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/xmlns/rm/1.0/") || this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/rm#")) {
            this.catalogNamespace = "http://open-services.net/xmlns/rm/1.0/";
            this.catalogProperty = "rmServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/auto#")) {
            this.catalogNamespace = "http://open-services.net/ns/auto#";
            this.catalogProperty = "autoServiceProviders";
        } else {
            logger.severe("Jazz rootservices only supports CM, RM, QM, and Automation catalogs");
        }
        this.processRootServices();
    }

    public String getCatalogUrl() {
        return this.catalogUrl;
    }

    public OslcOAuthClient initOAuthClient(String consumerKey, String secret) {
        return new OslcOAuthClient(this.requestTokenUrl, this.authorizationTokenUrl, this.accessTokenUrl, consumerKey, secret, this.authorizationRealm);
    }

    public JazzFormAuthClient initFormClient(String userid, String password) {
        return new JazzFormAuthClient(this.baseUrl, userid, password);
    }

    public JazzFormAuthClient initFormClient(String userid, String password, String authUrl) {
        return new JazzFormAuthClient(this.baseUrl, authUrl, userid, password);
    }

    private void processRootServices() throws RootServicesException {
        try {
            OslcClient rootServicesClient = new OslcClient();
            ClientResponse response = rootServicesClient.getResource(this.rootServicesUrl, "application/rdf+xml");
            InputStream is = response.getEntity(InputStream.class);
            Model rdfModel = ModelFactory.createDefaultModel();
            rdfModel.read(is, this.rootServicesUrl);
            this.catalogUrl = this.getRootServicesProperty(rdfModel, this.catalogNamespace, this.catalogProperty);
            this.requestTokenUrl = this.getRootServicesProperty(rdfModel, JFS_NAMESPACE, "oauthRequestTokenUrl");
            this.authorizationTokenUrl = this.getRootServicesProperty(rdfModel, JFS_NAMESPACE, "oauthUserAuthorizationUrl");
            this.accessTokenUrl = this.getRootServicesProperty(rdfModel, JFS_NAMESPACE, "oauthAccessTokenUrl");
            try {
                this.authorizationRealm = this.getRootServicesProperty(rdfModel, JFS_NAMESPACE, "oauthRealmName");
            }
            catch (ResourceNotFoundException e) {}
        }
        catch (Exception e) {
            throw new RootServicesException(this.baseUrl, e);
        }
    }

    private String getRootServicesProperty(Model rdfModel, String namespace, String predicate) throws ResourceNotFoundException {
        String returnVal = null;
        Property prop = rdfModel.createProperty(namespace, predicate);
        Statement stmt = rdfModel.getProperty((Resource)null, prop);
        if (stmt != null && stmt.getObject() != null) {
            returnVal = ((Object)stmt.getObject()).toString();
        }
        if (returnVal == null) {
            throw new ResourceNotFoundException(this.baseUrl, namespace + predicate);
        }
        return returnVal;
    }
}

