/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.internal.CertificateHandlerExtensionReader;
import com.ibm.team.repository.client.internal.ClientLibraryFactoryRegistry;
import com.ibm.team.repository.client.internal.LoginHandlerExtensionReader;
import com.ibm.team.repository.client.internal.LoginInfoExtensionReader;
import com.ibm.team.repository.client.internal.TeamPlatformConstants;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class TeamPlatformActivator
implements BundleActivator {
    public void start(BundleContext context) throws Exception {
        this.startExtensionRegistries();
        TeamPlatformConstants.initializeEventSourceTPE();
    }

    private void startExtensionRegistries() {
        ClientLibraryFactoryRegistry.INSTANCE.start();
        LoginHandlerExtensionReader.INSTANCE.start();
        CertificateHandlerExtensionReader.INSTANCE.start();
        LoginInfoExtensionReader.INSTANCE.start();
    }

    public void stop(BundleContext context) throws Exception {
        ITeamRepository[] repos;
        this.stopExtensionReaders();
        ITeamRepository[] iTeamRepositoryArray = repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo = iTeamRepositoryArray[n2];
            repo.logout();
            ++n2;
        }
        TeamPlatformConstants.shutDownEventSourceTPE();
    }

    private void stopExtensionReaders() {
        CertificateHandlerExtensionReader.INSTANCE.stop();
        LoginHandlerExtensionReader.INSTANCE.stop();
        ClientLibraryFactoryRegistry.INSTANCE.stop();
        LoginInfoExtensionReader.INSTANCE.stop();
    }
}

