/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.sql;

import com.urbancode.sql.LoggingTransaction;
import com.urbancode.sql.XADataSourceAdapter;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingTransactionManager
implements TransactionManager {
    private static final Logger log = LoggerFactory.getLogger(XADataSourceAdapter.class);
    private TransactionManager delegate;

    public void setDelegate(TransactionManager delegate) {
        if (log.isTraceEnabled()) {
            log.trace("setDelegate");
        }
        this.delegate = delegate;
    }

    public void begin() throws NotSupportedException, SystemException {
        if (log.isTraceEnabled()) {
            log.trace("begin()");
        }
        if (log.isDebugEnabled()) {
            log.debug("Beginning JTA Transaction");
        }
        this.delegate.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        if (log.isTraceEnabled()) {
            log.trace("commit()");
        }
        if (log.isDebugEnabled()) {
            log.debug("Committing JTA Transaction");
        }
        this.delegate.commit();
    }

    public int getStatus() throws SystemException {
        if (log.isTraceEnabled()) {
            log.trace("getStatus()");
        }
        return this.delegate.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        if (log.isTraceEnabled()) {
            log.trace("getTransaction()");
        }
        return new LoggingTransaction(this.delegate.getTransaction());
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, SystemException {
        if (log.isTraceEnabled()) {
            log.trace("resume()");
        }
        if (log.isDebugEnabled()) {
            log.debug("Resuming JTA Transaction");
        }
        Transaction tx = transaction;
        if (transaction instanceof LoggingTransaction) {
            tx = ((LoggingTransaction)transaction).getDelegate();
        }
        this.delegate.resume(tx);
    }

    public void rollback() throws SystemException {
        if (log.isTraceEnabled()) {
            log.trace("rollback()");
        }
        if (log.isDebugEnabled()) {
            log.debug("Rolling-back JTA Transaction");
        }
        this.delegate.rollback();
    }

    public void setRollbackOnly() throws SystemException {
        if (log.isTraceEnabled()) {
            log.trace("setRollbackOnly()");
        }
        this.delegate.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        if (log.isTraceEnabled()) {
            log.trace("setTransactionTimeout()");
        }
        this.delegate.setTransactionTimeout(timeout);
    }

    public Transaction suspend() throws SystemException {
        if (log.isTraceEnabled()) {
            log.trace("suspend()");
        }
        if (log.isDebugEnabled()) {
            log.debug("Suspending JTA Transaction");
        }
        return this.delegate.suspend();
    }
}

