/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class HttpHeaders {
    private Map<String, String> fData;

    public HttpHeaders() {
        this.fData = new HashMap<String, String>();
    }

    public HttpHeaders(int initialSize) {
        this.fData = new HashMap<String, String>(initialSize);
    }

    public HttpHeaders(Map<String, String> headers) {
        this();
        if (headers != null) {
            for (Map.Entry<String, String> cur : headers.entrySet()) {
                this.addHeader(cur.getKey(), cur.getValue());
            }
        }
    }

    public void addHeader(String header, String value) {
        this.fData.put(this.toLowerCase(header), value);
    }

    public boolean contains(String header) {
        return this.fData.containsKey(this.toLowerCase(header));
    }

    public String getValue(String header) {
        return this.fData.get(this.toLowerCase(header));
    }

    public Set<Map.Entry<String, String>> getEntries() {
        return this.fData.entrySet();
    }

    public int size() {
        return this.fData.size();
    }

    private String toLowerCase(String header) {
        return header != null ? header.toLowerCase() : null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fData == null ? 0 : this.fData.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpHeaders other = (HttpHeaders)obj;
        return !(this.fData == null ? other.fData != null : !this.fData.equals(other.fData));
    }

    public static String getAcceptLanguageHeader(Locale locale) {
        String variant;
        StringBuilder buffer = new StringBuilder(locale.getLanguage());
        String country = locale.getCountry();
        if (country.length() > 0) {
            buffer.append('-').append(country);
        }
        if ((variant = locale.getVariant()).length() > 0) {
            buffer.append('-').append(variant);
        }
        return buffer.toString();
    }
}

