/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.transport.AbstractElementDescriptor;
import com.ibm.team.repository.common.transport.TeamServiceRegistryException;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public class CALMLinkTypeInformationRegistry {
    private static CALMLinkTypeInformationRegistry fgInstance;
    private final Map<String, CALMLinkTypeInformation> fCALMLinkTypeExtensions = new HashMap<String, CALMLinkTypeInformation>();

    private static CALMLinkTypeInformationRegistry getInstance() {
        if (fgInstance == null) {
            fgInstance = new CALMLinkTypeInformationRegistry();
            fgInstance.initialize();
        }
        return fgInstance;
    }

    public static CALMLinkTypeInformation getLinkTypeInformation(String linkTypeId) {
        return CALMLinkTypeInformationRegistry.getInstance().getCALMLinkType(linkTypeId);
    }

    public static boolean hasLinkTypeInformation(String linkTypeId) {
        return CALMLinkTypeInformationRegistry.getInstance().containsCALMLinkType(linkTypeId);
    }

    public static CALMLinkTypeInformation getLinkTypeInformation(ILinkType linkType) {
        return linkType != null ? CALMLinkTypeInformationRegistry.getInstance().getCALMLinkType(linkType.getLinkTypeId()) : null;
    }

    public static boolean hasLinkTypeInformation(ILinkType linkType) {
        return linkType != null ? CALMLinkTypeInformationRegistry.getInstance().containsCALMLinkType(linkType.getLinkTypeId()) : false;
    }

    public static List<CALMLinkTypeInformation> getAllLinkTypeInformations(IItemType linkSourceItemType) {
        ArrayList<CALMLinkTypeInformation> result = new ArrayList<CALMLinkTypeInformation>(7);
        if (linkSourceItemType != null) {
            for (CALMLinkTypeInformation curType : CALMLinkTypeInformationRegistry.getInstance().getCALMLinkTypes()) {
                if (!linkSourceItemType.equals(curType.getSourceItemType())) continue;
                result.add(curType);
            }
        }
        return result;
    }

    private CALMLinkTypeInformationRegistry() {
    }

    private CALMLinkTypeInformation getCALMLinkType(String linkTypeId) {
        return this.fCALMLinkTypeExtensions.get(linkTypeId);
    }

    private Collection<CALMLinkTypeInformation> getCALMLinkTypes() {
        return this.fCALMLinkTypeExtensions.values();
    }

    private boolean containsCALMLinkType(String linkTypeId) {
        return this.fCALMLinkTypeExtensions.containsKey(linkTypeId);
    }

    private void initialize() {
        new CALMLinkTypeExtensionRegistryReader().start();
    }

    private void addCALMLinkType(CALMLinkTypeInformation description) {
        this.fCALMLinkTypeExtensions.put(description.getItemLinkTypeId(), description);
    }

    private class CALMLinkTypeExtensionDescriptor
    extends AbstractElementDescriptor {
        private final FoundationLog LOGGER;
        private static final String ELEMENT = "calmLinkTypes";
        private static final String LINK_TYPE_ELEMENT = "calmLinkType";
        private static final String ATTR_LINK_TYPE_ID = "linkTypeId";
        private static final String ATTR_PROJECT_LINK_TYPE = "projectLinkType";
        private static final String ATTR_TARGET_RESOURCE_ID = "targetResourceId";
        private static final String ATTR_TARGET_RESOURCE_BACK_LINK_PROPERTY = "targetResourceBackLinkProperty";
        private static final String ATTR_SUPPORTS_LOCAL_LINKS = "supportsLocalLinks";
        private static final String ELEM_PICKER_CONFIG = "picker";
        private static final String ATTR_PICKER_TYPE = "type";
        private static final String ATTR_PICKER_ID = "id";
        private static final String TYPE_CREATION = "creation";
        private static final String TYPE_SELECTION = "selection";

        protected CALMLinkTypeExtensionDescriptor(IConfigurationElement element) {
            super(element, ELEMENT);
            this.LOGGER = FoundationLog.getLog(ExtensionRegistryReader.class);
        }

        void remove() throws TeamServiceRegistryException {
        }

        protected void processChild(IConfigurationElement child) {
            String elementName = child.getName();
            if (elementName.equals(LINK_TYPE_ELEMENT)) {
                String linkTypeId = child.getAttribute(ATTR_LINK_TYPE_ID);
                ILinkType linkType = ILinkTypeRegistry.INSTANCE.getLinkType(linkTypeId);
                if (linkType != null) {
                    String projectLinkType = child.getAttribute(ATTR_PROJECT_LINK_TYPE);
                    String targetResourceId = child.getAttribute(ATTR_TARGET_RESOURCE_ID);
                    String targetResourceBackLinkProperty = child.getAttribute(ATTR_TARGET_RESOURCE_BACK_LINK_PROPERTY);
                    String supportLocalLinksStr = child.getAttribute(ATTR_SUPPORTS_LOCAL_LINKS);
                    boolean supportLocalLinks = supportLocalLinksStr != null && Boolean.parseBoolean(supportLocalLinksStr);
                    IConfigurationElement[] pickerConf = child.getChildren(ELEM_PICKER_CONFIG);
                    ArrayList<String> creationPickerIds = new ArrayList<String>(1);
                    ArrayList<String> selectionPickerIds = new ArrayList<String>(1);
                    if (pickerConf != null) {
                        IConfigurationElement[] iConfigurationElementArray = pickerConf;
                        int n = pickerConf.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfigurationElement pickerElement = iConfigurationElementArray[n2];
                            String pickerType = pickerElement.getAttribute(ATTR_PICKER_TYPE);
                            String pickerId = pickerElement.getAttribute(ATTR_PICKER_ID);
                            if (TYPE_CREATION.equals(pickerType)) {
                                creationPickerIds.add(pickerId);
                            } else if (TYPE_SELECTION.equals(pickerType)) {
                                selectionPickerIds.add(pickerId);
                            }
                            ++n2;
                        }
                    }
                    CALMLinkTypeInformationRegistry.this.addCALMLinkType(new CALMLinkTypeInformation(linkType, projectLinkType, targetResourceId, targetResourceBackLinkProperty, selectionPickerIds, creationPickerIds, supportLocalLinks));
                } else {
                    this.LOGGER.error("CALMLinkTypeRegistry: Link type {0} is not defined", null);
                }
            } else {
                super.processChild(child);
            }
        }
    }

    private class CALMLinkTypeExtensionRegistryReader
    extends ExtensionRegistryReader<CALMLinkTypeExtensionDescriptor> {
        private static final String EXTENSION_POINT_ID = "calmLinkTypeInformations";

        CALMLinkTypeExtensionRegistryReader() {
            super("com.ibm.team.calm.foundation.common", EXTENSION_POINT_ID);
        }

        protected CALMLinkTypeExtensionDescriptor handleExtensionAdded(IConfigurationElement element) throws TeamServiceRegistryException {
            return new CALMLinkTypeExtensionDescriptor(element);
        }

        protected void handleExtensionRemoved(IConfigurationElement element, CALMLinkTypeExtensionDescriptor descriptor) throws TeamServiceRegistryException {
            descriptor.remove();
        }
    }
}

