/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.Size;
import com.ibm.team.calm.foundation.common.internal.linking.Messages;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import java.util.Set;

public class PickerDescription {
    private static final String[] OSLC1_CM_RESOURCE_LABELS = new String[]{Messages.getString("PickerDescription_LABEL_REQUIREMENT_CHANGE_REQUEST"), Messages.getString("PickerDescription_LABEL_CHANGE_REQUEST"), Messages.getString("PickerDescription_LABEL_PLAN_ITEM"), Messages.getString("PickerDescription_LABEL_DEFECT"), Messages.getString("PickerDescription_LABEL_TASK")};
    private static final String[] OSLC1_QM_RESOURCE_LABELS = new String[]{Messages.getString("PickerDescription_LABEL_TEST_CASE"), Messages.getString("PickerDescription_LABEL_TEST_EXECUTION"), Messages.getString("PickerDescription_LABEL_TEST_RESULT"), Messages.getString("PickerDescription_LABEL_TEST_SCRIPT"), Messages.getString("PickerDescription_LABEL_TEST_PLAN")};
    private static final String[] OSLC1_RM_RESOURCE_LABELS = new String[]{Messages.getString("PickerDescription_LABEL_REQUIREMENT"), Messages.getString("PickerDescription_LABEL_COLLECTION")};
    private final String fTitle;
    private final String fPickerURL;
    private final String fWidthHint;
    private final String fHeightHint;
    private final String fResultNamespace;
    private final Set<String> fIdentifiers;
    private final boolean fIsDefault;
    private final OSLCResourceDescription.PickerType fPickerType;
    private final String fLabel;
    private Size fConvertedSize;

    public PickerDescription(String title, String label, String pickerURL, String widthHint, String heightHint, String resultNamespace) {
        this(title, label, pickerURL, widthHint, heightHint, resultNamespace, OSLCResourceDescription.PickerType.SELECTION, null, false);
    }

    public PickerDescription(String title, String label, String pickerURL, String widthHint, String heightHint, String resultNamespace, OSLCResourceDescription.PickerType pickerType, Set<String> identifiers, boolean isDefault) {
        this.fTitle = title;
        this.fLabel = label;
        this.fPickerURL = pickerURL;
        this.fWidthHint = widthHint;
        this.fHeightHint = heightHint;
        this.fResultNamespace = resultNamespace;
        this.fPickerType = pickerType;
        this.fIdentifiers = identifiers;
        this.fIsDefault = isDefault;
        this.fConvertedSize = null;
    }

    public OSLCResourceDescription.PickerType getPickerType() {
        return this.fPickerType;
    }

    public String getPickerURL() {
        return this.fPickerURL;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public String getLabel() {
        if (this.fLabel == null || this.fLabel.length() == 0) {
            String label;
            if (!"oslc".equals(this.fResultNamespace) && (label = this.findAssociatedLabel(this.getTitle())) != null) {
                return label;
            }
            return this.getTitle();
        }
        return this.fLabel;
    }

    public String getWidthHintString() {
        return this.fWidthHint;
    }

    private Size getConvertedSize() {
        if (this.fConvertedSize == null) {
            this.fConvertedSize = Size.parse(this.fWidthHint, this.fHeightHint, new Size(-1, -1, Size.SizeUnit.px));
        }
        return this.fConvertedSize;
    }

    public int getWidthHintInPixels(int defaultWidth) {
        Size convertedSize = this.getConvertedSize();
        if (convertedSize.getWidth() != -1) {
            return convertedSize.getWidth(Size.SizeUnit.px);
        }
        return defaultWidth;
    }

    public String getHeightHintString() {
        return this.fHeightHint;
    }

    public int getHeightHintInPixels(int defaultHeight) {
        Size convertedSize = this.getConvertedSize();
        if (convertedSize.getHeight() != -1) {
            return convertedSize.getHeight(Size.SizeUnit.px);
        }
        return defaultHeight;
    }

    public String getResultNamespace() {
        return this.fResultNamespace;
    }

    public Set<String> getIdentifiers() {
        return this.fIdentifiers;
    }

    public boolean isDefault() {
        return this.fIsDefault;
    }

    private String findAssociatedLabel(String title) {
        block7: {
            block8: {
                block6: {
                    if (!"oslc_cm".equals(this.fResultNamespace)) break block6;
                    String[] stringArray = OSLC1_CM_RESOURCE_LABELS;
                    int n = OSLC1_CM_RESOURCE_LABELS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String cur = stringArray[n2];
                        if (title.toLowerCase().contains(cur.toLowerCase())) {
                            return cur;
                        }
                        ++n2;
                    }
                    break block7;
                }
                if (!"oslc_qm".equals(this.fResultNamespace)) break block8;
                String[] stringArray = OSLC1_QM_RESOURCE_LABELS;
                int n = OSLC1_QM_RESOURCE_LABELS.length;
                int n3 = 0;
                while (n3 < n) {
                    String cur = stringArray[n3];
                    if (title.toLowerCase().contains(cur.toLowerCase())) {
                        return cur;
                    }
                    ++n3;
                }
                break block7;
            }
            if (!"oslc_rm".equals(this.fResultNamespace)) break block7;
            String[] stringArray = OSLC1_RM_RESOURCE_LABELS;
            int n = OSLC1_RM_RESOURCE_LABELS.length;
            int n4 = 0;
            while (n4 < n) {
                String cur = stringArray[n4];
                if (title.toLowerCase().contains(cur.toLowerCase())) {
                    return cur;
                }
                ++n4;
            }
        }
        return null;
    }

    public static enum SizeUnit {
        px,
        em;

    }
}

