/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.dbhm;

import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.internal.repository.rcp.dbhm.DiskBackedHashMap;
import com.ibm.team.internal.repository.rcp.dbhm.HeapADT;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CachedDiskBackedHashMap<K, V>
extends DiskBackedHashMap<K, V> {
    protected int maxCacheSize = 1000;
    protected CachedEntry head;
    protected Map<K, CachedEntry> keyCache;
    protected Map<Long, CachedEntry> offsetCache;
    protected Map<Long, CachedEntry> keyOffsetCache;
    protected int numCachedEntries;
    protected long tableCacheTime;

    public CachedDiskBackedHashMap(long initialCapacity, double loadFactor, int maxCacheSize) {
        super(initialCapacity, loadFactor);
        this.maxCacheSize = maxCacheSize;
    }

    public CachedDiskBackedHashMap(long initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CachedDiskBackedHashMap(long initialCapacity) {
        super(initialCapacity);
    }

    public CachedDiskBackedHashMap() {
    }

    public CachedDiskBackedHashMap(Map<? extends K, ? extends V> t) {
        super(t);
    }

    @Override
    protected void init() throws IOException {
        if (this.keyCache == null) {
            this.keyCache = new HashMap<K, CachedEntry>((int)((double)this.maxCacheSize / 0.75), 0.75f);
            this.offsetCache = new HashMap<Long, CachedEntry>((int)((double)this.maxCacheSize / 0.75), 0.75f);
            this.keyOffsetCache = new HashMap<Long, CachedEntry>((int)((double)this.maxCacheSize / 0.75), 0.75f);
            this.head = new CachedEntry();
        } else {
            this.keyCache.clear();
            this.offsetCache.clear();
            this.keyOffsetCache.clear();
        }
        this.numCachedEntries = 0;
        this.head.nextEntry = this.head;
        this.head.prevEntry = this.head;
        super.init();
    }

    @Override
    protected DiskBackedHashMap.Entry putNew(K key, V value, DiskBackedHashMap.Entry predecessor) throws IOException {
        CachedEntry newEntry = (CachedEntry)super.putNew(key, value, predecessor);
        newEntry.key = key;
        newEntry.keyState = 1;
        newEntry.value = value;
        newEntry.valueState = 1;
        this.addToCache(newEntry);
        return newEntry;
    }

    private void addToCache(CachedEntry entry) throws IOException {
        this.offsetCache.put(entry.offset, entry);
        this.keyOffsetCache.put(entry.keyOffset, entry);
        if (entry.keyState != 0) {
            this.keyCache.put(entry.key, entry);
        }
        if (entry.nextEntry != null) {
            entry.nextEntry.prevEntry = entry.prevEntry;
            entry.prevEntry.nextEntry = entry.nextEntry;
        } else {
            ++this.numCachedEntries;
        }
        entry.nextEntry = this.head.nextEntry;
        entry.prevEntry = this.head;
        this.head.nextEntry = entry;
        entry.nextEntry.prevEntry = entry;
        this.commitLRU();
    }

    @Override
    protected DiskBackedHashMap.EntryResult getEntry(Object key) throws IOException {
        DiskBackedHashMap.EntryResult result;
        CachedEntry entry = this.keyCache.get(key);
        if (entry == null) {
            result = super.getEntry(key);
            entry = (CachedEntry)result.entry;
        } else {
            result = new DiskBackedHashMap.EntryResult(this, null, entry);
        }
        if (entry != null) {
            this.addToCache(entry);
        }
        return result;
    }

    @Override
    protected DiskBackedHashMap.Entry getTableEntry(long offset, long tableOffset) throws IOException {
        CachedEntry entry = this.offsetCache.get(offset + 1L);
        if (entry == null) {
            entry = (CachedEntry)super.getTableEntry(offset, tableOffset);
        }
        return entry;
    }

    @Override
    protected DiskBackedHashMap.Entry getEntry(long offset, long prevEntryOffset) throws IOException {
        CachedEntry entry = this.offsetCache.get(offset);
        if (entry == null) {
            entry = (CachedEntry)super.getEntry(offset, prevEntryOffset);
        }
        return entry;
    }

    @Override
    protected DiskBackedHashMap.Entry getCachedEntry(long offset) {
        return this.offsetCache.get(offset);
    }

    @Override
    protected void removeEntry(DiskBackedHashMap.Entry e) throws IOException {
        CachedEntry entry = (CachedEntry)e;
        this.removeEntry(entry, false);
        super.removeEntry(entry);
    }

    protected void commitLRU() throws IOException {
        if (this.numCachedEntries <= this.maxCacheSize) {
            return;
        }
        this.removeEntry(this.head.prevEntry, true);
    }

    protected void flushCache() throws IOException {
        CachedEntry e = this.head.nextEntry;
        while (e != this.head) {
            this.flushEntry(e);
            e = e.nextEntry;
        }
    }

    protected void removeEntry(CachedEntry ejectedEntry, boolean writeDirty) throws IOException {
        if (ejectedEntry.nextEntry == null) {
            return;
        }
        ejectedEntry.nextEntry.prevEntry = ejectedEntry.prevEntry;
        ejectedEntry.prevEntry.nextEntry = ejectedEntry.nextEntry;
        if (ejectedEntry.keyState != 0) {
            this.keyCache.remove(ejectedEntry.key);
        }
        this.offsetCache.remove(ejectedEntry.offset);
        this.keyOffsetCache.remove(ejectedEntry.keyOffset);
        ejectedEntry.nextEntry = null;
        ejectedEntry.prevEntry = null;
        if (writeDirty) {
            this.flushEntry(ejectedEntry);
        }
        --this.numCachedEntries;
    }

    protected void flushEntry(CachedEntry e) throws IOException {
        if (e.flush() && e.prevEntryOffset == -1L) {
            ++this.tableCacheTime;
        }
    }

    @Override
    protected DiskBackedHashMap.Entry createEntry(long offset, int hashCode, long keyOffset, boolean isKeyHeapADT, long valueOffset, boolean isValueHeapADT, long nextEntryOffset, long prevEntryOffset) {
        return new CachedEntry(offset, hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, nextEntryOffset, prevEntryOffset);
    }

    @Override
    protected DiskBackedHashMap.Entry createNewEntry(long offset, int hashCode, long keyOffset, boolean isKeyHeapADT, long valueOffset, boolean isValueHeapADT, long nextEntryOffset, long prevEntryOffset) throws IOException {
        CachedEntry existing = this.keyOffsetCache.get(keyOffset);
        if (existing != null) {
            existing.moved(offset, nextEntryOffset, prevEntryOffset);
            return existing;
        }
        return super.createNewEntry(offset, hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, nextEntryOffset, prevEntryOffset);
    }

    @Override
    protected DiskBackedHashMap.EntryIterator newEntryIterator() {
        return new CachedEntryIterator();
    }

    protected class CachedEntry
    extends DiskBackedHashMap.Entry {
        private static final int NOT_FETCHED = 0;
        private static final int CLEAN = 1;
        private static final int DIRTY = 2;
        protected CachedEntry nextEntry;
        protected CachedEntry prevEntry;
        protected int keyState;
        protected K key;
        protected int valueState;
        protected V value;
        private Object origValue;
        private int offsetState;
        private long origNextEntryOffset;
        private int nextEntryOffsetState;

        public CachedEntry() {
            super(CachedDiskBackedHashMap.this, -1L, 0, -1L, false, -1L, false, -1L, -1L);
        }

        public CachedEntry(long offset, int hashCode, long keyOffset, boolean isKeyHeapADT, long valueOffset, boolean isValueHeapADT, long nextEntryOffset, long prevEntryOffset) {
            super(CachedDiskBackedHashMap.this, offset, hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, nextEntryOffset, prevEntryOffset);
            this.nextEntry = null;
            this.prevEntry = null;
            this.keyState = 0;
            this.key = null;
            this.valueState = 0;
            this.value = null;
            this.origValue = null;
            this.offsetState = 1;
            this.origNextEntryOffset = nextEntryOffset;
            this.nextEntryOffsetState = 1;
        }

        @Override
        public K getKey() {
            if (this.keyState == 0) {
                this.key = super.getKey();
                this.keyState = 1;
                if (this.nextEntry != null) {
                    CachedDiskBackedHashMap.this.keyCache.put(this.key, this);
                }
            }
            return this.key;
        }

        @Override
        public V getValue() {
            if (this.valueState == 0) {
                this.value = super.getValue();
                this.origValue = this.value;
                this.valueState = 1;
            }
            return this.value;
        }

        @Override
        public V setValue(V value) {
            if (this.nextEntry != null) {
                Object oldValue = this.getValue();
                try {
                    if (oldValue != value && this.valueIsHeapADT) {
                        ((HeapADT)oldValue).delete();
                    }
                }
                catch (IOException e) {
                    throw new DBHMException(e);
                }
                this.valueState = value == this.origValue ? 1 : 2;
                this.value = value;
                this.valueIsHeapADT = value instanceof HeapADT;
                try {
                    if (oldValue != value && this.valueIsHeapADT) {
                        ((HeapADT)value).add();
                    }
                }
                catch (IOException e) {
                    throw new DBHMException(e);
                }
                return oldValue;
            }
            Object oldValue = super.setValue(value);
            this.valueState = 1;
            this.origValue = value;
            return oldValue;
        }

        @Override
        protected void setNextEntryOffset(long nextEntryOffset) throws IOException {
            if (this.nextEntry != null) {
                this.nextEntryOffset = nextEntryOffset;
                int n = this.nextEntryOffsetState = nextEntryOffset == this.origNextEntryOffset ? 1 : 2;
                if (nextEntryOffset == this.offset) {
                    throw new IllegalArgumentException();
                }
            } else {
                super.setNextEntryOffset(nextEntryOffset);
            }
        }

        @Override
        protected void setOffset(long offset) throws IOException {
            if (CachedDiskBackedHashMap.this.offsetCache.remove(this.offset) != null) {
                this.offsetState = 2;
                CachedDiskBackedHashMap.this.offsetCache.put(offset, this);
            } else {
                if (this.nextEntry != null) {
                    throw new IllegalStateException();
                }
                super.setOffset(offset);
                this.offsetState = 1;
            }
            this.offset = offset;
        }

        protected void moved(long offset, long nextEntryOffset, long prevEntryOffset) throws IOException {
            this.setOffset(offset);
            this.setNextEntryOffset(nextEntryOffset);
            this.setPrevEntryOffset(prevEntryOffset);
        }

        protected boolean flush() throws IOException {
            if (this.offsetState != 1 || this.nextEntryOffsetState == 2 && this.valueState == 2) {
                if (this.valueState == 2) {
                    this.origValue = this.value;
                    CachedDiskBackedHashMap.this.freeObject(this.valueOffset, 0);
                    this.valueOffset = CachedDiskBackedHashMap.this.writeObject(this.value, 0);
                    this.valueState = 1;
                }
                CachedDiskBackedHashMap.this.writeEntry(this);
                this.offsetState = 1;
                this.nextEntryOffsetState = 1;
                this.origNextEntryOffset = this.nextEntryOffset;
                return true;
            }
            if (this.nextEntryOffsetState == 2) {
                super.setNextEntryOffset(this.nextEntryOffset);
                this.nextEntryOffsetState = 1;
                this.origNextEntryOffset = this.nextEntryOffset;
                return true;
            }
            if (this.valueState == 2) {
                super.setValue(this.value, false);
                this.origValue = this.value;
                this.valueState = 1;
                return true;
            }
            return false;
        }
    }

    protected class CachedEntryIterator
    extends DiskBackedHashMap.EntryIterator {
        private long expectedTableCacheTime;

        protected CachedEntryIterator() {
            super(CachedDiskBackedHashMap.this);
            this.expectedTableCacheTime = CachedDiskBackedHashMap.this.tableCacheTime;
        }

        @Override
        protected void findNextTableEntry() throws IOException {
            if (this.expectedTableCacheTime != CachedDiskBackedHashMap.this.tableCacheTime) {
                this.dataIn = this.getTableInputStream(CachedDiskBackedHashMap.this.tablePtr + this.tableEntry * 30L);
                this.expectedTableCacheTime = CachedDiskBackedHashMap.this.tableCacheTime;
            }
            super.findNextTableEntry();
        }
    }
}

