/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.services.event;

import org.apache.activemq.broker.BrokerService;
import org.apache.log4j.Logger;

public class Broker {
    private static final Logger log = Logger.getLogger(Broker.class);
    BrokerService broker;

    public static void main(String[] args) {
        new Broker("MasterBroker", "tcp://0.0.0.0:61616");
    }

    public Broker(String name, String connector) {
        log.info((Object)("Starting Broker named '" + name + "' bound to '" + connector + "'."));
        try {
            this.broker = new BrokerService();
            this.broker.getManagementContext().setConnectorPort(1100);
            this.broker.setBrokerName(name);
            this.broker.setUseJmx(true);
            this.broker.addConnector(connector);
            this.broker.start();
        }
        catch (Exception e) {
            log.fatal((Object)"Error creating broker.", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.broker.stop();
        }
        catch (Exception e) {
            log.fatal((Object)"Error stopping broker.", (Throwable)e);
        }
    }
}

