/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.services.event;

import com.urbancode.air.services.event.Event;
import com.urbancode.air.services.event.EventListener;
import com.urbancode.air.services.event.EventSender;
import com.urbancode.air.services.event.criteria.Criteria;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class EventService
implements EventSender {
    private static final Logger log = Logger.getLogger(EventService.class);
    protected final HashMap<String, Set<EventListener>> type2listeners = new HashMap();
    private boolean isStarted = false;
    private boolean isShutdown = false;

    protected EventService() {
    }

    public synchronized void start() throws Exception {
        this.isStarted = true;
    }

    public synchronized boolean isStarted() {
        return this.isStarted;
    }

    public synchronized boolean isShutdown() {
        return this.isShutdown;
    }

    public synchronized void shutdown() {
        this.isShutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventListener(EventListener listener) {
        HashMap<String, Set<EventListener>> hashMap = this.type2listeners;
        synchronized (hashMap) {
            String[] types;
            for (String type : types = listener.getEventTypes()) {
                Set<EventListener> listeners = this.type2listeners.get(type);
                if (listeners == null) {
                    listeners = new HashSet<EventListener>();
                    this.type2listeners.put(type, listeners);
                }
                listeners.add(listener);
                log.debug((Object)("Added listener " + listener.getClass().getSimpleName() + " for " + type + " (total " + this.getListenerCount() + " listeners registered)"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(EventListener listener) {
        HashMap<String, Set<EventListener>> hashMap = this.type2listeners;
        synchronized (hashMap) {
            String[] types;
            for (String type : types = listener.getEventTypes()) {
                Set<EventListener> listeners = this.type2listeners.get(type);
                if (listeners != null) {
                    if (!listeners.remove(listener)) {
                        log.warn((Object)"listener not found to deregister");
                    }
                    log.debug((Object)("Removed listener " + listener.getClass().getSimpleName() + " for " + type + " (total " + this.getListenerCount() + " listeners registered)"));
                    continue;
                }
                log.warn((Object)"listener not found to deregister");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getListenerCount() {
        int count = 0;
        HashMap<String, Set<EventListener>> hashMap = this.type2listeners;
        synchronized (hashMap) {
            for (Set<EventListener> listeners : this.type2listeners.values()) {
                if (listeners == null) continue;
                count += listeners.size();
            }
        }
        return count;
    }

    public void waitForShutdown() {
        this.shutdown();
        String message = this.getListenerCount() + " EventListeners left registered at shutdown";
        if (this.getListenerCount() > 0) {
            log.warn((Object)message);
            if (log.isDebugEnabled()) {
                for (Set<EventListener> listeners : this.type2listeners.values()) {
                    if (listeners == null) continue;
                    for (EventListener el : listeners) {
                        String description = el.getClass().getSimpleName() + " for " + el.getEventTypes();
                        log.debug((Object)("unregistering listener " + description));
                    }
                }
            }
        } else {
            log.debug((Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventListener[] getListeners(Event event) {
        HashSet<EventListener> listenerSet = new HashSet<EventListener>();
        if (event == null) {
            throw new RuntimeException("Event was null.");
        }
        HashMap<String, Set<EventListener>> hashMap = this.type2listeners;
        synchronized (hashMap) {
            Set<EventListener> listeners = this.type2listeners.get(event.getType());
            if (listeners != null) {
                Iterator<EventListener> listenerItr = listeners.iterator();
                while (listenerItr.hasNext()) {
                    try {
                        EventListener listener = listenerItr.next();
                        if (listener == null || !Criteria.matches(event, listener.getCriteria())) continue;
                        listenerSet.add(listener);
                    }
                    catch (Exception e) {
                        log.error((Object)"Caught an Exception in EventService while trying to get a list of EventListeners.", (Throwable)e);
                    }
                }
            }
        }
        EventListener[] listeners = new EventListener[listenerSet.size()];
        listenerSet.toArray(listeners);
        return listeners;
    }

    void run(Event event) {
        try {
            EventListener[] listeners;
            for (EventListener listener : listeners = this.getListeners(event)) {
                try {
                    listener.handleEvent(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

