/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.interop.UcmImporter;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoSymbolicLink;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.connector.scm.common.CcConnectorUtils;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.interop.common.IExternalProxy;
import com.ibm.team.interop.common.IExternalProxyHandle;
import com.ibm.team.interop.common.IExternalState;
import com.ibm.team.interop.common.InteropFactory;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkQueryPage;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.VersionSet;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class JzRepoResource
extends SrvcResource {
    protected JzLocation _location;
    IItemHandle _myItemHandleCache;
    public static int SEGMENT_LENGTH_MAX = 32760;
    public static String SEGMENT_PREFIX = ".segment.";
    public static int SEGMENT_FORMAT_VERSION = 1;
    public static final String SINGLE_QUOTE = String.valueOf('\'');

    public JzRepoResource(JzProvider provider, Location loc) {
        this._provider = provider;
        this._location = JzLocation.create(loc);
    }

    public Class<?> get_proxyClass() {
        return ResourceImpl.class;
    }

    public JzLocation location() {
        return this._location;
    }

    public JzProvider provider() {
        return (JzProvider)this._provider;
    }

    public static IItemManager itemManager(JzProvider provider) {
        return provider.getRepo().itemManager();
    }

    public IItemManager getItemManager() {
        return JzRepoResource.itemManager(this.provider());
    }

    public IWorkspaceManager getWorkspaceManager() {
        return this.provider().getWorkspaceManager();
    }

    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.location().string();
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return this.getPathnameLocation(feedback);
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getDisplayName(feedback);
        }
        LinkTypeInfo linkTypeInfo = LinkTypeInfo.lookup(propertyName);
        if (linkTypeInfo != null) {
            if (linkTypeInfo.hasListValue) {
                List<String> results = JzRepoResource.lookupLinkedValues(this.provider(), linkTypeInfo, this.getItemHandle(feedback), feedback);
                return results;
            }
            String result = JzRepoResource.lookupLinkedValue(this.provider(), linkTypeInfo, this.getItemHandle(feedback), feedback);
            return result;
        }
        if (propertyName.getNamespace() != null) {
            return this.getCustomProperty(propertyName, feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.getNamespace() != null) {
            this.storeCustomProperty(propertyName, (String)value, initialize, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    public String getDisplayName(SrvcFeedback feedback) throws WvcmException {
        return this.location().string();
    }

    public Location getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        return this.location();
    }

    public static String getVHInitialComponentPropertyName() {
        return "InitialComponent";
    }

    public static String getFolderVersionBindingListPropertyName() {
        return "FolderVersionBindingList";
    }

    public static JzLocation createChildJzLocationFromHandle(JzLocation parent, IItemHandle handle) throws WvcmException {
        return parent.child(JzRepoResource.getCurrentStateDisplayName(handle));
    }

    public static String getCurrentStateDisplayName(IWorkspaceConnection connection) {
        IWorkspace resolvedWorkspace = connection.getResolvedWorkspace();
        String displayName = JzRepoResource.getCurrentStateDisplayName((IItemHandle)resolvedWorkspace);
        return displayName;
    }

    public static IItemHandle lookupItemHandle(JzProvider provider, URI uri) throws WvcmException {
        IItemHandle result = null;
        try {
            ITeamRepository repo = provider.getRepo();
            result = JzRepoResource.lookupItemHandle(repo, uri);
        }
        catch (WvcmException e) {
            if (WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoResource.lookupItemHandle", (Exception)((Object)e));
            }
            throw e;
        }
        return result;
    }

    public static IItemHandle lookupItemHandle(ITeamRepository repo, URI uri) throws WvcmException {
        com.ibm.team.repository.common.Location usableLoc = JzRepoResource.createJazzLocation(repo, uri);
        IItemHandle result = usableLoc.getItemHandle();
        if (result != null && result.getOrigin() == null) {
            result = result.getItemType().createItemHandle((Object)repo, result.getItemId(), result.getStateId());
        }
        return result;
    }

    public static IItemHandle lookupItemHandle(JzProvider provider, JzLocation wvcmLocation) throws WvcmException {
        IItemHandle result = null;
        ITeamRepository repo = provider.getRepo();
        result = JzRepoResource.lookupItemHandle(repo, wvcmLocation);
        return result;
    }

    private static IItemHandle lookupItemHandle(ITeamRepository repo, JzLocation wvcmLocation) throws WvcmException {
        URI uri = wvcmLocation.getURI();
        IItemHandle result = JzRepoResource.lookupItemHandle(repo, uri);
        return result;
    }

    public static IItemHandle getItemHandle(JzProvider provider, JzLocation wvcmLocation) throws WvcmException {
        return JzRepoResource.getItemHandle(provider.getRepo(), wvcmLocation);
    }

    public static IItemHandle getItemHandle(ITeamRepository repo, JzLocation wvcmLocation) throws WvcmException {
        if (wvcmLocation.kind().equals((Object)JzLocation.Kind.BaselineControlledFolder)) {
            throw new IllegalArgumentException("JRR.getMyItemHandle should never be called with a BCF " + wvcmLocation.string());
        }
        URI uri = wvcmLocation.getURI();
        IItemHandle result = JzRepoResource.lookupItemHandle(repo, uri);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_ERROR_GET_ITEM_HANDLE_FAILED_WITH_URI, (Object)uri.toString(), (Object[])new Object[0]), null, WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    private static com.ibm.team.repository.common.Location createJazzLocation(ITeamRepository repo, URI itemURI) throws WvcmException {
        try {
            com.ibm.team.repository.common.Location usableLoc = com.ibm.team.repository.common.Location.location((com.ibm.team.repository.common.Location)com.ibm.team.repository.common.Location.location((URI)itemURI), (String)repo.getRepositoryURI(), null);
            return usableLoc;
        }
        catch (TeamRepositoryException ex) {
            throw JzProvider.wrapException((Exception)((Object)ex));
        }
        catch (IllegalArgumentException ex) {
            throw JzProvider.wrapExceptionGivenExternalizedMsg(NLS.bind((String)Messages.JzRepoResource_ERROR_COULD_NOT_CREATE_JAZZ_LOCATION_FROM_URI_WITH_URISTRING, (Object)itemURI.toString(), (Object[])new Object[0]), ex);
        }
    }

    public static String getCurrentStateDisplayName(IItemHandle handle) {
        String uriString = JzRepoResource.getCurrentStateLocationUriString(handle);
        String displayName = "URI:" + uriString;
        return displayName;
    }

    public static String getCurrentStateLocationUriString(IItemHandle handle) {
        return com.ibm.team.repository.common.Location.itemLocation((IItemHandle)handle, null).toRelativeUri().toString();
    }

    public static String getItemStateDisplayName(IVersionableHandle handle) {
        com.ibm.team.repository.common.Location wsLoc = com.ibm.team.repository.common.Location.stateLocation((IItemHandle)handle, null);
        String displayName = "URI:" + wsLoc.toRelativeUri().toString();
        return displayName;
    }

    public void removePropertyFromClient(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        this.removeCustomProperty(propertyName, feedback);
    }

    public JzRepoWorkspace getWvcmWorkspace(SrvcFeedback feedback) throws WvcmException {
        return JzRepoResource.getWvcmWorkspace(this.provider(), this.location(), feedback);
    }

    public IWorkspaceConnection getWorkspaceConnection(SrvcFeedback feedback) throws WvcmException {
        return this.getWvcmWorkspace(feedback.nest(50)).getConnection(feedback);
    }

    public static JzRepoWorkspace getWvcmWorkspace(JzProvider provider, JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = (JzRepoWorkspace)provider.lookup((Location)loc.getWorkspaceLocation(), feedback.nest(10));
        if (ws == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_ERROR_GET_WS_FROM_LOC_FAILED_WITH_LOC_STRING, (Object)loc.string(), (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        return ws;
    }

    public IConfiguration getConfiguration(SrvcFeedback feedback) throws WvcmException {
        return JzRepoResource.getConfiguration(this.provider(), this.location(), feedback);
    }

    public static IConfiguration getConfiguration(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        IConfiguration config = JzRepoResource.lookupConfiguration(provider, myLoc, feedback);
        if (config == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_ERROR_GET_CONFIG_FAILED_WITH_LOCSTRING, (Object)myLoc.string(), (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return config;
    }

    public static IConfiguration lookupConfiguration(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        IConfiguration config = null;
        JzLocation wsLoc = myLoc.lookupContextLocation(JzLocation.Kind.Workspace);
        JzLocation compLoc = myLoc.lookupContextLocation(JzLocation.Kind.Component);
        if (wsLoc != null && compLoc != null) {
            JzRepoWorkspace ws = (JzRepoWorkspace)provider.get((Location)wsLoc, null);
            config = ws.lookupConfiguration(compLoc, feedback);
        }
        return config;
    }

    protected synchronized void setItemHandle(IItemHandle h) {
        this._myItemHandleCache = h;
    }

    public synchronized IItemHandle lookupItemHandle() throws WvcmException {
        if (this._myItemHandleCache == null) {
            this._myItemHandleCache = JzRepoResource.lookupItemHandle(this.provider(), this.location());
        }
        return this._myItemHandleCache;
    }

    public synchronized IItemHandle getItemHandle(SrvcFeedback feedback) throws WvcmException {
        if (this._myItemHandleCache == null) {
            this._myItemHandleCache = this.computeItemHandle(feedback);
        }
        return this._myItemHandleCache;
    }

    public IItemHandle computeItemHandle(SrvcFeedback feedbackIgnored) throws WvcmException {
        return JzRepoResource.getItemHandle(this.provider(), this.location());
    }

    public static IInteropManager getInteropManager(JzProvider provider) throws WvcmException {
        return (IInteropManager)provider.getRepo().getClientLibrary(IInteropManager.class);
    }

    public static ILinkManager getLinkManager(JzProvider provider) {
        return (ILinkManager)provider.getRepo().getClientLibrary(ILinkManager.class);
    }

    public static IItemReference createReferenceToItem(ILinkManager linkManager, IItemHandle itemHandle) {
        return linkManager.referenceFactory().createReferenceToItem(itemHandle);
    }

    public static IURIReference createReferenceToUri(ILinkManager linkManager, URI uri) {
        return linkManager.referenceFactory().createReferenceFromURI(uri);
    }

    public String getCustomProperty(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        if (LinkTypeInfo.isLinkPropertyName(propertyName)) {
            throw new IllegalArgumentException("NYI");
        }
        String result = (String)this.getCustomProperty(propertyName.getName(), feedback);
        return result;
    }

    public Object getCustomProperty(String name, SrvcFeedback feedback) throws WvcmException {
        return JzRepoResource.getCustomProperty(this.provider(), this.getItemHandle(feedback), name, feedback);
    }

    public static Object getCustomProperty(JzProvider provider, IItemHandle h, String name, SrvcFeedback feedback) throws WvcmException {
        IExternalProxy proxy;
        IInteropManager interopManager;
        block3: {
            interopManager = JzRepoResource.getInteropManager(provider);
            try {
                proxy = interopManager.findProxybyTargetItem(h, JzProvider.getMonitor(feedback, 50));
                if (proxy != null) break block3;
                return null;
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        }
        Map latestState = interopManager.getLatestState(proxy, JzProvider.getMonitor(feedback, 100));
        String value = latestState == null ? null : JzRepoResource.getStringValue(latestState, name);
        JzRepoResource.traceProxyWithState(provider, "got", name, value == null ? null : value, h.getItemId().toString());
        return value;
    }

    public static List<String> lookupLinkedValues(JzProvider provider, LinkTypeInfo linkTypeInfo, IItemHandle h, SrvcFeedback feedback) throws WvcmException {
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        IItemReference itemReference = JzRepoResource.createReferenceToItem(linkManager, h);
        List<IURIReference> uriReferences = JzRepoResource.lookupTargetUriReferences(provider, linkTypeInfo.linkType, itemReference, feedback);
        ArrayList<String> results = new ArrayList<String>(uriReferences.size());
        for (IURIReference uriReference : uriReferences) {
            results.add(JzRepoResource.createValueFromUri(uriReference.getURI()));
        }
        return results;
    }

    public static String lookupLinkedValue(JzProvider provider, LinkTypeInfo linkTypeInfo, IItemHandle h, SrvcFeedback feedback) throws WvcmException {
        List<String> results = JzRepoResource.lookupLinkedValues(provider, linkTypeInfo, h, feedback);
        int count = results.size();
        String result = count == 0 ? null : results.get(0);
        return result;
    }

    private static IURIReference lookupTargetUriReference(JzProvider provider, String linkType, IItemReference itemReference, SrvcFeedback feedback) throws WvcmException {
        List<IURIReference> results = JzRepoResource.lookupTargetUriReferences(provider, linkType, itemReference, feedback);
        int count = results.size();
        IURIReference result = count == 0 ? null : results.get(0);
        return result;
    }

    private static List<IURIReference> lookupTargetUriReferences(JzProvider provider, String linkType, IItemReference itemReference, SrvcFeedback feedback) throws WvcmException {
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        try {
            Collection links = linkManager.findLinksBySource(linkType, (IReference)itemReference, JzProvider.getMonitor(feedback, 100)).getAllLinksFromHereOn().getLinksById(linkType);
            ArrayList<IURIReference> results = new ArrayList<IURIReference>(links.size());
            Iterator linksIterator = links.iterator();
            IReference targetRef = null;
            while (linksIterator.hasNext()) {
                ILink link = (ILink)linksIterator.next();
                targetRef = link.getTargetRef();
                if (!targetRef.isURIReference()) continue;
                results.add((IURIReference)targetRef);
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private void removeCustomProperty(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        this.storeCustomProperty(propertyName, (String)null, false, feedback);
    }

    void storeCustomProperty(PropertyNameList.PropertyName<?> propertyName, List<?> values, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        LinkTypeInfo linkTypeInfo = LinkTypeInfo.lookup(propertyName);
        if (linkTypeInfo == null || !linkTypeInfo.hasListValue) {
            String pn = feedback.format("{0}.{1}", new Object[]{propertyName.getNamespace(), propertyName.getName()});
            throw new IllegalArgumentException("Cannot store custom property whose value is a list but is not implemented with links: " + pn);
        }
        this.linkToValues(linkTypeInfo, values, feedback);
    }

    void storeCustomProperty(PropertyNameList.PropertyName<?> propertyName, String value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        LinkTypeInfo linkTypeInfo = LinkTypeInfo.lookup(propertyName);
        if (linkTypeInfo != null) {
            if (value != null) {
                this.storeLinkedValue(value, linkTypeInfo, feedback);
            } else {
                this.removeLinkedValue(linkTypeInfo.linkType, feedback);
            }
            return;
        }
        JzProvider provider = this.provider();
        IItemHandle h = this.getItemHandle(feedback.nest(5));
        String name = propertyName.getName();
        JzRepoResource.storeCustomProperty(provider, h, name, value, initialize, feedback);
    }

    static void storeCustomProperty(JzProvider provider, IItemHandle h, String name, String value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        IInteropManager interopManager = JzRepoResource.getInteropManager(provider);
        JzRepoResource.traceProxyWithState(provider, "saving", name, value == null ? null : value.toString(), h.getItemId().toString());
        try {
            IExternalProxy proxy = interopManager.findProxybyTargetItem(h, JzProvider.getMonitor(feedback, 10));
            IExternalState xstate = null;
            HashMap<String, Object> state = null;
            if (proxy == null) {
                proxy = InteropFactory.INSTANCE.createExternalProxy();
                IProjectArea area = provider.getProjectArea(feedback);
                proxy.setContextId(area.getContextId());
                proxy = interopManager.saveProxyWithTargetItem(proxy, h, JzProvider.getMonitor(feedback, 60));
            } else {
                xstate = interopManager.getExternalState(proxy, JzProvider.getMonitor(feedback, 60));
            }
            proxy = (IExternalProxy)proxy.getWorkingCopy();
            if (xstate == null) {
                xstate = InteropFactory.INSTANCE.createExternalState();
                xstate = (IExternalState)xstate.getWorkingCopy();
                state = new HashMap<String, Object>(1);
            } else {
                xstate = (IExternalState)xstate.getWorkingCopy();
                state = xstate.getState();
            }
            JzRepoResource.putValue(state, name, value, initialize);
            xstate.setState(state);
            interopManager.saveProxyWithState(proxy, xstate, JzProvider.getMonitor(feedback, 90));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private static String getStringValue(Map<String, Object> latestState, String baseName) {
        if (latestState.containsKey(baseName)) {
            return (String)latestState.get(baseName);
        }
        String descriptorKey = JzRepoResource.baseNameToDescriptorKey(baseName);
        if (latestState.containsKey(descriptorKey)) {
            SegmentFoldingDescriptor descriptor = new SegmentFoldingDescriptor((String)latestState.get(descriptorKey));
            StringBuilder builder = new StringBuilder(descriptor._numSegments * descriptor._maxSegmentLength);
            int i = 0;
            while (i < descriptor._numSegments) {
                String key = JzRepoResource.computeKey(baseName, i);
                builder.append((String)latestState.get(key));
                ++i;
            }
            String result = builder.toString();
            assert (result.length() == descriptor._totalLength);
            return result;
        }
        return null;
    }

    private static void deleteAnySegments(Map<String, Object> state, String baseName) {
        state.put(baseName, null);
        String expanderMapNameKey = JzRepoResource.baseNameToDescriptorKey(baseName);
        if (state.containsKey(expanderMapNameKey)) {
            String[] prefixes;
            String expanderMap = (String)state.get(expanderMapNameKey);
            String[] stringArray = prefixes = expanderMap.split(JzProvider.COMMA);
            int n = prefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                state.put(String.valueOf(prefix) + baseName, null);
                ++n2;
            }
        }
    }

    private static String baseNameToDescriptorKey(String baseName) {
        return "expanderMapPrefix." + baseName;
    }

    private static void putValue(Map<String, Object> state, String baseName, String value, boolean initialize) throws WvcmException {
        if (initialize && JzRepoResource.getStringValue(state, baseName) != null) {
            throw new WvcmException("Property already set: " + baseName, WvcmException.ReasonCode.CANNOT_OVERWRITE);
        }
        JzRepoResource.deleteAnySegments(state, baseName);
        if (value == null) {
            return;
        }
        if (value.length() <= SEGMENT_LENGTH_MAX) {
            state.put(baseName, value);
        } else {
            JzRepoResource.putMultiSegmentValue(state, baseName, value);
        }
    }

    private static void putMultiSegmentValue(Map<String, Object> state, String baseName, String value) throws WvcmException {
        StringReader valueStream = new StringReader(value);
        char[] buffer = new char[SEGMENT_LENGTH_MAX];
        int segmentNum = 0;
        int numCharsRead = 0;
        try {
            do {
                if ((numCharsRead = valueStream.read(buffer, 0, SEGMENT_LENGTH_MAX)) <= 0) continue;
                state.put(JzRepoResource.computeKey(baseName, segmentNum++), new String(buffer, 0, numCharsRead));
            } while (numCharsRead > 0);
            SegmentFoldingDescriptor descriptor = new SegmentFoldingDescriptor(SEGMENT_FORMAT_VERSION, value.length(), SEGMENT_LENGTH_MAX, segmentNum);
            state.put(JzRepoResource.baseNameToDescriptorKey(baseName), descriptor.encode());
        }
        catch (IOException e) {
            throw new WvcmException("Could not store property value", null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    private static String computeKey(String baseName, int segmentNum) {
        return String.format("%s%d.%s", SEGMENT_PREFIX, segmentNum, baseName);
    }

    public void removeInteropCloneValue(SrvcFeedback feedback) throws WvcmException {
        this.removeLinkedValue(CcConnectorUtils.CLONE_LINK_TYPE, feedback);
    }

    private void removeLinkedValue(String linkType, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        IItemReference itemReference = JzRepoResource.createReferenceToItem(linkManager, this.getItemHandle(feedback.nest(10)));
        try {
            Collection itemsLinks = linkManager.findLinksBySource(linkType, (IReference)itemReference, JzProvider.getMonitor(feedback, 20)).getAllLinksFromHereOn().getLinksById(linkType);
            if (itemsLinks.size() > 0) {
                linkManager.deleteLinks(itemsLinks, JzProvider.getMonitor(feedback, 30));
            }
            feedback.notifyPercentComplete(100);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static void storeInteropCloneValues(JzProvider provider, Map<JzRepoResource, String> sources2Values, SrvcFeedback feedback) throws WvcmException {
        JzRepoResource.storeLinkedValues(provider, sources2Values, LinkTypeInfo.CLONE, feedback);
    }

    private static void storeLinkedValues(JzProvider provider, Map<JzRepoResource, String> sources2Values, LinkTypeInfo linkTypeInfo, SrvcFeedback feedback) throws WvcmException {
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        List<LinkInfo> linkages = JzRepoResource.computeReferences(linkManager, sources2Values, feedback);
        if (linkTypeInfo.ensureUnique) {
            JzRepoResource.ensureNoExistingClones(provider, linkages, feedback);
        }
        JzRepoResource.storeLinkedValues(provider, linkManager, linkTypeInfo, linkages, feedback);
    }

    private static void storeLinkedValues(JzProvider provider, ILinkManager linkManager, LinkTypeInfo linkTypeInfo, List<LinkInfo> linkages, SrvcFeedback feedback) throws WvcmException {
        int batchSize = provider.getMaxNumQueryEntries();
        ArrayList<ILink> links = new ArrayList<ILink>(linkages.size());
        for (LinkInfo entry : linkages) {
            if (entry._result != null) continue;
            try {
                if (provider.isDebugLogEnabled()) {
                    provider.logDebug(String.format("linking VH %s to clone %s", JzRepoResource.getCurrentStateDisplayName(entry.jrrForMessages.getItemHandle(feedback.nest(40))), entry._targetCloneValue));
                }
                ILink link = linkManager.createLink(linkTypeInfo.linkType, (IReference)entry._sourceRef, (IReference)entry._targetRef);
                links.add(link);
            }
            catch (TeamRepositoryException e) {
                WvcmException value = JzProvider.wrapExceptionGivenExternalizedMsg(NLS.bind((String)Messages.JzRepoResource_ERROR_CREATE_LINK_FAILED_WITH_LOC_STRING, (Object)((Object)entry.jrrForMessages.location()), (Object[])new Object[0]), (Exception)((Object)e));
                entry._result = value;
            }
            if (links.size() < batchSize) continue;
            JzRepoResource.saveAndClearLinks(links, linkManager, feedback);
        }
        JzRepoResource.saveAndClearLinks(links, linkManager, feedback);
    }

    private static void saveAndClearLinks(Collection<ILink> links, ILinkManager linkManager, SrvcFeedback feedback) throws WvcmException {
        int currentCount = links.size();
        if (currentCount > 0) {
            try {
                linkManager.saveLinks(links, JzProvider.getMonitor(feedback, 100));
                String msg = currentCount == 1 ? Messages.JzRepoResource_MSG_CREATED_A_LINK : NLS.bind((String)Messages.JzRepoResource_MSG_CREATED_N_LINKS, (Object)String.valueOf(currentCount), (Object[])new Object[0]);
                feedback.notifyCompleted(msg);
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
            links.clear();
        }
    }

    private static void ensureNoExistingClones(JzProvider provider, List<LinkInfo> entries, SrvcFeedback feedback) throws WvcmException {
        int count = entries.size();
        HashSet<String> sourceUuids = new HashSet<String>(count);
        HashSet<URI> targetURIs = new HashSet<URI>(count);
        for (LinkInfo entry : entries) {
            String sourceUuid = entry._sourceRef.getReferencedItem().getItemId().getUuidValue();
            if (sourceUuids.contains(sourceUuid)) {
                throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_ERROR_ITEM_ALREADY_HAS_CLONE_WITH_ITEM_ID, (Object)JzRepoResource.getCurrentStateDisplayName(entry.jrrForMessages.getItemHandle(feedback)), (Object[])new Object[0]), null, WvcmException.ReasonCode.CONFLICT);
            }
            sourceUuids.add(sourceUuid);
            JzRepoResource.ensureNoClonesOfSource(provider, entry._sourceRef, entry.jrrForMessages, feedback.nest(50));
            URI targetURI = entry._targetRef.getURI();
            if (targetURIs.contains(targetURI)) {
                throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_URI_ALREADY_HAS_CLONE_WITH_URI, (Object)entry._targetCloneValue, (Object[])new Object[0]), null, WvcmException.ReasonCode.CONFLICT);
            }
            targetURIs.add(targetURI);
            JzRepoResource.ensureNoCloneOfTarget(provider, entry._targetRef, entry._targetCloneValue, feedback);
        }
    }

    private void linkToValues(LinkTypeInfo linkTypeInfo, List<?> values, SrvcFeedback feedback) throws WvcmException {
        if (values.size() == 0) {
            return;
        }
        JzProvider provider = this.provider();
        List<LinkInfo> linkages = this.computeLinkages(values, feedback);
        JzRepoResource.storeLinkedValues(provider, JzRepoResource.getLinkManager(provider), linkTypeInfo, linkages, feedback);
    }

    private List<LinkInfo> computeLinkages(List<?> values, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        IItemReference sourceRef = this.createReferenceToItem(linkManager, feedback);
        ArrayList<LinkInfo> linkages = new ArrayList<LinkInfo>(values.size());
        for (Object valueObject : values) {
            if (valueObject instanceof String) {
                String value = (String)valueObject;
                LinkInfo info = new LinkInfo();
                linkages.add(info);
                try {
                    info.jrrForMessages = this;
                    info._sourceRef = sourceRef;
                    info._targetCloneValue = value;
                    URI uri = JzRepoResource.createUriFromValue(value);
                    info._targetRef = JzRepoResource.createReferenceToUri(linkManager, uri);
                }
                catch (Exception e) {
                    WvcmException result = new WvcmException("Could not create link from resource with location" + (Object)((Object)this.location()), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
                    info._result = result;
                }
                continue;
            }
            throw new IllegalArgumentException("cannot link to a value whose class is not String: " + valueObject.getClass().getName());
        }
        return linkages;
    }

    private static List<LinkInfo> computeReferences(ILinkManager linkManager, Map<JzRepoResource, String> sources2Values, SrvcFeedback feedback) throws WvcmException {
        ArrayList<LinkInfo> results = new ArrayList<LinkInfo>(sources2Values.size());
        for (JzRepoResource source : sources2Values.keySet()) {
            LinkInfo result = new LinkInfo();
            results.add(result);
            try {
                result.jrrForMessages = source;
                result._sourceRef = source.createReferenceToItem(linkManager, feedback);
                result._targetCloneValue = sources2Values.get((Object)source);
                URI uri = JzRepoResource.createUriFromValue(result._targetCloneValue);
                result._targetRef = JzRepoResource.createReferenceToUri(linkManager, uri);
            }
            catch (Exception e) {
                WvcmException value = new WvcmException("Could not create link to resource with location" + (Object)((Object)source.location()), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
                result._result = value;
            }
        }
        feedback.notifyPercentComplete(100);
        return results;
    }

    protected IItemReference createReferenceToItem(ILinkManager linkManager, SrvcFeedback feedback) throws WvcmException {
        IItemReference result = null;
        if (this instanceof JzRepoVersionHistory) {
            throw new IllegalStateException("Expected JzRepoVersionHistory's override to run instead of this one");
        }
        result = JzRepoResource.createReferenceToItem(linkManager, this.getItemHandle(feedback));
        return result;
    }

    public void storeInteropCloneValue(String cloneValue, SrvcFeedback feedback) throws WvcmException {
        this.storeLinkedValue(cloneValue, LinkTypeInfo.CLONE, feedback.nest(90));
    }

    private void storeLinkedValue(String targetURI, LinkTypeInfo linkTypeInfo, SrvcFeedback feedback) throws WvcmException {
        this.traceProxyWithState("saving", "target URI", targetURI);
        HashMap<JzRepoResource, String> sources2Values = new HashMap<JzRepoResource, String>(1);
        sources2Values.put(this, targetURI);
        JzRepoResource.storeLinkedValues(this.provider(), sources2Values, linkTypeInfo, feedback);
    }

    private static void ensureNoClonesOfSource(JzProvider provider, IItemReference reference, JzRepoResource source, SrvcFeedback feedback) throws WvcmException {
        IURIReference i = JzRepoResource.lookupTargetUriReference(provider, CcConnectorUtils.CLONE_LINK_TYPE, reference, feedback);
        if (i != null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_ERROR_ITEM_ALREADY_HAS_CLONE_WITH_ITEM_ID, (Object)JzRepoResource.getCurrentStateDisplayName(source.getItemHandle(feedback)), (Object[])new Object[0]), null, WvcmException.ReasonCode.CONFLICT);
        }
    }

    private static void ensureNoCloneOfTarget(JzProvider provider, IURIReference uriReference, String cloneValue, SrvcFeedback feedback) throws WvcmException {
        if (JzRepoResource.hasClone(provider, uriReference, feedback)) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_URI_ALREADY_HAS_CLONE_WITH_URI, (Object)cloneValue, (Object[])new Object[0]), null, WvcmException.ReasonCode.CONFLICT);
        }
    }

    public static boolean hasClone(JzProvider provider, IURIReference reference, SrvcFeedback feedback) throws WvcmException {
        Map<IURIReference, IItemReference> clones = JzRepoResource.getClonesOfTargets(provider, feedback, Collections.singletonList(reference));
        return clones.get(reference) != null;
    }

    public static URI createUriFromValue(String value) throws WvcmException {
        try {
            URI result = CcConnectorUtils.createUriFromValue((String)value);
            return result;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create URI from value: " + value, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Could not create URI from value: " + value, e);
        }
    }

    public static String createValueFromUri(URI uri) throws WvcmException {
        try {
            String result = CcConnectorUtils.createValueFromUri((URI)uri);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Could not create value from URI: " + uri, e);
        }
    }

    public static IItemHandle lookupByValue(JzProvider provider, PropertyNameList.PropertyName<?> propertyName, String value, SrvcFeedback feedback) throws WvcmException {
        if (value.startsWith("CQ%3A")) {
            return JzRepoResource.lookupWorkItemByCqInteropUri(provider, value, feedback);
        }
        LinkTypeInfo linkTypeInfo = LinkTypeInfo.lookup(propertyName);
        if (linkTypeInfo == null) {
            throw new IllegalArgumentException(feedback.format("unsupported property name for linked value lookup {0}.{1}", new Object[]{propertyName.getNamespace(), propertyName.getName()}));
        }
        URI uri = JzRepoResource.createUriFromValue(value);
        IURIReference reference = JzRepoResource.createReferenceToUri(JzRepoResource.getLinkManager(provider), uri);
        Map<IURIReference, IItemReference> items = JzRepoResource.getObjectsLinkedToTargets(provider, linkTypeInfo.linkType, Collections.singletonList(reference), feedback);
        IItemReference itemReference = items.get(reference);
        IItemHandle result = itemReference == null ? null : itemReference.getReferencedItem();
        return result;
    }

    protected static Map<IURIReference, IItemReference> getClonesOfTargets(JzProvider provider, SrvcFeedback feedback, List<IURIReference> uriReferences) throws WvcmException {
        return JzRepoResource.getObjectsLinkedToTargets(provider, CcConnectorUtils.CLONE_LINK_TYPE, uriReferences, feedback);
    }

    private static Map<IURIReference, IItemReference> getObjectsLinkedToTargets(JzProvider provider, String linkType, List<IURIReference> uriReferences, SrvcFeedback feedback) throws WvcmException {
        String[] linkTypeIds = new String[]{linkType};
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        try {
            int inputCount = uriReferences.size();
            ArrayList<ILink> links = new ArrayList<ILink>(inputCount);
            int queryBatchSize = provider.getMaxNumQueryEntries();
            int cfr_ignored_0 = inputCount / queryBatchSize;
            int remainder = inputCount % queryBatchSize;
            if (remainder != 0) {
                // empty if block
            }
            int fromIndex = 0;
            while (fromIndex < inputCount) {
                int thisChunkSize = Math.min(inputCount - fromIndex, queryBatchSize);
                List<IURIReference> chunkList = uriReferences.subList(fromIndex, fromIndex + thisChunkSize);
                IURIReference[] chunk = chunkList.toArray(new IURIReference[thisChunkSize]);
                Collection theseLinks = linkManager.findLinksByTarget(linkTypeIds, (IReference[])chunk, JzProvider.getMonitor(feedback, 100)).getAllLinksFromHereOn().getLinksById(linkType);
                links.addAll(theseLinks);
                fromIndex += thisChunkSize;
            }
            return JzRepoResource.list2MapKeyedByUriReference(links);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private static Map<IURIReference, IItemReference> list2MapKeyedByUriReference(Collection<ILink> links) {
        TreeMap<IURIReference, IItemReference> results = new TreeMap<IURIReference, IItemReference>(new URIRefComparator());
        for (ILink link : links) {
            IReference targetRef = link.getTargetRef();
            if (targetRef.isURIReference()) {
                IURIReference key = (IURIReference)targetRef;
                IReference sourceRef = link.getSourceRef();
                IItemReference result = sourceRef.isItemReference() ? (IItemReference)sourceRef : null;
                results.put(key, result);
                continue;
            }
            throw new IllegalStateException("internal error: Clone link target reference is not a URI reference");
        }
        return results;
    }

    private static IItemHandle lookupWorkItemByCqInteropUri(JzProvider provider, String value, SrvcFeedback feedback) throws WvcmException {
        IExternalProxy proxy;
        IInteropManager interopManager;
        IItemHandle result;
        block3: {
            result = null;
            interopManager = JzRepoResource.getInteropManager(provider);
            try {
                proxy = interopManager.findProxybyUri(URI.create(value), JzProvider.getMonitor(feedback, 50));
                if (proxy != null) break block3;
                return null;
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        }
        result = interopManager.getTargetItem((IExternalProxyHandle)proxy, JzProvider.getMonitor(feedback, 100));
        return result;
    }

    void traceProxyWithState(String verb, String name, String value) throws WvcmException {
        if (this.provider().isDebugLogEnabled()) {
            JzRepoResource.traceProxyWithState(this.provider(), verb, name, value, this.getItemIdString());
        }
    }

    protected String getItemIdString() throws WvcmException {
        return this.getItemHandle(null).getItemId().getUuidValue();
    }

    public static void traceProxyWithState(JzProvider provider, String verb, String name, String value, String id) {
        if (provider.isDebugLogEnabled()) {
            int len = value == null ? 0 : value.length();
            int display = len <= 200 ? len : 200;
            String valueString = value == null ? "{null}" : value.substring(0, display);
            provider.logDebug(String.format("%s property: %s value length: %d, prefix: %s on %s\n", verb, name, len, valueString, id));
        }
    }

    public String getItemStateDisplayName(IVersionableHandle itemHandle, IConfiguration config, SrvcFeedback feedback) throws WvcmException {
        String result = this.lookupItemStateDisplayName(itemHandle, config, feedback);
        if (result == null) {
            throw new WvcmException("Could not get Item State Display Name", null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public String lookupItemStateDisplayName(IVersionableHandle itemHandle, IConfiguration config, SrvcFeedback feedback) throws WvcmException {
        IVersionable meWithStateId = this.lookupItemState(itemHandle, config, feedback);
        if (meWithStateId == null) {
            return null;
        }
        String myURIString = JzRepoResource.getItemStateDisplayName((IVersionableHandle)meWithStateId);
        return myURIString;
    }

    public IVersionable lookupItemState(IVersionableHandle itemHandle, IConfiguration config, SrvcFeedback feedback) throws WvcmException {
        try {
            IVersionable meWithStateId = config.fetchPartialItem(itemHandle, null, JzProvider.getMonitor(feedback, 100));
            return meWithStateId;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return null;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static JzLocation getVersionHistoryLocation(JzLocation compLoc, IVersionableHandle vH) throws WvcmException {
        return compLoc.createVersionHistoryLocation(JzRepoResource.getCurrentStateDisplayName((IItemHandle)vH));
    }

    public static JzRepoControllableResource createFromVersionable(JzProvider provider, JzLocation loc, IVersionableHandle vH) {
        JzRepoControllableResource result = null;
        IItemType t = vH.getItemType();
        if (t.equals(IFileItem.ITEM_TYPE)) {
            result = new JzRepoControllableResource(provider, (Location)loc);
        } else if (t.equals(IFolder.ITEM_TYPE)) {
            result = new JzRepoControllableFolder(provider, (Location)loc);
        } else if (t.equals(ISymbolicLink.ITEM_TYPE)) {
            result = new JzRepoSymbolicLink(provider, (Location)loc);
        } else {
            throw new IllegalStateException("did not recognize item type" + t.toString());
        }
        result.setItemHandle((IItemHandle)vH);
        return result;
    }

    public boolean isDebugLogEnabled() {
        return this.provider().isDebugLogEnabled();
    }

    public void logCreation(String objectKind, JzLocation requestedLocation, String resourceIdentifer, String otherInfo) {
        this.provider().logCreation(objectKind, requestedLocation, resourceIdentifer, otherInfo);
    }

    public void logCreation(String objectName, JzLocation objectLocation) {
        this.provider().logCreation(objectName, objectLocation);
    }

    public void logInfo(String msg) {
        this.provider().logInfo(msg);
    }

    public void logDebug(String msg) {
        this.provider().logDebug(msg);
    }

    public void logIgnoredExceptionAsAlwaysVisible(String methodName, Exception e, String extraDescription) {
        this.provider().logIgnoredExceptionAsAlwaysVisible(methodName, e, extraDescription);
    }

    public void logIgnoredExceptionAsNotAlwaysVisible(String methodName, Exception e, String extraDescription) {
        this.provider().logIgnoredExceptionAsNotAlwaysVisible(methodName, e, extraDescription);
    }

    public Map<String, JzRepoResource> childMap(boolean childrenAreVersionHistories, IConfiguration config, SrvcFeedback feedback) throws WvcmException {
        JzLocation loc = this.location();
        JzProvider provider = this.provider();
        IFolderHandle folder = (IFolderHandle)this.getItemHandle(feedback.nest(10));
        JzLocation compLoc = JzRepoComponent.createComponentLocation(config.component());
        try {
            Map kids = config.childEntries(folder, JzProvider.getMonitor(feedback, 100));
            HashMap<String, JzRepoResource> result = new HashMap<String, JzRepoResource>(kids.size());
            for (String childName : kids.keySet()) {
                IVersionableHandle vH = (IVersionableHandle)kids.get(childName);
                JzRepoResource value = childrenAreVersionHistories ? new JzRepoVersionHistory(provider, (Location)compLoc.createVersionHistoryLocation(JzRepoResource.getCurrentStateDisplayName((IItemHandle)vH))) : JzRepoResource.createFromVersionable(provider, loc.child(childName), vH);
                result.put(childName, value);
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static WvcmException.ReasonCode exceptionToReasonCode(Exception e) {
        WvcmException.ReasonCode result = WvcmException.ReasonCode.FORBIDDEN;
        if (e instanceof PermissionDeniedException) {
            result = WvcmException.ReasonCode.UNAUTHORIZED;
        } else if (e instanceof ItemNotFoundException) {
            result = WvcmException.ReasonCode.NOT_FOUND;
        }
        return result;
    }

    protected List<SrvcResource.SrvcCompareReport> computeWvcmCompareReport(final IConnection thisConn, final IConnection otherConn, final List<IComponentHandle> includedComponents, List<IComponentHandle> excludedComponents, VersionSet.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        boolean computeActivityReport = flags != null && Arrays.asList(flags).contains(VersionSet.CompareFlag.ACTIVITIES);
        boolean thisIsBaselineConnection = thisConn instanceof IBaselineConnection;
        boolean otherIsBaselineConnection = otherConn instanceof IBaselineConnection;
        JzLocation helperWsHintLocation = new JzLocation("doCompareHelper");
        ArrayList<SrvcResource.SrvcCompareReport> results = new ArrayList<SrvcResource.SrvcCompareReport>();
        boolean debugLogEnabled = this.isDebugLogEnabled();
        if (debugLogEnabled) {
            String includedNames = this.commaSeparatedComponentNames(includedComponents, feedback.nest(3));
            this.logDebug("included components: " + includedNames);
            String excludedNames = this.commaSeparatedComponentNames(excludedComponents, feedback.nest(8));
            this.logDebug("excluded components: " + excludedNames);
        }
        IWorkspaceConnection helperWsConn = null;
        JzRepoWorkspace helperWs = null;
        try {
            try {
                if (thisIsBaselineConnection) {
                    helperWs = JzRepoWorkspace.doCreateGeneratedWorkspace(this.provider(), helperWsHintLocation, null, null, "doCompareHelper", null, null, feedback.nest(10));
                    helperWsConn = helperWs.getConnection(feedback);
                    helperWsConn.applyComponentOperations(Collections.singletonList(new IFlowNodeConnection.IComponentAdditionOp(){

                        public IConnection getSeedConnection() {
                            return thisConn;
                        }

                        public IComponentHandle getComponent() {
                            return (IComponentHandle)includedComponents.get(0);
                        }

                        public boolean requiresDetails() {
                            return false;
                        }
                    }), JzProvider.getMonitor(feedback, 20));
                } else {
                    helperWs = JzRepoWorkspace.doCreateGeneratedWorkspace(this.provider(), helperWsHintLocation, null, null, "doCompareHelper", (IWorkspaceHandle)((IWorkspaceConnection)thisConn).getResolvedWorkspace(), null, feedback.nest(10));
                    helperWsConn = helperWs.getConnection(feedback.nest(20));
                    if (debugLogEnabled) {
                        String helperNames = this.commaSeparatedComponentNames(helperWsConn.getComponents(), feedback.nest(21));
                        this.logDebug("components in helper workspace: " + helperNames);
                    }
                }
                IChangeHistorySyncReport activityReport = null;
                if (computeActivityReport) {
                    activityReport = otherIsBaselineConnection ? helperWsConn.compareToBaseline(((IBaselineConnection)otherConn).getBaseline(), JzProvider.getMonitor(feedback, 25)) : helperWsConn.compareTo((IFlowNodeConnection)otherConn, 0, Collections.EMPTY_LIST, JzProvider.getMonitor(feedback, 25));
                    this.addActivitiesToReport(activityReport, results);
                }
                IUpdateReport comparisonReport = null;
                IProgressMonitor monitor50 = JzProvider.getMonitor(feedback, 50);
                comparisonReport = thisIsBaselineConnection ? helperWsConn.applyComponentOperations(Collections.singletonList(new IFlowNodeConnection.IComponentReplacementOp(){

                    public boolean requiresDetails() {
                        return true;
                    }

                    public IComponentHandle getComponent() {
                        return (IComponentHandle)includedComponents.get(0);
                    }

                    public IConnection getSeedConnection() {
                        return otherConn;
                    }
                }), monitor50) : helperWsConn.compareConfigurations((IFlowNodeConnection)otherConn, null, monitor50);
                this.computeWvcmCompareReport(comparisonReport, results, feedback.nest(90));
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        }
        finally {
            if (helperWs != null) {
                helperWs.doUnbindAll(feedback);
            }
        }
        return results;
    }

    public String commaSeparatedComponentNames(Collection<IComponentHandle> componentHandles, SrvcFeedback feedback) throws WvcmException {
        StringBuffer names = new StringBuffer();
        boolean insertComma = false;
        for (IComponentHandle componentHandle : componentHandles) {
            if (insertComma) {
                names.append(JzProvider.COMMA_SPACE);
            } else {
                insertComma = true;
            }
            names.append(JzRepoComponent.create(componentHandle, this.provider()).getName(feedback));
        }
        return names.toString();
    }

    protected void computeWvcmCompareReport(IUpdateReport comparisonReport, List<SrvcResource.SrvcCompareReport> results, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        int conflictCount = comparisonReport.conflicts().size();
        if (conflictCount > 0) {
            throw new WvcmException("computeWvcmCompareReport: expected zero conflicts.  found: " + Integer.toString(conflictCount), WvcmException.ReasonCode.FORBIDDEN);
        }
        Collection updates = comparisonReport.updates();
        this.logDebug("computing Wvcm Compare Report with item updates: " + Integer.toString(updates.size()));
        for (IItemUpdateReport u : updates) {
            IVersionableHandle previousState = u.getPreviousState();
            IVersionableHandle newCurrentState = u.getNewCurrentState();
            JzRepoComponent priorJzRepoComponent = JzRepoComponent.create(u.getPriorComponent(), provider);
            JzRepoComponent newJzRepoComponent = JzRepoComponent.create(u.getComponent(), provider);
            if (previousState == null) {
                results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcAddedVersion((SrvcResource)JzRepoResource.versionableToVersion(provider, newJzRepoComponent, newCurrentState, feedback)));
                continue;
            }
            if (newCurrentState == null) {
                results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcDeletedVersion((SrvcResource)JzRepoResource.versionableToVersion(provider, newJzRepoComponent, previousState, feedback)));
                continue;
            }
            if (priorJzRepoComponent.getComponentItemHandle(feedback.nest(10)).sameItemId((IItemHandle)newJzRepoComponent.getComponentItemHandle(feedback.nest(20)))) {
                results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcChangedVersion((SrvcResource)JzRepoResource.versionableToVersion(provider, newJzRepoComponent, previousState, feedback.nest(50)), (SrvcResource)JzRepoResource.versionableToVersion(provider, newJzRepoComponent, newCurrentState, feedback)));
                continue;
            }
            results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcDeletedVersion((SrvcResource)JzRepoResource.versionableToVersion(provider, priorJzRepoComponent, previousState, feedback.nest(50))));
            results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcAddedVersion((SrvcResource)JzRepoResource.versionableToVersion(provider, newJzRepoComponent, newCurrentState, feedback)));
        }
    }

    protected void addActivitiesToReport(IChangeHistorySyncReport activityReport, List<SrvcResource.SrvcCompareReport> results) throws WvcmException {
        if (activityReport != null) {
            JzProvider provider = this.provider();
            ArrayList<JzRepoChangeSet> changeSets = this.createWvcmChangeSetsForJazzChangeSets(provider, activityReport.incomingChangeSets());
            for (JzRepoChangeSet cs : changeSets) {
                results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcAddedActivity((SrvcResource)cs));
            }
            changeSets.clear();
            changeSets = this.createWvcmChangeSetsForJazzChangeSets(provider, activityReport.outgoingChangeSets());
            for (JzRepoChangeSet cs : changeSets) {
                results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcDeletedActivity((SrvcResource)cs));
            }
        }
    }

    protected ArrayList<JzRepoChangeSet> createWvcmChangeSetsForJazzChangeSets(JzProvider provider, List<IChangeSetHandle> incomingCS) throws WvcmException {
        ArrayList<JzRepoChangeSet> changeSets = new ArrayList<JzRepoChangeSet>(incomingCS.size());
        for (IChangeSetHandle cSH : incomingCS) {
            String displayName = JzRepoResource.getCurrentStateDisplayName((IItemHandle)cSH);
            JzRepoChangeSet serverProxy = (JzRepoChangeSet)provider.get((Location)JzLocation.createChangeSetLocation(displayName), null);
            changeSets.add(serverProxy);
        }
        return changeSets;
    }

    static JzRepoVersion versionableToVersion(JzProvider provider, JzRepoComponent newJzRepoComponent, IVersionableHandle versionableHandle, SrvcFeedback feedback) throws WvcmException {
        String displayName = JzRepoResource.getItemStateDisplayName(versionableHandle);
        JzRepoVersion result = JzRepoVersion.createAppropriateProxy(provider, newJzRepoComponent.location().createVersionLocation(displayName), (IItemHandle)versionableHandle, feedback);
        return result;
    }

    public static List<IWorkspaceHandle> findAllStreamsOrWorkspacesByName(JzProvider provider, String name, boolean findStreams, IProgressMonitor monitor) throws WvcmException {
        ITeamRepository repo = provider.getRepo();
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IWorkspaceSearchCriteria crit = IWorkspaceSearchCriteria.FACTORY.newInstance();
        crit.setExactName(name);
        crit.setKind(findStreams ? 1 : 2);
        try {
            return wm.findWorkspaces(crit, 100, monitor);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static void getVersionList(JzProvider provider, JzRepoComponent comp, IConfiguration config, List<JzRepoVersion> result, SrvcFeedback feedback) throws WvcmException {
        try {
            IFolder root = config.partialRootFolder(null, JzProvider.getMonitor(feedback, 30));
            result.add(JzRepoResource.versionableToVersion(provider, comp, (IVersionableHandle)root, feedback.nest(60)));
            JzRepoResource.computeVersionList(provider, comp, config, (IFolderHandle)root, result, feedback);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private static void computeVersionList(JzProvider provider, JzRepoComponent comp, IConfiguration config, IFolderHandle folderHandle, List<JzRepoVersion> versionList, SrvcFeedback feedback) throws WvcmException {
        try {
            Map kids = config.childEntries(folderHandle, JzProvider.getMonitor(feedback, 30));
            int size = kids.size();
            int count = 0;
            for (IVersionableHandle childHandle : kids.values()) {
                int done = JzProvider.FB_BASE(31, 95, count++, size);
                versionList.add(JzRepoResource.versionableToVersion(provider, comp, childHandle, feedback.nest(done)));
                if (!childHandle.getItemType().equals(IFolder.ITEM_TYPE)) continue;
                JzRepoResource.computeVersionList(provider, comp, config, (IFolderHandle)childHandle, versionList, feedback.nest(done + 5));
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    protected void doCreateResourceHelper(Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback f) throws WvcmException {
        HashMap remainingUpdates = new HashMap(updates);
        for (PropertyNameList.PropertyName<?> propertyName : updated) {
            remainingUpdates.remove(propertyName);
        }
        Set s = remainingUpdates.entrySet();
        for (Map.Entry entry : s) {
            PropertyNameList.PropertyName propertyName = (PropertyNameList.PropertyName)entry.getKey();
            PropValue propValue = (PropValue)entry.getValue();
            Object valueObject = propValue.get_value();
            if (valueObject instanceof String) {
                this.storeCustomProperty(propertyName, (String)valueObject, true, f);
            } else if (valueObject instanceof List) {
                this.storeCustomProperty(propertyName, (List)valueObject, true, f);
            } else {
                throw new IllegalArgumentException("Cannot set properties of with value class: " + valueObject.getClass().getName());
            }
            updated.add(propertyName);
        }
    }

    public static void forEachCloneLink(JzProvider provider, IVisitCloneLink visitor) throws WvcmException {
        JzRepoResource.forEachLink(provider, CcConnectorUtils.CLONE_LINK_TYPE, visitor);
    }

    public static void forEachLink(JzProvider provider, String linkType, IVisitCloneLink visitor) throws WvcmException {
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        NullProgressMonitor fakeMonitor = new NullProgressMonitor();
        try {
            ILinkQueryPage queryPage = linkManager.findLinks(new String[]{linkType}, (IProgressMonitor)fakeMonitor);
            Collection links = queryPage.getLinks().getLinksById(linkType);
            for (ILink cloneLink : links) {
                visitor.visit(cloneLink);
            }
            while (queryPage.hasNext()) {
                queryPage = queryPage.next();
                links = queryPage.getLinks().getLinksById(linkType);
                for (ILink cloneLink : links) {
                    visitor.visit(cloneLink);
                }
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static String convertToQueryPattern(String text, boolean matchAnyAtBeginning, boolean matchAnyAtEnd) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (matchAnyAtBeginning && i == 0 && ch != '*') {
                buffer.append("%");
            }
            switch (ch) {
                case '*': {
                    buffer.append("%");
                    break;
                }
                case '?': {
                    buffer.append("_");
                    break;
                }
                case '%': {
                    buffer.append("\\%");
                    break;
                }
                case '_': {
                    buffer.append("\\_");
                    break;
                }
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            if (matchAnyAtEnd && i == text.length() - 1 && ch != '*') {
                buffer.append("%");
            }
            ++i;
        }
        return buffer.toString();
    }

    public static class CountingVisitor
    implements IVisitCloneLink {
        private int _visits = 0;
        private int _matches = 0;
        private boolean _verbose = false;

        public CountingVisitor(boolean verbose) {
            this._verbose = verbose;
        }

        @Override
        public boolean visit(ILink cloneLink) throws WvcmException {
            String targetString;
            ++this._visits;
            IReference sourceRef = cloneLink.getSourceRef();
            IItemHandle referencedItem = sourceRef.isItemReference() ? ((IItemReference)sourceRef).getReferencedItem() : null;
            IReference targetRef = cloneLink.getTargetRef();
            String string = targetString = targetRef.isURIReference() ? JzRepoResource.createValueFromUri(((IURIReference)targetRef).getURI()) : null;
            if (referencedItem != null && targetString != null) {
                ++this._matches;
                CountingVisitor.printCloneLinkInfo(referencedItem, targetString, this._verbose);
            }
            return true;
        }

        public int getVisits() {
            return this._visits;
        }

        public int getMatches() {
            return this._matches;
        }

        public static void printCloneLinkInfo(IItemHandle thisItem, String uriString, boolean verbose) throws WvcmException {
            String thisString = verbose ? JzRepoResource.getCurrentStateDisplayName(thisItem) : thisItem.getItemType().getName();
            System.out.printf("thisInfo: %s, otherUri: %s\n", thisString, uriString);
        }

        public void reset() {
            this._visits = 0;
            this._matches = 0;
        }
    }

    public static interface IVisitCloneLink {
        public boolean visit(ILink var1) throws WvcmException;
    }

    static class LinkInfo {
        public JzRepoResource jrrForMessages;
        public IItemReference _sourceRef;
        public String _targetCloneValue;
        public IURIReference _targetRef;
        public Object _result;

        LinkInfo() {
        }
    }

    public static enum LinkTypeInfo {
        CLONE(InteropCore.PN_CLONE, CcConnectorUtils.CLONE_LINK_TYPE, true, false),
        TRACKS(UcmImporter.PN_TRACKS_UCM_METADATUM, CcConnectorUtils.TRACKS_UCM_METADATA_OBJECT, false, false),
        REQUIRES(UcmImporter.PN_REQUIRES_UCM_METADATA, CcConnectorUtils.UCM_IMP_WORK_ITEM_DEPENDS_UPON_LINK_TYPE, false, true);

        final PropertyNameList.PropertyName<?> propertyName;
        final String linkType;
        final boolean ensureUnique;
        final boolean hasListValue;
        static final EnumSet<LinkTypeInfo> LinkTypeInfoEnumSet;
        static final Map<PropertyNameList.PropertyName<?>, LinkTypeInfo> LinkTypeInfoMap;

        static {
            LinkTypeInfoEnumSet = EnumSet.allOf(LinkTypeInfo.class);
            LinkTypeInfoMap = new HashMap(LinkTypeInfoEnumSet.size());
            for (LinkTypeInfo info : LinkTypeInfoEnumSet) {
                LinkTypeInfoMap.put(info.propertyName, info);
            }
        }

        private LinkTypeInfo(PropertyNameList.PropertyName<?> propertyName, String name, boolean ensureUnique, boolean hasListValue) {
            this.propertyName = propertyName;
            this.linkType = name;
            this.ensureUnique = ensureUnique;
            this.hasListValue = hasListValue;
        }

        boolean ensureUnique() {
            return this.ensureUnique;
        }

        static boolean isLinkPropertyName(PropertyNameList.PropertyName<?> propertyName) {
            return LinkTypeInfo.lookup(propertyName) != null;
        }

        static boolean isListProperty(PropertyNameList.PropertyName<?> propertyName) {
            LinkTypeInfo info = LinkTypeInfo.lookup(propertyName);
            return info != null && info.hasListValue;
        }

        static LinkTypeInfo lookup(PropertyNameList.PropertyName<?> propertyName) {
            return LinkTypeInfoMap.get(propertyName);
        }
    }

    public static class SegmentFoldingDescriptor {
        int _formatVersion;
        int _totalLength;
        int _maxSegmentLength;
        int _numSegments;
        private static String nameEqualNumberSemi = "\\w+=(\\d+);";
        private static Pattern decodePattern = Pattern.compile(String.valueOf(nameEqualNumberSemi) + nameEqualNumberSemi + nameEqualNumberSemi + nameEqualNumberSemi);

        public SegmentFoldingDescriptor(int version, int length, int segmentLength, int segments) {
            this._formatVersion = version;
            this._totalLength = length;
            this._maxSegmentLength = segmentLength;
            this._numSegments = segments;
        }

        public SegmentFoldingDescriptor(String encodedDescriptor) {
            Matcher m = decodePattern.matcher(encodedDescriptor);
            if (!m.find()) {
                throw new IllegalStateException("Could not parse segment folding descriptor: " + encodedDescriptor);
            }
            this._formatVersion = Integer.parseInt(m.group(1));
            this._totalLength = Integer.parseInt(m.group(2));
            this._maxSegmentLength = Integer.parseInt(m.group(3));
            this._numSegments = Integer.parseInt(m.group(4));
        }

        public String encode() {
            return String.format("formatVersion=%d;totalLength=%d;maxSegmentLength=%d;numSegments=%d;", this._formatVersion, this._totalLength, this._maxSegmentLength, this._numSegments);
        }
    }

    public static class URIRefComparator
    implements Comparator<IURIReference> {
        @Override
        public int compare(IURIReference o1, IURIReference o2) {
            return o1.getURI().compareTo(o2.getURI());
        }
    }
}

