/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.interop.UcmImporter;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.TaskImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.workitem.WorkItemHelper;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.connector.scm.common.CcConnectorUtils;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.StatusVariable;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IQueryResult;
import com.ibm.team.workitem.common.query.IResult;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Task;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class JzRepoWorkItem
extends JzRepoResource {
    private static final String UTF_8 = "UTF-8";
    private static final int JUST_UNDER_32K = 32760;
    static Map<String, Integer> status2WorkFlowGroupId = new HashMap<String, Integer>();

    static {
        status2WorkFlowGroupId.put(UcmImporter.TaskState.INITIAL.displayName(), 1);
        status2WorkFlowGroupId.put(UcmImporter.TaskState.IN_PROGRESS.displayName(), 4);
        status2WorkFlowGroupId.put(UcmImporter.TaskState.DONE.displayName(), 2);
    }

    public JzRepoWorkItem(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return TaskImpl.class;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)InteropUtilities.PN_TASK_ID)) {
            return this.getTaskId(feedback);
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getDisplayName(feedback);
        }
        if (propertyName.equals((Object)Resource.COMMENT)) {
            return this.getComment(feedback);
        }
        if (propertyName.equals((Object)Task.ACTIVITY_LIST)) {
            return this.getActivityList(feedback);
        }
        if (propertyName.equals((Object)UcmImporter.PN_CM_STATUS)) {
            return this.getState(feedback);
        }
        if (propertyName.equals((Object)UcmImporter.PN_TAGS)) {
            return this.getWorkItem(feedback).getTags2();
        }
        if (propertyName.equals((Object)UcmImporter.PN_DURATION)) {
            return String.valueOf(this.getWorkItem(feedback).getDuration());
        }
        if (propertyName.equals((Object)UcmImporter.PN_CM_DEPENDS_ON_TASKS)) {
            return this.getBlockingTaskResIds(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private List<String> getBlockingTaskResIds(SrvcFeedback f) throws WvcmException {
        ArrayList<String> results = new ArrayList<String>();
        IEndPointDescriptor blocksEndPoint = ILinkTypeRegistry.INSTANCE.getLinkType("com.ibm.team.workitem.linktype.blocksworkitem").getSourceEndPointDescriptor();
        IWorkItemHandle h = (IWorkItemHandle)this.getItemHandle(f.nest(10));
        IWorkItemCommon common = this.getIWorkItemCommon();
        try {
            IWorkItemReferences refs = common.resolveWorkItemReferences(h, JzProvider.getMonitor(f, 20));
            List blockerRefs = refs.getReferences(blocksEndPoint);
            for (IReference iReference : blockerRefs) {
                IItemHandle refHandle = (IItemHandle)iReference.resolve();
                if (!(refHandle instanceof IWorkItemHandle)) continue;
                IWorkItemHandle blockerHandle = (IWorkItemHandle)refHandle;
                String blockerResId = JzLocation.createWorkItemLoc(JzRepoWorkItem.getCurrentStateDisplayName((IItemHandle)blockerHandle)).string();
                results.add(blockerResId);
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private IWorkItemCommon getIWorkItemCommon() {
        return JzRepoWorkItem.getIWorkItemCommon(this.provider());
    }

    public static IWorkItemCommon getIWorkItemCommon(JzProvider provider) {
        return (IWorkItemCommon)provider.getRepo().getClientLibrary(IWorkItemCommon.class);
    }

    private String getState(SrvcFeedback feedback) throws WvcmException {
        IWorkItem workItem = this.getWorkItem(feedback.nest(10));
        JzProvider provider = this.provider();
        ITeamRepository repo = provider.getRepo();
        IWorkItemClient workItemClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        try {
            IWorkflowInfo flow = workItemClient.findWorkflowInfo(workItem, JzProvider.getMonitor(feedback, 20));
            Identifier stateId = workItem.getState2();
            String result = flow.getStateName(stateId);
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private String getTaskId(SrvcFeedback feedback) throws WvcmException {
        return Integer.toString(this.getWorkItem(feedback).getId());
    }

    @Override
    public String getDisplayName(SrvcFeedback feedback) throws WvcmException {
        IWorkItem workItem = this.getWorkItem(feedback);
        String result = workItem.getHTMLSummary().getPlainText();
        return result;
    }

    private String getComment(SrvcFeedback feedback) throws WvcmException {
        IWorkItem workItem = this.getWorkItem(feedback);
        String result = workItem.getHTMLDescription().getPlainText();
        return result;
    }

    private IWorkItem getWorkItem(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        ITeamRepository repo = provider.getRepo();
        IWorkItemHandle myItemHandle = (IWorkItemHandle)this.getItemHandle(feedback.nest(20));
        try {
            return JzRepoWorkItem.resolveWorkItem(repo, myItemHandle, feedback);
        }
        catch (ItemNotFoundException notFoundException) {
            throw JzProvider.wrapException((Exception)((Object)notFoundException));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static IWorkItem resolveWorkItem(ITeamRepository repo, IWorkItemHandle myItemHandle, SrvcFeedback feedback) throws TeamRepositoryException {
        IAuditableClient auditableClient = (IAuditableClient)repo.getClientLibrary(IAuditableClient.class);
        IWorkItem workItem = (IWorkItem)auditableClient.fetchCurrentAuditable((IAuditableHandle)myItemHandle, IWorkItem.FULL_PROFILE, JzProvider.getMonitor(feedback, 100));
        return workItem;
    }

    private static IWorkItem createWorkItem(JzProvider provider, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback fb) throws WvcmException {
        ITeamRepository repo = provider.getRepo();
        XMLString summary = null;
        XMLString description = null;
        Long duration = null;
        List tags = null;
        List<IItemReference> blockingTaskItemReferences = null;
        if (updates != null) {
            PropValue commentValue;
            PropValue blockingTasksValue;
            PropValue tagsValue;
            PropValue durationValue;
            PropValue nameValue = updates.get(Resource.DISPLAY_NAME);
            if (nameValue != null) {
                summary = XMLString.createFromPlainText((String)((String)nameValue.get_value()));
                updated.add(Resource.DISPLAY_NAME);
            }
            if ((durationValue = updates.get(UcmImporter.PN_DURATION)) != null) {
                duration = Long.valueOf((String)durationValue.get_value());
                updated.add(UcmImporter.PN_DURATION);
            }
            if ((tagsValue = updates.get(UcmImporter.PN_TAGS)) != null) {
                tags = (List)tagsValue.get_value();
                updated.add(UcmImporter.PN_TAGS);
            }
            if ((blockingTasksValue = updates.get(UcmImporter.PN_CM_DEPENDS_ON_TASKS)) != null) {
                List blockingTaskLocStrings = (List)blockingTasksValue.get_value();
                blockingTaskItemReferences = JzRepoWorkItem.taskLocationStringstoReferences(provider, blockingTaskLocStrings, fb.nest(15));
                updated.add(UcmImporter.PN_CM_DEPENDS_ON_TASKS);
            }
            if ((commentValue = updates.get(Resource.COMMENT)) != null) {
                description = JzRepoWorkItem.truncateAndXmlEncode((String)commentValue.get_value(), 32760, fb.nest(40));
                updated.add(Resource.COMMENT);
            }
        }
        try {
            IProcessArea processArea = provider.getProcessArea(fb.nest(10));
            IWorkItem templateItem = JzRepoWorkItem.lookupTemplateItem(provider, fb.nest(20));
            IWorkItemType workItemType = JzRepoWorkItem.getWorkItemType(provider, templateItem, fb.nest(30));
            JzRepoWorkItemOperation op = new JzRepoWorkItemOperation(provider, processArea, templateItem, summary, duration, tags, blockingTaskItemReferences, description, fb.nest(50));
            IWorkItemHandle resultHandle = op.run(workItemType, JzProvider.getMonitor(fb, 90));
            try {
                IBuildResult buildResult = provider.lookupBuildResultThrowsTRE(fb.nest(75));
                if (buildResult != null) {
                    WorkItemHelper.linkIncludedWorkItem((ITeamRepository)repo, (IBuildResultHandle)buildResult, (IWorkItemHandle)resultHandle, (IProgressMonitor)JzProvider.getMonitor(fb, 75));
                    WorkItemHelper.setFixedInBuild((ITeamRepository)repo, (IBuildResultHandle)buildResult, (IWorkItemHandle[])new IWorkItemHandle[]{resultHandle});
                }
            }
            catch (TeamRepositoryException e) {
                fb.notifyWarning(NLS.bind((String)Messages.JzRepoWorkItem_WARN_CANT_CREATE_BUILDRESULT_WORKITEM_LINK, (Object)e.getMessage(), (Object[])new Object[0]));
            }
            IAuditableClient auditableClient = (IAuditableClient)repo.getClientLibrary(IAuditableClient.class);
            IWorkItem result = (IWorkItem)auditableClient.resolveAuditable((IAuditableHandle)resultHandle, IWorkItem.FULL_PROFILE, JzProvider.getMonitor(fb, 100));
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoWorkItem_ERROR_SAVE_ITEM_FAILED_WITH_DETAILS, (Object)e.getMessage(), (Object[])new Object[0]), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    private static void addBlockingTasks(JzProvider provider, IWorkItemReferences refs, List<String> blockingTasks, SrvcFeedback f) throws WvcmException {
        List<IItemReference> references = JzRepoWorkItem.taskLocationStringstoReferences(provider, blockingTasks, f);
        JzRepoWorkItem.addReferences(references, refs);
    }

    private static void addReferences(List<IItemReference> references, IWorkItemReferences refs) {
        IEndPointDescriptor blocksEndPoint = ILinkTypeRegistry.INSTANCE.getLinkType("com.ibm.team.workitem.linktype.blocksworkitem").getSourceEndPointDescriptor();
        for (IItemReference reference : references) {
            refs.add(blocksEndPoint, (IReference)reference);
        }
    }

    private static List<IItemReference> taskLocationStringstoReferences(JzProvider provider, List<String> taskLocationStrings, SrvcFeedback f) throws WvcmException {
        int count = taskLocationStrings.size();
        int i = 1;
        ArrayList<IItemReference> results = new ArrayList<IItemReference>(count);
        for (String taskResId : taskLocationStrings) {
            JzRepoWorkItem jzRepoWorkItem = JzRepoWorkItem.lookup(provider, new JzLocation(taskResId));
            IItemHandle blockingHandle = jzRepoWorkItem.getItemHandle(f.nest(InteropUtilities.LP((int)50, (int)i++, (int)(1 + count), (int)1, (int)50)));
            IItemReference reference = IReferenceFactory.INSTANCE.createReferenceToItem(blockingHandle);
            results.add(reference);
        }
        return results;
    }

    private static XMLString truncateAndXmlEncode(String originalDescription, int max, SrvcFeedback fb) throws WvcmException {
        boolean truncated = false;
        String description = originalDescription;
        int truncateBy = Messages.JzRepoWorkItem_INFO_DESCRIPTION_TRUNCATED.length() + 20;
        try {
            XMLString result;
            byte[] utf8Encoded;
            while ((utf8Encoded = (result = XMLString.createFromPlainText((String)description)).toString().getBytes(UTF_8)).length > max) {
                description = NLS.bind((String)Messages.JzRepoWorkItem_INFO_DESCRIPTION_TRUNCATED, (Object)originalDescription.substring(0, originalDescription.length() - truncateBy), (Object[])new Object[0]);
                truncateBy += 20;
                truncated = true;
            }
            if (truncated) {
                fb.notifyWarning(Messages.JzRepoWorkItem_WARN_DESCRIPTION_TRUNCATED);
            }
            return result;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Could not encode workitem description via encoding: UTF-8");
        }
    }

    private static ICategoryHandle lookupCategory(JzProvider provider, IProcessArea processArea, IWorkItemClient clientLib, IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        List categories = clientLib.findCategoriesOfProcessArea((IProcessAreaHandle)processArea, ICategory.DEFAULT_PROFILE, monitor);
        if (categories.isEmpty()) {
            categories = clientLib.findCategories(processArea.getProjectArea(), ICategory.DEFAULT_PROFILE, monitor);
        }
        ICategory unassigned = clientLib.findUnassignedCategory(processArea.getProjectArea(), ICategory.DEFAULT_PROFILE, monitor);
        ICategory category = null;
        for (ICategory c : categories) {
            if (ItemUtil.equivItemRef((IItemHandle)unassigned, (IItemHandle)c)) continue;
            category = c;
            break;
        }
        if (category != null && provider.isDebugLogEnabled()) {
            ICategory cat = (ICategory)JzRepoWorkItem.itemManager(provider).fetchPartialItem((IItemHandle)category, 0, Collections.singletonList(ICategory.NAME_PROPERTY), monitor);
            provider.logDebug("assigning category: " + cat.getName());
        }
        return category;
    }

    private static IWorkItemType getWorkItemType(JzProvider provider, IWorkItem templateItem, SrvcFeedback feedback) throws TeamRepositoryException, WvcmException {
        String itemName = templateItem != null ? templateItem.getWorkItemType() : "task";
        IWorkItemClient workItemClient = (IWorkItemClient)provider.getRepo().getClientLibrary(IWorkItemClient.class);
        IWorkItemType result = workItemClient.findWorkItemType(provider.getProcessArea(feedback.nest(50)).getProjectArea(), itemName, JzProvider.getMonitor(feedback, 100));
        if (result == null) {
            throw new WvcmException("Internal error.  Could not find task workitem type", WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    private static IWorkItem lookupTemplateItem(JzProvider provider, SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkItem proxy;
        IWorkItem result = null;
        String templateId = provider.getTemplateId();
        if (templateId != null && !provider.templateIdHasInitialValue() && (proxy = JzRepoWorkItem.lookupById(provider, templateId, feedback.nest(50))) != null) {
            result = proxy.getWorkItem(feedback);
            IProjectArea projectArea = provider.getProjectArea(feedback.nest(60));
            if (!result.getProjectArea().sameItemId((IItemHandle)projectArea)) {
                throw new WvcmException(Messages.JzRepoWorkItem_ERROR_TEMPLATE_IN_WRONG_PROJECT_AREA, WvcmException.ReasonCode.FORBIDDEN);
            }
        }
        return result;
    }

    public static SrvcResource doCreateGeneratedResource(JzProvider provider, JzLocation loc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback f) throws WvcmException {
        IWorkItem wi = JzRepoWorkItem.createWorkItem(provider, updates, updated, f.nest(10));
        JzRepoWorkItem result = JzRepoWorkItem.create(provider, (IWorkItemHandle)wi);
        result.doCreateResourceHelper(updates, updated, f);
        provider.logCreation("WorkItem", result.location());
        return result;
    }

    public static JzRepoWorkItem create(JzProvider provider, IWorkItemHandle wiHandle) {
        JzRepoWorkItem result = new JzRepoWorkItem(provider, (Location)JzLocation.createWorkItemLoc(JzRepoWorkItem.getCurrentStateDisplayName((IItemHandle)wiHandle)));
        result.setItemHandle((IItemHandle)wiHandle);
        return result;
    }

    public static JzRepoWorkItem lookup(JzProvider provider, JzLocation loc) throws WvcmException {
        JzRepoWorkItem result = null;
        IItemHandle myItemHandle = JzRepoWorkItem.lookupItemHandle(provider, loc);
        if (myItemHandle != null) {
            result = new JzRepoWorkItem(provider, (Location)loc);
            result.setItemHandle(myItemHandle);
        }
        return result;
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback f) throws WvcmException {
        if (propertyName.equals((Object)Resource.COMMENT)) {
            XMLString truncateAndXmlEncodedComment = JzRepoWorkItem.truncateAndXmlEncode((String)value, 32760, f.nest(20));
            this.updateWorkItem(null, null, null, truncateAndXmlEncodedComment, null, null, f);
        } else if (propertyName.equals((Object)UcmImporter.PN_CM_STATUS)) {
            this.updateWorkItem(null, null, null, null, UcmImporter.TaskState.lookup((String)((String)value)), this.provider().getRepo(), f);
        } else if (propertyName.equals((Object)UcmImporter.PN_DURATION)) {
            this.updateWorkItem(null, Long.valueOf((String)value), null, null, null, null, f);
        } else if (propertyName.equals((Object)UcmImporter.PN_TAGS)) {
            this.updateWorkItem(null, null, (List)value, null, null, null, f);
        } else if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            XMLString summary = XMLString.createFromPlainText((String)((String)value));
            this.updateWorkItem(summary, null, null, null, null, null, f);
        } else if (propertyName.getNamespace() != null) {
            this.storeCustomProperty(propertyName, (String)value, initialize, f);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, f);
        }
    }

    private void updateWorkItem(XMLString summary, Long duration, List<String> tags, XMLString truncatedXmlEncodedComment, UcmImporter.TaskState nextTaskState, ITeamRepository repo, SrvcFeedback f) throws WvcmException {
        IWorkItemHandle workItemHandle = (IWorkItemHandle)this.getItemHandle(f.nest(10));
        JzRepoWorkItemOperation op = new JzRepoWorkItemOperation(summary, duration, tags, null, truncatedXmlEncodedComment, nextTaskState, repo, f.nest(20));
        try {
            op.run(workItemHandle, JzProvider.getMonitor(f, 99));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    @Override
    public void removePropertyFromClient(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)InteropCore.PN_CLONE)) {
            this.removeInteropCloneValue(feedback);
        } else {
            super.removePropertyFromClient(propertyName, feedback);
        }
    }

    private List<SrvcResource> getActivityList(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        List<IChangeSetHandle> changeSetHandles = this.getChangeSetHandles(feedback.nest(30));
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(changeSetHandles.size());
        for (IChangeSetHandle changeSetHandle : changeSetHandles) {
            results.add(JzRepoChangeSet.create(provider, changeSetHandle, feedback));
        }
        return results;
    }

    private List<IChangeSetHandle> getChangeSetHandles(SrvcFeedback feedback) throws WvcmException {
        ArrayList<IChangeSetHandle> results = new ArrayList<IChangeSetHandle>();
        JzProvider provider = this.provider();
        IWorkItemHandle myHandle = (IWorkItemHandle)this.getItemHandle(feedback.nest(10));
        try {
            ILinkManager linkManager = JzRepoWorkItem.getLinkManager(provider);
            IItemReference reference = CcConnectorUtils.createReferenceToItem((IItemHandle)myHandle);
            Collection linkCollection = linkManager.findLinksByTarget("com.ibm.team.filesystem.workitems.change_set", (IReference)reference, JzProvider.getMonitor(feedback, 100)).getAllLinksFromHereOn().getLinksById("com.ibm.team.filesystem.workitems.change_set");
            for (ILink link : linkCollection) {
                IReference sourceRef = link.getSourceRef();
                if (!sourceRef.isItemReference()) continue;
                IChangeSetHandle csh = (IChangeSetHandle)((IItemReference)sourceRef).getReferencedItem();
                results.add(csh);
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        return results;
    }

    public static JzRepoWorkItem lookupById(JzProvider provider, String requestedId, SrvcFeedback feedback) throws WvcmException {
        if (requestedId == null) {
            throw new IllegalArgumentException("requestId must not be null");
        }
        JzRepoWorkItem result = null;
        int id = Integer.parseInt(requestedId);
        try {
            IWorkItemClient workItemClient = (IWorkItemClient)provider.getRepo().getClientLibrary(IWorkItemClient.class);
            List workItemList = workItemClient.findWorkItemsById(Collections.singletonList(id), JzProvider.getMonitor(feedback, 50));
            if (workItemList.size() > 0) {
                IWorkItemHandle workItemHandle = (IWorkItemHandle)workItemList.get(0);
                result = JzRepoWorkItem.create(provider, workItemHandle);
            }
        }
        catch (ItemNotFoundException e) {
            provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoWorkItem.lookupById", (Exception)((Object)e));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        return result;
    }

    private static void copyPartialWorkItem(IWorkItem targetItem, IWorkItem sourceItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList includedProperties = new ArrayList(IWorkItem.FULL_PROFILE.getProperties());
        includedProperties.remove(IWorkItem.ID_PROPERTY);
        for (String attributeId : includedProperties) {
            IAttribute attribute = workItemCommon.findAttribute(sourceItem.getProjectArea(), attributeId, monitor);
            if (attribute == null) continue;
            targetItem.setValue(attribute, JzRepoWorkItem.copy(sourceItem.getValue(attribute)));
        }
    }

    private static Object copy(Object from) {
        if (from instanceof Collection) {
            return JzRepoWorkItem.copy((Collection)from);
        }
        if (!(from instanceof EObject)) {
            return from;
        }
        EObject copy = EcoreUtil.copy((EObject)((EObject)from));
        if (copy instanceof Item) {
            Item itemCopy = (Item)copy;
            itemCopy.setWorkingCopy(((Item)from).isWorkingCopy());
            if (copy instanceof Auditable) {
                Auditable auditableCopy = (Auditable)itemCopy;
                Auditable auditableFrom = (Auditable)from;
                auditableCopy.setWorkingCopyMergePredecessor(auditableFrom.getWorkingCopyMergePredecessor());
                auditableCopy.setWorkingCopyPredecessor(auditableFrom.getWorkingCopyPredecessor());
            }
        }
        return copy;
    }

    public static Collection<?> copy(Collection<?> from) {
        ArrayList<Object> copy = new ArrayList<Object>(from.size());
        for (Object object : from) {
            copy.add(JzRepoWorkItem.copy(object));
        }
        return copy;
    }

    protected void doGetAllCustomPropertyNames(List<PropertyNameList.PropertyName<String>> customPNL, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        IWorkItem workItem = this.getWorkItem(feedback.nest(10));
        IProjectAreaHandle projectArea = workItem.getProjectArea();
        String namespaceName = ((Object)((Object)this)).getClass().getName();
        IWorkItemCommon workItemCommon = (IWorkItemCommon)provider.getRepo().getClientLibrary(IWorkItemCommon.class);
        ArrayList includedProperties = new ArrayList(IWorkItem.FULL_PROFILE.getProperties());
        includedProperties.remove(IWorkItem.ID_PROPERTY);
        includedProperties.remove(IWorkItem.SUMMARY_PROPERTY);
        includedProperties.remove(IWorkItem.DESCRIPTION_PROPERTY);
        int size = includedProperties.size();
        int count = 0;
        for (String attributeId : includedProperties) {
            try {
                Object value;
                int done = JzProvider.FB_BASE(0, 100, ++count, size);
                IAttribute attribute = workItemCommon.findAttribute(projectArea, attributeId, JzProvider.getMonitor(feedback, done));
                if (attribute == null || !workItem.hasAttribute(attribute) || !workItem.isAttributeSet(attribute) || (value = workItem.getValue(attribute)) == null) continue;
                PropertyNameList.PropertyName pn = new PropertyNameList.PropertyName(namespaceName, attributeId);
                customPNL.add((PropertyNameList.PropertyName<String>)pn);
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        }
        customPNL.add((PropertyNameList.PropertyName<String>)InteropUtilities.PN_TASK_ID);
    }

    private static String getAppropriateActionId(Identifier<IState> currentState, IWorkflowInfo flow, String desiredStateName, SrvcFeedback nowork) {
        Identifier[] allActionIds;
        String result = null;
        Identifier[] identifierArray = allActionIds = flow.getAllActionIds();
        int n = allActionIds.length;
        int n2 = 0;
        while (n2 < n) {
            String nextStateName;
            Identifier identifier = identifierArray[n2];
            Identifier nextState = flow.getActionResultState(identifier);
            if (nextState != null && desiredStateName.equals(nextStateName = flow.getStateName(nextState))) {
                result = identifier.getStringIdentifier();
                break;
            }
            ++n2;
        }
        if (result == null) {
            throw new IllegalStateException(nowork.format("Could not find a transition action from state {0} to state named: {1}", new Object[]{currentState.getStringIdentifier(), desiredStateName}));
        }
        return result;
    }

    private static int getWorkItemGroupId(String statusName) {
        Integer mappedStatus = status2WorkFlowGroupId.get(statusName);
        if (mappedStatus == null) {
            throw new IllegalArgumentException("unsupported status name: " + statusName);
        }
        return mappedStatus;
    }

    public static List<SrvcResource> doFind(JzProvider p, Task taskQuery, boolean all, SrvcFeedback f) throws WvcmException {
        IProjectArea projectAreaHandle = p.getProjectArea(f.nest(10));
        Object desiredStatusObject = taskQuery.lookupProperty(UcmImporter.PN_CM_STATUS);
        Object desiredDurationObject = taskQuery.lookupProperty(UcmImporter.PN_DURATION);
        Object desiredTracksObject = taskQuery.lookupProperty(UcmImporter.PN_TRACKS_UCM_METADATUM);
        Object desiredTags = taskQuery.lookupProperty(UcmImporter.PN_TAGS);
        ArrayList<IWorkItemHandle> matchingHandles = new ArrayList<IWorkItemHandle>();
        if (desiredTracksObject instanceof String) {
            IItemHandle foundItem = JzRepoResource.lookupByValue(p, UcmImporter.PN_TRACKS_UCM_METADATUM, (String)desiredTracksObject, f);
            if (foundItem != null && IWorkItem.ITEM_TYPE.equals(foundItem.getItemType())) {
                matchingHandles.add((IWorkItemHandle)foundItem);
            }
        } else {
            try {
                int monitorCounter;
                ArrayList<Object> conditions = new ArrayList<Object>();
                IAuditableClient aClient = (IAuditableClient)p.getRepo().getClientLibrary(IAuditableClient.class);
                AttributeOperation eqOperator = AttributeOperation.EQUALS;
                AttributeOperation contOperator = AttributeOperation.CONTAINS;
                if (desiredStatusObject instanceof String) {
                    String desiredStatus = (String)desiredStatusObject;
                    int mappedStatus = JzRepoWorkItem.getWorkItemGroupId(desiredStatus);
                    IQueryableAttribute stateAttribute = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE).findAttribute((IProjectAreaHandle)projectAreaHandle, IWorkItem.STATE_PROPERTY, (IAuditableCommon)aClient, JzProvider.getMonitor(f, 10));
                    conditions.add(new VariableAttributeExpression(stateAttribute, eqOperator, (IAttributeVariable)new StatusVariable(mappedStatus)));
                }
                if (desiredDurationObject instanceof String) {
                    IQueryableAttribute durationAttribute = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE).findAttribute((IProjectAreaHandle)projectAreaHandle, IWorkItem.DURATION_PROPERTY, (IAuditableCommon)aClient, JzProvider.getMonitor(f, 20));
                    conditions.add(new AttributeExpression(durationAttribute, eqOperator, (Object)Long.valueOf((String)desiredDurationObject)));
                }
                if (desiredTags instanceof List) {
                    List tags = (List)desiredTags;
                    int tagsCount = tags.size();
                    monitorCounter = 1;
                    for (Object tag : tags) {
                        IQueryableAttribute tagAttribute = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE).findAttribute((IProjectAreaHandle)projectAreaHandle, IWorkItem.TAGS_PROPERTY, (IAuditableCommon)aClient, JzProvider.getMonitor(f, 20 + monitorCounter++ * 10 / tagsCount));
                        conditions.add(new AttributeExpression(tagAttribute, contOperator, tag));
                    }
                }
                Term queryExpression = new Term(0, conditions.toArray(new Expression[0]));
                IQueryClient qClient = (IQueryClient)p.getRepo().getClientLibrary(IQueryClient.class);
                IQueryResult results = qClient.getExpressionResults((IProjectAreaHandle)projectAreaHandle, (Expression)queryExpression);
                monitorCounter = 1;
                int resultSize = results.getResultSize(JzProvider.getMonitor(f, 40)).getTotal();
                while (results.hasNext(null)) {
                    IResult r = (IResult)results.next(JzProvider.getMonitor(f, 40 + monitorCounter++ * 60 / resultSize));
                    IWorkItemHandle workItemHandle = (IWorkItemHandle)r.getItem();
                    matchingHandles.add(workItemHandle);
                }
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        }
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(matchingHandles.size());
        for (IWorkItemHandle iWorkItemHandle : matchingHandles) {
            JzRepoWorkItem result = JzRepoWorkItem.create(p, iWorkItemHandle);
            results.add(result);
        }
        return results;
    }

    @Override
    public Object getCustomProperty(String name, SrvcFeedback feedback) throws WvcmException {
        IItemHandle h = this.getItemHandle(feedback.nest(10));
        IWorkItem workItem = this.getWorkItem(feedback.nest(30));
        return JzRepoWorkItem.getCustomProperty(this.provider(), (IItemHandle)workItem.getProjectArea(), String.valueOf(name) + h.getItemId().getUuidValue(), feedback.nest(100));
    }

    @Override
    void storeCustomProperty(PropertyNameList.PropertyName<?> propertyName, String value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (JzRepoResource.LinkTypeInfo.lookup(propertyName) != null) {
            super.storeCustomProperty(propertyName, value, initialize, feedback);
        } else {
            JzProvider provider = this.provider();
            IItemHandle h = this.getItemHandle(feedback.nest(5));
            IWorkItem workItem = this.getWorkItem(feedback.nest(20));
            String name = propertyName.getName();
            JzRepoWorkItem.storeCustomProperty(provider, (IItemHandle)workItem.getProjectArea(), String.valueOf(name) + h.getItemId().getUuidValue(), value, initialize, feedback.nest(100));
        }
    }

    private static class JzRepoWorkItemOperation
    extends WorkItemOperation {
        private final JzProvider provider;
        IProcessArea processArea;
        private final IWorkItem templateItem;
        private final XMLString summary;
        private final XMLString truncatedXmlEncodedComment;
        private final Long duration;
        private final List<String> tags;
        private final List<IItemReference> blockingTaskItemReferences;
        private final UcmImporter.TaskState nextTaskState;
        private final ITeamRepository repo;
        private final SrvcFeedback nowork;

        public JzRepoWorkItemOperation(JzProvider provider, IProcessArea processArea, IWorkItem templateItem, XMLString summary, Long duration, List<String> tags, List<IItemReference> blockingTaskItemReferences, XMLString truncatedXmlEncodedComment, SrvcFeedback nowork) {
            super("JzRepoWorkItemInternalOperation");
            this.provider = provider;
            this.processArea = processArea;
            this.templateItem = templateItem;
            this.summary = summary;
            this.truncatedXmlEncodedComment = truncatedXmlEncodedComment;
            this.duration = duration;
            this.tags = tags == null ? null : new ArrayList<String>(tags);
            this.blockingTaskItemReferences = blockingTaskItemReferences == null ? null : new ArrayList<IItemReference>(blockingTaskItemReferences);
            this.nextTaskState = null;
            this.repo = provider.getRepo();
            this.nowork = nowork;
        }

        public JzRepoWorkItemOperation(XMLString summary, Long duration, List<String> tags, List<IItemReference> blockingTaskItemReferences, XMLString truncatedXmlEncodedComment, UcmImporter.TaskState nextTaskState, ITeamRepository repo, SrvcFeedback nowork) {
            super("JzRepoWorkItemInternalOperation", IWorkItem.FULL_PROFILE);
            this.provider = null;
            this.templateItem = null;
            this.summary = summary;
            this.truncatedXmlEncodedComment = truncatedXmlEncodedComment;
            this.duration = duration;
            this.tags = tags == null ? null : new ArrayList<String>(tags);
            this.blockingTaskItemReferences = blockingTaskItemReferences == null ? null : new ArrayList<IItemReference>(blockingTaskItemReferences);
            this.nextTaskState = nextTaskState;
            this.repo = repo;
            this.nowork = nowork;
        }

        protected void execute(WorkItemWorkingCopy wc, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor);
            IWorkItem workItem = wc.getWorkItem();
            if (this.provider != null) {
                this.setCreationFields(workItem, subMon.newChild(80));
            }
            if (this.summary != null) {
                workItem.setHTMLSummary(this.summary);
            }
            if (this.truncatedXmlEncodedComment != null) {
                workItem.setHTMLDescription(this.truncatedXmlEncodedComment);
            }
            if (this.duration != null) {
                workItem.setDuration(this.duration.longValue());
            }
            if (this.tags != null) {
                workItem.setTags2(this.tags);
            }
            if (this.blockingTaskItemReferences != null && !this.blockingTaskItemReferences.isEmpty()) {
                JzRepoWorkItem.addReferences(this.blockingTaskItemReferences, wc.getReferences());
            }
            if (this.nextTaskState != null) {
                String actionString;
                IWorkItemClient workItemClient = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
                IWorkflowInfo flow = workItemClient.findWorkflowInfo(workItem, (IProgressMonitor)subMon.newChild(90));
                Identifier state = workItem.getState2();
                switch (this.nextTaskState) {
                    case INITIAL: {
                        actionString = flow.getReopenActionId().getStringIdentifier();
                        break;
                    }
                    case IN_PROGRESS: {
                        actionString = JzRepoWorkItem.getAppropriateActionId((Identifier<IState>)state, flow, this.nextTaskState.displayName(), this.nowork);
                        break;
                    }
                    case DONE: {
                        actionString = flow.getResolveActionId().getStringIdentifier();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unrecognized next state: " + this.nextTaskState);
                    }
                }
                wc.setWorkflowAction(actionString);
            }
        }

        private void setCreationFields(IWorkItem workItem, SubMonitor monitor) throws TeamRepositoryException {
            IWorkItemClient clientLib = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
            if (this.templateItem != null) {
                JzRepoWorkItem.copyPartialWorkItem(workItem, this.templateItem, (IWorkItemCommon)this.repo.getClientLibrary(IWorkItemCommon.class), (IProgressMonitor)monitor.newChild(10));
            } else {
                ICategoryHandle categoryHandle;
                IDevelopmentLine developmentLine = null;
                IAuditableCommon auditableCommon = clientLib.getAuditableCommon();
                if (this.processArea instanceof ITeamArea) {
                    ITeamArea teamArea = (ITeamArea)this.processArea;
                    developmentLine = auditableCommon.getDevelopmentLine((ITeamAreaHandle)teamArea, (IProgressMonitor)monitor.newChild(20));
                } else if (this.processArea instanceof IProcessArea) {
                    IProjectArea projectArea = (IProjectArea)this.processArea;
                    developmentLine = (IDevelopmentLine)auditableCommon.resolveAuditable((IAuditableHandle)projectArea.getProjectDevelopmentLine(), ItemProfile.DEVELOPMENT_LINE_DEFAULT, (IProgressMonitor)monitor.newChild(30));
                }
                if (developmentLine != null) {
                    workItem.setTarget(developmentLine.getCurrentIteration());
                }
                if ((categoryHandle = JzRepoWorkItem.lookupCategory(this.provider, this.processArea, clientLib, workItem, (IProgressMonitor)monitor.newChild(40))) != null) {
                    workItem.setCategory(categoryHandle);
                }
            }
            workItem.setCreator((IContributorHandle)this.repo.loggedInContributor());
            workItem.setOwner((IContributorHandle)this.repo.loggedInContributor());
        }
    }
}

