/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.http;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.wink.common.internal.utils.MediaTypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Accept {
    private static final RuntimeDelegate.HeaderDelegate<Accept> delegate = RuntimeDelegate.getInstance().createHeaderDelegate(Accept.class);
    private List<MediaType> mediaTypes;
    private List<ValuedMediaType> valuedMediaTypes;
    private List<ValuedMediaType> sortedValuedMediaTypes;
    private List<MediaType> sortedMediaTypes;

    public Accept(List<MediaType> mediaTypes) {
        this.mediaTypes = mediaTypes;
        if (mediaTypes.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.valuedMediaTypes = new LinkedList<ValuedMediaType>();
        for (MediaType mt : mediaTypes) {
            this.valuedMediaTypes.add(new ValuedMediaType(mt));
        }
        this.sortedValuedMediaTypes = this.sort(new LinkedList<ValuedMediaType>(this.valuedMediaTypes));
        this.sortedMediaTypes = new LinkedList<MediaType>();
        for (ValuedMediaType vmt : this.sortedValuedMediaTypes) {
            this.sortedMediaTypes.add(vmt.getMediaType());
        }
    }

    private List<ValuedMediaType> sort(List<ValuedMediaType> types) {
        Collections.sort(types, Collections.reverseOrder());
        return types;
    }

    public List<ValuedMediaType> getValuedMediaTypes() {
        return Collections.unmodifiableList(this.valuedMediaTypes);
    }

    public List<ValuedMediaType> getSortedValuedMediaTypes() {
        return Collections.unmodifiableList(this.sortedValuedMediaTypes);
    }

    public List<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    public List<MediaType> getSortedMediaTypes() {
        return Collections.unmodifiableList(this.sortedMediaTypes);
    }

    public boolean isAcceptable(MediaType mt) {
        boolean accpetable = false;
        for (ValuedMediaType vmt : this.valuedMediaTypes) {
            if (!vmt.isCompatible(mt)) continue;
            if (vmt.getQ() == 0.0) {
                return false;
            }
            accpetable = true;
        }
        return accpetable;
    }

    public static Accept valueOf(String value) throws IllegalArgumentException {
        return delegate.fromString(value);
    }

    public String toString() {
        return delegate.toString(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValuedMediaType
    implements Comparable<ValuedMediaType> {
        private double q;
        private MediaType mediaType;

        public ValuedMediaType(MediaType mediaType) {
            double q = 1.0;
            String qStr = mediaType.getParameters().get("q");
            if (qStr != null) {
                q = Double.parseDouble(qStr);
            }
            this.init(mediaType, q);
        }

        public ValuedMediaType(MediaType mediaType, double q) {
            this.init(mediaType, q);
        }

        private void init(MediaType mediaType, double q) {
            if (mediaType == null) {
                throw new NullPointerException("mediaType");
            }
            if (q < 0.0 || q > 1.0) {
                throw new IllegalArgumentException(String.valueOf(q));
            }
            this.mediaType = mediaType;
            this.q = (double)((int)(q * 1000.0)) / 1000.0;
            if (this.q != q) {
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                parameters.putAll(mediaType.getParameters());
                parameters.put("q", Double.toString(this.q));
                this.mediaType = new MediaType(mediaType.getType(), mediaType.getSubtype(), parameters);
            }
        }

        public double getQ() {
            return this.q;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public boolean isCompatible(MediaType other) {
            return this.mediaType.isCompatible(other);
        }

        public String toString() {
            return this.mediaType.toString();
        }

        @Override
        public int compareTo(ValuedMediaType o) {
            int ret = Double.compare(this.q, o.q);
            if (ret != 0) {
                return ret;
            }
            return MediaTypeUtils.compareTo(this.mediaType, o.mediaType);
        }
    }
}

