/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.Commit;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.LatestVersionEntry;
import com.urbancode.air.vc.PersistenceData;
import com.urbancode.air.vc.Persistent;
import com.urbancode.air.vc.PersistentRecord;
import com.urbancode.air.vc.Repository;
import com.urbancode.air.vc.VCHelper;
import com.urbancode.air.vc.interceptors.InterceptorRegistry;
import com.urbancode.air.vc.interceptors.ReadInterceptor;
import com.urbancode.air.vc.metadata.RecordMetadataCondition;
import com.urbancode.air.vc.xml.DocumentBuilderHelper;
import com.urbancode.air.vc.xml.XMLVCHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentReader {
    private static final Logger log = Logger.getLogger(PersistentReader.class);
    private Repository repository;
    private Cache readCache;

    public PersistentReader(Repository repository) {
        this.repository = repository;
        this.readCache = CacheManager.getInstance().getCache("vcCache");
    }

    Commit readCommit(long id) {
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(Commit.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)id));
        return (Commit)criteria.uniqueResult();
    }

    List<Commit> readCommitsForPersistent(String path) {
        return this.readCommitsForPath(path);
    }

    List<Commit> readCommitsForPath(String path) {
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(Commit.class);
        criteria.createCriteria("pathEntries").add(Restrictions.ilike((String)"path", (Object)(path + "%")));
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)"id")));
        List ids = criteria.list();
        ArrayList<Commit> result = new ArrayList<Commit>();
        for (Long id : ids) {
            result.add((Commit)this.repository.getTxManager().getSession().get(Commit.class, (Serializable)id));
        }
        Collections.sort(result);
        return result;
    }

    <T extends Persistent> Integer getVersionCountForPersistent(T persistent) {
        PersistenceData persistenceData = persistent.getPersistenceData();
        String path = persistenceData.getPath();
        return this.getVersionCountForPath(path);
    }

    Integer getVersionCountForPath(String path) {
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(PersistentRecord.class);
        criteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        criteria.setProjection(Projections.rowCount());
        Long longResult = (Long)criteria.uniqueResult();
        Integer result = longResult.intValue();
        if (result == null) {
            result = 0;
        }
        return result;
    }

    <T extends Persistent> Integer getVersionForCommit(T persistent, Long commit) {
        PersistenceData persistenceData = persistent.getPersistenceData();
        String path = persistenceData.getPath();
        return this.getVersionForCommit(commit, path);
    }

    Integer getVersionForCommit(Long commit, String path) {
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(PersistentRecord.class);
        criteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        criteria.add((Criterion)Restrictions.le((String)"commit", (Object)commit));
        criteria.setProjection(Projections.rowCount());
        Long longResult = (Long)criteria.uniqueResult();
        Integer result = longResult.intValue();
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public Map<String, Integer> getLatestVersionsForPathLike(String partialPath) {
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(LatestVersionEntry.class);
        criteria = criteria.createAlias("record", "r");
        criteria.add((Criterion)Restrictions.like((String)"r.path", (Object)(partialPath + "%")));
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Property.forName((String)"r.path")).add((Projection)Property.forName((String)"r.relativeVersion")));
        List data = criteria.list();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Object[] lockable : data) {
            Integer version = (Integer)lockable[1];
            String path = (String)lockable[0];
            result.put(path, version);
        }
        return result;
    }

    List<Persistent> getLatestPersistentsWithAllMetadata(RecordMetadataCondition ... conditions) {
        Session session = this.repository.getTxManager().getSession();
        HashSet records = new HashSet();
        boolean first = true;
        for (RecordMetadataCondition condition : conditions) {
            Criteria criteria = session.createCriteria(LatestVersionEntry.class, "latestEntry");
            Criteria metadataCriteria = criteria.createCriteria("record.metadataList");
            metadataCriteria.add((Criterion)Restrictions.eq((String)"key", (Object)condition.getKey()));
            metadataCriteria.add((Criterion)Restrictions.eq((String)"metadataGeneratorName", (Object)condition.getGeneratorName()));
            if (condition.getComparison() == RecordMetadataCondition.MetadataComparison.EQ) {
                metadataCriteria.add((Criterion)Restrictions.eq((String)"value", (Object)condition.getValue()));
            } else if (condition.getComparison() == RecordMetadataCondition.MetadataComparison.LIKE) {
                metadataCriteria.add((Criterion)Restrictions.like((String)"value", (Object)condition.getValue()));
            } else if (condition.getComparison() == RecordMetadataCondition.MetadataComparison.ILIKE) {
                metadataCriteria.add(Restrictions.ilike((String)"value", (Object)condition.getValue()));
            }
            if (first) {
                records.addAll(criteria.list());
                first = false;
                continue;
            }
            records.retainAll(criteria.list());
        }
        ArrayList<Persistent> result = new ArrayList<Persistent>();
        for (LatestVersionEntry record : records) {
            result.add(this.restore(record.getPersistentRecord()));
        }
        return result;
    }

    <T extends Persistent> T readPersistent(Class<T> clazz, String path) {
        Integer version = this.getVersionCountForPath(path);
        return (T)this.readPersistentForHandle(new Handle(path, version));
    }

    <T extends Persistent> T readPersistent(Class<T> clazz, String path, int version) {
        return (T)this.readPersistentForHandle(new Handle(path, version));
    }

    <T extends Persistent> T readPersistentForCommit(Class<T> clazz, String path, long commit) {
        return (T)this.readPersistentForHandle(new Handle(path, commit));
    }

    private <T extends Persistent> void runInterceptors(T result) {
        List<ReadInterceptor> readInterceptors = InterceptorRegistry.getInstance().getReadInterceptors();
        for (ReadInterceptor interceptor : readInterceptors) {
            interceptor.interceptRead(result);
        }
    }

    <T extends Persistent> List<T> readAllInPath(Class<T> clazz, String path, boolean includeDeleted) {
        ArrayList<Persistent> result = new ArrayList<Persistent>();
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(LatestVersionEntry.class);
        criteria.createCriteria("record", "pr");
        criteria.add((Criterion)Restrictions.eq((String)"pr.directory", (Object)path));
        if (!includeDeleted) {
            criteria.add((Criterion)Restrictions.eq((String)"pr.deleted", (Object)false));
        }
        String recordPath = null;
        for (Object rawResult : criteria.list()) {
            try {
                PersistentRecord record = ((LatestVersionEntry)rawResult).getPersistentRecord();
                recordPath = record.getPath();
                result.add(this.restore(record));
            }
            catch (SecurityException e) {
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException(String.format("Exception loading persistent record in path '%s'.", recordPath), e);
                throw re;
            }
        }
        return result;
    }

    <T extends Persistent> List<T> readAllLikePath(Class<T> clazz, String path, boolean includeDeleted) {
        ArrayList<Persistent> result = new ArrayList<Persistent>();
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(LatestVersionEntry.class);
        criteria.createCriteria("record", "pr");
        criteria.add((Criterion)Restrictions.like((String)"pr.path", (Object)path));
        if (!includeDeleted) {
            criteria.add((Criterion)Restrictions.eq((String)"pr.deleted", (Object)false));
        }
        String recordPath = null;
        List allObj = criteria.list();
        for (Object rawResult : allObj) {
            try {
                PersistentRecord record = ((LatestVersionEntry)rawResult).getPersistentRecord();
                recordPath = record.getPath();
                result.add(this.restore(record));
            }
            catch (SecurityException e) {
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException(String.format("Exception loading persistent record in path '%s'.", recordPath), e);
                throw re;
            }
        }
        return result;
    }

    <T extends Persistent> List<T> readAllInPathForCommit(Class<T> clazz, String path, Long commit) {
        ArrayList<Persistent> result = new ArrayList<Persistent>();
        Session session = this.repository.getTxManager().getSession();
        Query query = session.createQuery("select pr from PersistentRecord pr where pr.directory = :path and pr.commit = (select max(pr2.commit) from PersistentRecord pr2 where pr2.path = pr.path and pr2.commit <= :commit)and pr.deleted = :false");
        query.setParameter("path", (Object)path);
        query.setParameter("commit", (Object)commit);
        query.setParameter("false", (Object)false);
        for (Object rawResult : query.list()) {
            PersistentRecord record = (PersistentRecord)rawResult;
            result.add(this.restore(record));
        }
        return result;
    }

    <T extends Persistent> List<T> readAllLikePathSinceTime(Class<T> clazz, String partialPath, Long time) {
        ArrayList result = new ArrayList();
        Criteria commitCriteria = this.repository.getTxManager().getSession().createCriteria(Commit.class).add((Criterion)Restrictions.gt((String)"time", (Object)time)).setProjection((Projection)Projections.min((String)"id"));
        Object commitCriteriaResult = commitCriteria.uniqueResult();
        if (commitCriteriaResult == null) {
            return new ArrayList();
        }
        Long minCommitId = Long.parseLong(commitCriteriaResult.toString());
        return this.readAllLikePathSinceCommitInclusive(clazz, partialPath, minCommitId);
    }

    <T extends Persistent> List<T> readAllLikePathSinceCommitInclusive(Class<T> clazz, String partialPath, Long commit) {
        ArrayList<Persistent> result = new ArrayList<Persistent>();
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(LatestVersionEntry.class, "lve");
        criteria.setProjection((Projection)Projections.property((String)"lve.record"));
        criteria.createAlias("record", "r");
        criteria.add((Criterion)Restrictions.ge((String)"r.commit", (Object)commit));
        criteria.add((Criterion)Restrictions.like((String)"r.path", (Object)(partialPath + "%")));
        List queryResults = criteria.list();
        for (PersistentRecord record : queryResults) {
            result.add(this.restore(record));
        }
        return result;
    }

    Persistent readPersistentForHandle(Handle handle) {
        PersistentRecord record = this.attemptRestoreFromCache(handle);
        Persistent result = null;
        if (record == null) {
            String path = handle.getPath();
            int version = 0;
            Integer handleVersion = handle.getVersion();
            Long handleCommit = handle.getCommit();
            if (handleVersion != null) {
                if (handleVersion == -1) {
                    record = this.getPersistentRecordForLatest(path);
                } else {
                    version = handle.getVersion();
                    record = this.getPersistentRecord(path, version);
                }
            } else if (handleCommit != null) {
                record = this.getPersistentRecordForCommit(path, handleCommit);
                if (version == 0) {
                    log.debug((Object)("Getting persistent " + path + " for commit " + handleCommit + " matched no version."));
                }
            } else {
                throw new IllegalArgumentException("Invalid handle: " + handle);
            }
        }
        if (record != null) {
            result = this.restore(record);
        }
        return result;
    }

    public List<Persistent> readLatestWithPaths(List<String> paths, boolean skipVersionCount) {
        List<PersistentRecord> recordList = this.getLatestPersistentRecordsWithPaths(paths);
        ArrayList<Persistent> results = new ArrayList<Persistent>(recordList.size());
        for (int i = 0; i < recordList.size(); ++i) {
            results.add(this.restore(recordList.get(i), skipVersionCount));
        }
        return results;
    }

    public Persistent restore(PersistentRecord record) {
        return this.restore(record, false);
    }

    public Persistent restore(PersistentRecord record, boolean skipVersionCount) {
        Persistent result;
        String path = record.getPath();
        Integer version = record.getRelativeVersion();
        Integer versionCount = null;
        try {
            DocumentBuilder builder = DocumentBuilderHelper.getDocumentBuilder();
            String recData = record.getData();
            recData = XMLVCHelper.replaceIllegalXmlChars(recData);
            ByteArrayInputStream stream = new ByteArrayInputStream(recData.getBytes("UTF-8"));
            Document document = builder.parse(stream);
            stream.close();
            String nodeName = null;
            NodeList list = document.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                nodeName = list.item(i).getNodeName();
                break;
            }
            VCHelper<?> helper = this.repository.getHelperRegistry().getHelper(nodeName);
            ByteArrayInputStream input = new ByteArrayInputStream(recData.getBytes("UTF-8"));
            result = (Persistent)helper.restore(input);
            ((InputStream)input).close();
            if (skipVersionCount) {
                versionCount = version;
            } else {
                versionCount = this.getVersionCountForPath(path);
                this.cache(record, versionCount);
            }
            PersistenceData persistenceData = result.getPersistenceData();
            persistenceData.setPath(path);
            persistenceData.setCommit(record.getCommit());
            persistenceData.setRelativeVersion(version);
            persistenceData.setVersionCount(versionCount);
            persistenceData.internalSetDeleted(record.isDeleted());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error reading from stored XML", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from stored XML", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Error reading from stored XML", e);
        }
        if (result != null) {
            this.runInterceptors(result);
        }
        return result;
    }

    private PersistentRecord getPersistentRecord(String path, Integer version) {
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(PersistentRecord.class);
        criteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        criteria.add((Criterion)Restrictions.eq((String)"relativeVersion", (Object)version));
        return (PersistentRecord)criteria.uniqueResult();
    }

    private PersistentRecord getPersistentRecordForCommit(String path, Long commit) {
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(PersistentRecord.class);
        criteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        criteria.add((Criterion)Restrictions.le((String)"commit", (Object)commit));
        criteria.addOrder(Order.desc((String)"commit"));
        criteria.setMaxResults(1);
        return (PersistentRecord)criteria.uniqueResult();
    }

    private PersistentRecord getPersistentRecordForLatest(String path) {
        PersistentRecord result = null;
        Criteria versionCriteria = this.repository.getTxManager().getSession().createCriteria(LatestVersionEntry.class);
        versionCriteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        LatestVersionEntry versionEntry = (LatestVersionEntry)versionCriteria.uniqueResult();
        if (versionEntry != null) {
            result = versionEntry.getPersistentRecord();
        }
        return result;
    }

    private List<PersistentRecord> getLatestPersistentRecordsWithPaths(List<String> paths) {
        ArrayList<PersistentRecord> result = new ArrayList<PersistentRecord>();
        ArrayList<String> locPaths = new ArrayList<String>(paths);
        while (locPaths.size() > 0) {
            ArrayList pathSubList = new ArrayList(locPaths.subList(0, Math.min(locPaths.size(), 500)));
            locPaths.removeAll(pathSubList);
            Criteria versionCriteria = this.repository.getTxManager().getSession().createCriteria(LatestVersionEntry.class);
            versionCriteria.add(Restrictions.in((String)"path", pathSubList));
            List entries = versionCriteria.list();
            for (LatestVersionEntry entry : entries) {
                result.add(entry.getPersistentRecord());
            }
        }
        return result;
    }

    private PersistentRecord attemptRestoreFromCache(Handle handle) {
        Element element;
        Integer cachedLatestVersion;
        PersistentRecord result = null;
        if (handle.getVersion() != null && handle.getVersion() == -1 && (cachedLatestVersion = this.repository.getSession().getCachedLatestVersion(handle.getPath())) != null) {
            handle = new Handle(handle.getPath(), cachedLatestVersion);
        }
        if (this.readCache != null && (element = this.readCache.get((Serializable)((Object)handle.toString()))) != null) {
            result = (PersistentRecord)element.getValue();
        }
        return result;
    }

    protected void cache(PersistentRecord p, int versionCount) {
        if (this.readCache != null) {
            String path = p.getPath();
            int relativeVersion = p.getRelativeVersion();
            long commit = p.getCommit();
            Handle handle = new Handle(path, relativeVersion);
            this.readCache.put(new Element((Serializable)((Object)handle.toString()), (Serializable)p));
            Handle commitHandle = new Handle(path, commit);
            this.readCache.put(new Element((Serializable)((Object)commitHandle.toString()), (Serializable)p));
            if (versionCount == relativeVersion) {
                this.repository.getSession().cacheLatestVersion(path, relativeVersion);
            }
        }
    }
}

