/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.Commit;
import com.urbancode.air.vc.PersistenceData;
import com.urbancode.air.vc.Persistent;
import com.urbancode.air.vc.PersistentWriter;
import com.urbancode.air.vc.Repository;
import com.urbancode.air.vc.Session;
import java.util.Set;
import org.apache.log4j.Logger;

public class Transaction {
    private static final Logger log = Logger.getLogger(Transaction.class);
    private final Session session;
    private final long startCommit;
    private String comment;

    Transaction(Session session) {
        this.session = session;
        this.comment = "";
        if (!session.getRepository().getTxManager().isActive()) {
            throw new RuntimeException("Cannot create a versioned configuration transaction when there is no hibernate transaction active.");
        }
        Repository repository = session.getRepository();
        this.startCommit = repository.getCurrentCommit();
    }

    public Commit commit(String username) {
        Repository repository = this.session.getRepository();
        PersistentWriter writer = new PersistentWriter(repository);
        Commit commit = null;
        Set<Persistent> dirtyPersistents = this.session.getDirtyPersistents();
        Set<Persistent> deletedPersistents = this.session.getDirtyAndDeletedPersistents();
        try {
            if (!dirtyPersistents.isEmpty() || !deletedPersistents.isEmpty()) {
                for (Persistent persistent : dirtyPersistents) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Running interceptors for " + persistent));
                    }
                    writer.runWriteInterceptors(persistent);
                }
                long timeToAcquire = repository.acquireLock("CommitLock");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Time to acquireLock: " + timeToAcquire));
                }
                long nextCommit = repository.getCurrentCommit() + 1L;
                commit = new Commit(nextCommit, username, this.getCurrentComment());
                writer.write(commit, dirtyPersistents, this.startCommit);
                for (Persistent persistent : dirtyPersistents) {
                    PersistenceData persistenceData = persistent.getPersistenceData();
                    persistenceData.setDirty(false);
                    commit.addPathModified(persistenceData.getPath());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Wrote persistent " + persistent + " to " + persistenceData.getPath()));
                }
                writer.delete(commit, deletedPersistents, this.startCommit);
                for (Persistent persistent : deletedPersistents) {
                    commit.addPathDeleted(persistent.getPersistenceData().getPath());
                }
                repository.getTxManager().getSession().save((Object)commit);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to commit transaction: " + e.getMessage(), e);
        }
        finally {
            this.setCurrentComment("");
            this.session.unbindTransaction();
        }
        return commit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Commit commitAndEnd(String username) {
        Commit result;
        try {
            result = this.commit(username);
        }
        finally {
            this.session.close();
        }
        return result;
    }

    public boolean isActive() {
        return this.session.getRepository().getTxManager().isActive();
    }

    public String getCurrentComment() {
        return this.comment;
    }

    public void setCurrentComment(String comment) {
        if (comment != null) {
            this.comment = comment;
        }
    }
}

