/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public abstract class StreamSearchUtil {
    public static boolean streamContains(Reader raw, long streamLength, String requiredText, IProgressMonitor progress) throws IOException {
        SubMonitor mon = null;
        long remaining = streamLength;
        try {
            int ch;
            mon = SubMonitor.convert((IProgressMonitor)progress);
            mon.setWorkRemaining((int)remaining);
            if (requiredText.length() == 0) {
                return true;
            }
            BufferedReader reader = new BufferedReader(raw);
            int matchLen = 0;
            while (-1 != (ch = reader.read())) {
                mon.worked(1);
                --remaining;
                if (requiredText.charAt(matchLen) == ch) {
                    if (matchLen == 0) {
                        reader.mark(requiredText.length());
                    }
                    if (++matchLen == requiredText.length()) {
                        return true;
                    }
                } else if (matchLen != 0) {
                    mon.setWorkRemaining((int)(remaining += (long)matchLen));
                    reader.reset();
                    matchLen = 0;
                }
                if (!mon.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            return false;
        }
        finally {
            raw.close();
            if (mon != null) {
                mon.done();
            }
        }
    }
}

