/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.helper;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.model.ItemType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PropertyHelper {
    static {
        new PropertyHelper();
    }

    private PropertyHelper() {
    }

    public static EStructuralFeature[] getDefaultPropertyFeatures(IItemType itemType) {
        EClassifier eClassifier;
        EPackage ePackage;
        EStructuralFeature[] features = null;
        if (itemType != null && (ePackage = EPackage.Registry.INSTANCE.getEPackage(itemType.getNamespaceURI())) != null && (eClassifier = ePackage.getEClassifier(itemType.getName())) instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            EList list = eClass.getEAllStructuralFeatures();
            HashSet<EStructuralFeature> featureSet = new HashSet<EStructuralFeature>();
            for (EStructuralFeature eStructuralFeature : list) {
                if (!PropertyHelper.isInClassOfInterest(eStructuralFeature, eClass)) continue;
                featureSet.add(eStructuralFeature);
            }
            features = featureSet.toArray(new EStructuralFeature[featureSet.size()]);
        }
        return features;
    }

    public static String[] getSetProperties(IItem item) {
        String[] properties = null;
        if (item != null) {
            LinkedList<String> setProperties = new LinkedList<String>();
            List propertyNames = ((ItemType)item.getItemType()).propertyNames();
            for (String propertyName : propertyNames) {
                if (!item.isPropertySet(propertyName)) continue;
                setProperties.add(propertyName);
            }
            properties = setProperties.toArray(new String[setProperties.size()]);
        }
        return properties;
    }

    public static String[] union(String[] baseProperties, String[] additionalProperties) {
        Object[] unionProperties = null;
        if (baseProperties != null && additionalProperties != null) {
            HashSet unionSet = new HashSet();
            PropertyHelper.addToSet(baseProperties, unionSet);
            PropertyHelper.addToSet(additionalProperties, unionSet);
            unionProperties = unionSet.toArray(new String[unionSet.size()]);
            Arrays.sort(unionProperties);
        }
        return unionProperties;
    }

    public static String[] remove(String[] baseProperties, String[] propertiesToRemove) {
        Object[] remainingProperties = null;
        if (baseProperties != null && propertiesToRemove != null) {
            HashSet propertySet = new HashSet();
            PropertyHelper.addToSet(baseProperties, propertySet);
            PropertyHelper.removeFromSet(propertiesToRemove, propertySet);
            remainingProperties = propertySet.toArray(new String[propertySet.size()]);
            Arrays.sort(remainingProperties);
        }
        return remainingProperties;
    }

    public static boolean arePropertiesSet(String[] properties, IItem item) {
        ValidationHelper.validateNotNull("properties", properties);
        ValidationHelper.validateNotNullElements("properties", properties);
        ValidationHelper.validateNotNull("item", item);
        int i = 0;
        while (i < properties.length) {
            if (!item.isPropertySet(properties[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void addToSet(String[] properties, Set propertySet) {
        int i = 0;
        while (i < properties.length) {
            if (properties[i] != null) {
                propertySet.add(properties[i]);
            }
            ++i;
        }
    }

    private static void removeFromSet(String[] properties, Set propertySet) {
        int i = 0;
        while (i < properties.length) {
            if (properties[i] != null) {
                propertySet.remove(properties[i]);
            }
            ++i;
        }
    }

    private static boolean isInClassOfInterest(EStructuralFeature eStructuralFeature, EClass eClass) {
        return eStructuralFeature.eContainer().equals(eClass);
    }
}

