/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.Commit;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.PersistenceData;
import com.urbancode.air.vc.Persistent;
import com.urbancode.air.vc.PersistentReader;
import com.urbancode.air.vc.Repository;
import com.urbancode.air.vc.Transaction;
import com.urbancode.air.vc.VCCacheKey;
import com.urbancode.air.vc.metadata.RecordMetadataCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    private static final Logger log = Logger.getLogger(Session.class);
    private Repository repository;
    private TreeMap<VCCacheKey, Persistent> trackedPersistents = new TreeMap();
    private Transaction transaction = null;
    private Map<String, Integer> latestVersionCache = new HashMap<String, Integer>();

    Session(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Transaction beginTransaction() {
        if (this.transaction == null) {
            this.transaction = new Transaction(this);
        } else {
            log.debug((Object)"Started a transaction when one was already active. Extending the current session.");
        }
        return this.transaction;
    }

    public Transaction getCurrentTransaction() {
        return this.transaction;
    }

    void unbindTransaction() {
        this.transaction = null;
    }

    public void saveOrUpdate(Persistent p) {
        PersistenceData persistenceData = p.getPersistenceData();
        String path = persistenceData.getPath();
        if (path == null) {
            throw new IllegalArgumentException("Cannot persist a Persistent which has no path.");
        }
        if (persistenceData.getRelativeVersion() == 0) {
            persistenceData.setRelativeVersion(1);
            persistenceData.setVersionCount(1);
        }
        this.trackPersistent(p);
    }

    @Deprecated
    public <T extends Persistent> T restore(Class<T> clazz, String path) {
        PersistentReader reader = new PersistentReader(this.repository);
        Object result = reader.readPersistent(clazz, path = new Handle(path, -1).getPath());
        result = result != null ? this.filterFromCacheOrTrack((Persistent)result) : this.getUnsavedPersistentFromCache(path);
        return result;
    }

    @Deprecated
    public <T extends Persistent> T restore(Class<T> clazz, String path, int version) {
        path = new Handle(path, -1).getPath();
        PersistentReader reader = new PersistentReader(this.repository);
        Object result = version <= 0 ? reader.readPersistent(clazz, path) : reader.readPersistent(clazz, path, version);
        if (result != null) {
            result = this.filterFromCacheOrTrack((Persistent)result);
        } else if (version <= 0) {
            result = this.getUnsavedPersistentFromCache(path);
        }
        return result;
    }

    public List<Persistent> restoreLatestWithPaths(List<String> paths, boolean skipVersionCount) {
        PersistentReader reader = new PersistentReader(this.repository);
        List<Persistent> result = reader.readLatestWithPaths(paths, skipVersionCount);
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, this.filterFromCacheOrTrack(result.get(i)));
        }
        return result;
    }

    public Persistent restore(Handle handle) {
        PersistenceData persistenceData;
        Persistent cachedResult;
        PersistentReader reader = new PersistentReader(this.repository);
        Persistent result = null;
        if (handle.getVersion() != null && handle.getVersion() == -1 && (cachedResult = this.getUnsavedPersistentFromCache(handle.getPath())) != null && (persistenceData = cachedResult.getPersistenceData()).getRelativeVersion() == persistenceData.getVersionCount()) {
            result = cachedResult;
        }
        if (result == null && (result = reader.readPersistentForHandle(handle)) != null) {
            result = this.filterFromCacheOrTrack(result);
        }
        return result;
    }

    public Map<String, Integer> getLatestVersionsForPathLike(String partialPath) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.getLatestVersionsForPathLike(partialPath);
    }

    public List<Persistent> getLatestPersistentsWithAllMetadata(RecordMetadataCondition ... conditions) {
        ArrayList<Persistent> result = new ArrayList<Persistent>();
        PersistentReader reader = new PersistentReader(this.repository);
        List<Persistent> restoredPersistents = reader.getLatestPersistentsWithAllMetadata(conditions);
        for (Persistent persistent : restoredPersistents) {
            result.add(this.filterFromCacheOrTrack(persistent));
        }
        return result;
    }

    @Deprecated
    public <T extends Persistent> T restoreForCommit(Class<T> clazz, String path, long commit) {
        PersistentReader reader = new PersistentReader(this.repository);
        Object result = reader.readPersistentForCommit(clazz, path = new Handle(path, -1).getPath(), commit);
        if (result != null) {
            result = this.filterFromCacheOrTrack((Persistent)result);
        }
        return result;
    }

    public <T extends Persistent> List<T> restoreAllInPath(Class<T> clazz, String path) {
        return this.restoreAllInPath(clazz, path, false);
    }

    public <T extends Persistent> List<T> restoreAllInPathIncludingDeleted(Class<T> clazz, String path) {
        return this.restoreAllInPath(clazz, path, true);
    }

    private <T extends Persistent> List<T> restoreAllInPath(Class<T> clazz, String path, boolean includeDeleted) {
        path = new Handle(path, -1).getPath();
        PersistentReader reader = new PersistentReader(this.repository);
        List<T> results = reader.readAllInPath(clazz, path, includeDeleted);
        ArrayList<Persistent> finalResult = new ArrayList<Persistent>();
        for (Persistent result : results) {
            result = this.filterFromCacheOrTrack(result);
            finalResult.add(result);
        }
        ArrayList<Persistent> persistentResults = new ArrayList<Persistent>(finalResult);
        Collection<Persistent> cacheResults = this.getUnsavedPersistentsInPathFromCache(path, persistentResults);
        for (Persistent cacheResult : cacheResults) {
            finalResult.add(cacheResult);
        }
        return finalResult;
    }

    public <T extends Persistent> List<T> restoreAllLikePath(Class<T> clazz, String path, boolean includeDeleted) {
        PersistentReader reader = new PersistentReader(this.repository);
        List<T> results = reader.readAllLikePath(clazz, path, includeDeleted);
        ArrayList<Persistent> finalResult = new ArrayList<Persistent>();
        for (Persistent result : results) {
            result = this.filterFromCacheOrTrack(result);
            finalResult.add(result);
        }
        ArrayList<Persistent> persistentResults = new ArrayList<Persistent>(finalResult);
        Collection<Persistent> cacheResults = this.getUnsavedPersistentsInPathFromCache(path, persistentResults);
        for (Persistent cacheResult : cacheResults) {
            finalResult.add(cacheResult);
        }
        return finalResult;
    }

    public <T extends Persistent> List<T> restoreAllInPartialPathModifiedSince(Class<T> clazz, String path, Long modifiedSince) {
        path = new Handle(path, -1).getPath();
        PersistentReader reader = new PersistentReader(this.repository);
        List<T> results = reader.readAllLikePathSinceTime(clazz, path, modifiedSince);
        ArrayList<Persistent> finalResult = new ArrayList<Persistent>();
        for (Persistent result : results) {
            result = this.filterFromCacheOrTrack(result);
            finalResult.add(result);
        }
        ArrayList<Persistent> persistentResults = new ArrayList<Persistent>(finalResult);
        Collection<Persistent> cacheResults = this.getUnsavedPersistentsInPathFromCache(path, persistentResults);
        for (Persistent cacheResult : cacheResults) {
            finalResult.add(cacheResult);
        }
        return finalResult;
    }

    public <T extends Persistent> List<T> restoreAllInPathForCommit(Class<T> clazz, String path, Long commit) {
        path = new Handle(path, -1).getPath();
        PersistentReader reader = new PersistentReader(this.repository);
        List<T> results = reader.readAllInPathForCommit(clazz, path, commit);
        ArrayList<Persistent> finalResult = new ArrayList<Persistent>();
        for (Persistent result : results) {
            result = this.filterFromCacheOrTrack(result);
            finalResult.add(result);
        }
        return finalResult;
    }

    private Persistent filterFromCacheOrTrack(Persistent target) {
        PersistenceData persistenceData = target.getPersistenceData();
        String path = persistenceData.getPath();
        Persistent cachedPersistent = null;
        VCCacheKey pcr = new VCCacheKey(target);
        if (this.trackedPersistents.containsKey(pcr)) {
            cachedPersistent = this.trackedPersistents.get(pcr);
            log.debug((Object)("Favoring version of " + path + " currently in session cache."));
        } else {
            this.trackPersistent(target);
            cachedPersistent = target;
        }
        return cachedPersistent;
    }

    private Persistent getUnsavedPersistentFromCache(String path) {
        VCCacheKey keyHi;
        VCCacheKey keyLo = new VCCacheKey(path = new Handle(path, -1).getPath(), 0);
        NavigableMap<VCCacheKey, Persistent> matches = this.trackedPersistents.subMap(keyLo, true, keyHi = new VCCacheKey(path, Integer.MAX_VALUE), true);
        if (matches.size() > 0) {
            return (Persistent)matches.get(matches.lastKey());
        }
        return null;
    }

    private Collection<Persistent> getUnsavedPersistentsInPathFromCache(String path, List<Persistent> currentResult) {
        path = new Handle(path, -1).getPath();
        HashSet<String> currentResultPaths = new HashSet<String>();
        for (Persistent p : currentResult) {
            currentResultPaths.add(p.getPersistenceData().getPath());
        }
        SortedMap<VCCacheKey, Persistent> possibleResults = this.getAllItemsInPathRecursivelyFromCache(path);
        HashMap<String, Persistent> latestMap = new HashMap<String, Persistent>();
        for (Map.Entry<VCCacheKey, Persistent> ent : possibleResults.entrySet()) {
            VCCacheKey key = ent.getKey();
            String keyPath = key.getPath();
            if (currentResultPaths.contains(keyPath) || !key.isDirectChildOf(path)) continue;
            if (latestMap.containsKey(keyPath)) {
                Integer latestVersionSeen = ((Persistent)latestMap.get(keyPath)).getPersistenceData().getRelativeVersion();
                if (latestVersionSeen >= key.getVersion()) continue;
                latestMap.put(keyPath, ent.getValue());
                continue;
            }
            latestMap.put(keyPath, ent.getValue());
        }
        return latestMap.values();
    }

    private SortedMap<VCCacheKey, Persistent> getAllItemsInPathRecursivelyFromCache(String path) {
        String loStringBound = path + "/";
        String hiStringBound = path + '0';
        Integer loIntBound = 0;
        Integer hiIntBound = 0;
        VCCacheKey loBound = new VCCacheKey(loStringBound, loIntBound);
        VCCacheKey hiBound = new VCCacheKey(hiStringBound, hiIntBound);
        SortedMap<VCCacheKey, Persistent> possResults = this.trackedPersistents.subMap(loBound, hiBound);
        return possResults;
    }

    private void trackPersistent(Object target) {
        if (target instanceof Persistent) {
            Persistent persistent = (Persistent)target;
            this.trackedPersistents.put(new VCCacheKey(persistent), persistent);
            PersistenceData persistenceData = persistent.getPersistenceData();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session " + this.toString() + " Now tracking persistent " + persistenceData.getPath()));
            }
        } else {
            throw new RuntimeException("Cannot restore a " + target.getClass() + " (" + target + ") because it does not implement Persistent.");
        }
    }

    Set<Persistent> getDirtyPersistents() {
        HashSet<Persistent> result = new HashSet<Persistent>();
        for (Persistent persistent : this.trackedPersistents.values()) {
            PersistenceData persistenceData = persistent.getPersistenceData();
            if (!persistenceData.isDirty() || persistenceData.isDeleted()) continue;
            result.add(persistent);
        }
        log.debug((Object)("Session " + this + " has " + result.size() + " dirty persistents."));
        return result;
    }

    Set<Persistent> getDirtyAndDeletedPersistents() {
        HashSet<Persistent> result = new HashSet<Persistent>();
        for (Persistent persistent : this.trackedPersistents.values()) {
            PersistenceData persistenceData = persistent.getPersistenceData();
            if (!persistenceData.isDeleted() || !persistenceData.isDirty()) continue;
            result.add(persistent);
        }
        log.debug((Object)("Session " + this + " has " + result.size() + " deleted persistents."));
        return result;
    }

    public Commit getCommit(long id) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.readCommit(id);
    }

    public <T extends Persistent> List<Commit> getCommitsForPersistent(T persistent) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.readCommitsForPersistent(persistent.getPersistenceData().getPath());
    }

    public List<Commit> getCommitsForPersistent(String path) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.readCommitsForPersistent(path);
    }

    public List<Commit> getCommitsForPath(String path) {
        path = new Handle(path, -1).getPath();
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.readCommitsForPath(path);
    }

    public <T extends Persistent> Integer getVersionCountForPersistent(T persistent) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.getVersionCountForPersistent(persistent);
    }

    public <T extends Persistent> Integer getVersionForCommit(T persistent, Long commit) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.getVersionForCommit(persistent, commit);
    }

    protected void cacheLatestVersion(String path, Integer version) {
        this.latestVersionCache.put(path, version);
    }

    protected Integer getCachedLatestVersion(String path) {
        return this.latestVersionCache.get(path);
    }

    public void close() {
        this.repository.unbindSession();
    }
}

