/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.util;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.util.LineDelimiterVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;

public class VerifyLineDelimiterInputStream
extends LineDelimiterVerifier {
    private boolean pendingChar = false;
    private int lastChar = -1;
    private boolean markPendingChar = false;
    private int markLastChar = -1;

    public VerifyLineDelimiterInputStream(InputStream in, String encoding, FileLineDelimiter expectedLineTerminator) throws UnsupportedEncodingException {
        super(in, encoding, expectedLineTerminator);
    }

    public VerifyLineDelimiterInputStream(InputStream in, String encoding) throws UnsupportedEncodingException {
        this(in, encoding, FileLineDelimiter.LINE_DELIMITER_NONE);
    }

    @Override
    public int read() throws IOException {
        boolean wasPending = false;
        if (!this.pendingChar) {
            this.lastChar = super.read();
            this.pendingChar = true;
        } else {
            wasPending = true;
        }
        if (this.lastChar == 13) {
            this.lastChar = super.read();
            if (this.lastChar == 10) {
                this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CRLF);
            } else {
                this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CR);
                if (this.lastChar == -1) {
                    this.pendingChar = false;
                }
            }
            return 13;
        }
        if (this.lastChar == 10 && !wasPending) {
            this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_LF);
        }
        this.pendingChar = false;
        return this.lastChar;
    }

    @Override
    public int read(char[] buffer, int off, int len) throws IOException {
        InterruptedIOException iioe;
        int startValidate;
        int count;
        block23: {
            block24: {
                if (len == 0) {
                    return 0;
                }
                if (len == 1) {
                    int b = this.read();
                    if (b == -1) {
                        return -1;
                    }
                    buffer[off] = (char)b;
                    return 1;
                }
                count = 0;
                startValidate = off;
                if (this.pendingChar) {
                    buffer[off] = (char)this.lastChar;
                    this.pendingChar = false;
                    count = 1;
                    if (this.lastChar == 10) {
                        ++startValidate;
                    }
                }
                iioe = null;
                len = super.read(buffer, off + count, len - count);
                if (len != -1) break block23;
                if (count != 0) break block24;
                return -1;
            }
            try {
                if (startValidate == off) {
                    char b = buffer[startValidate];
                    if (b == '\r') {
                        this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CR);
                    }
                    return count;
                }
            }
            catch (InterruptedIOException e) {
                len = e.bytesTransferred;
                iioe = e;
            }
        }
        int j = startValidate;
        int i = startValidate;
        while (i < off + count + len) {
            this.lastChar = buffer[i];
            if (this.lastChar == 13) {
                if (this.pendingChar) {
                    this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CR);
                    ++j;
                } else {
                    this.pendingChar = true;
                }
            } else {
                if (this.pendingChar) {
                    ++j;
                    if (this.lastChar == 10) {
                        this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CRLF);
                    } else {
                        this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CR);
                    }
                    this.pendingChar = false;
                } else if (this.lastChar == 10) {
                    this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_LF);
                }
                ++j;
            }
            ++i;
        }
        if (iioe != null) {
            iioe.bytesTransferred = j - off;
            throw iioe;
        }
        if (j - off == 0) {
            int b = this.read();
            if (b == -1) {
                return -1;
            }
            buffer[off] = (char)b;
            return 1;
        }
        return j - off;
    }

    @Override
    public long skip(long count) throws IOException {
        int actualCount = 0;
        try {
            while (count-- > 0L && this.read() != -1) {
                ++actualCount;
            }
            return actualCount;
        }
        catch (InterruptedIOException e) {
            e.bytesTransferred = actualCount;
            throw e;
        }
    }

    @Override
    public void mark(int readlimit) throws IOException {
        super.mark(readlimit + 2);
        this.markLastChar = this.lastChar;
        this.markPendingChar = this.pendingChar;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.lastChar = this.markLastChar;
        this.pendingChar = this.markPendingChar;
    }
}

