/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.operations;

import com.ibm.team.connector.scm.operations.BuildResultUpdater;
import com.ibm.team.connector.scm.operations.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.io.PrintStream;
import javax.wvcm.DetailedFeedback;
import javax.wvcm.WvcmException;

public class TaskDetailedFeedback
extends DetailedFeedback {
    private static final long NANO = 1000000000L;
    private static final long MICRO = 1000000L;
    private static String _lastMessage;
    private PrintStream _out;
    private Long _activityDurationStartTime = System.nanoTime();
    private BuildResultUpdater _buildResult;
    private boolean _abortRequestedOnce = false;

    public TaskDetailedFeedback(BuildResultUpdater buildResult, PrintStream out) {
        this._buildResult = buildResult;
        this._out = out;
    }

    public TaskDetailedFeedback(BuildResultUpdater buildResult) {
        this(buildResult, System.out);
    }

    public TaskDetailedFeedback(PrintStream out) {
        this(null, out);
    }

    public BuildResultUpdater getBuildResult() {
        return this._buildResult;
    }

    public PrintStream get_out() {
        return this._out;
    }

    public void notifyPercentComplete(int percentComplete) {
        if (this._buildResult != null && this._last > 0 && !this._abortRequestedOnce) {
            String timeMessage = this.format(Messages.TaskDetailedFeedback_ACTIVE_TIME_MSG, new Object[]{_lastMessage, String.valueOf(this._last)});
            try {
                this._buildResult.startTopLevelActivity(timeMessage);
            }
            catch (WvcmException wvcmException) {}
        }
        super.notifyPercentComplete(percentComplete);
    }

    public void notifyActive(String message) {
        _lastMessage = message;
        this._out.println(message);
        this.ensureBuildIsStillActive();
        super.notifyActive(message);
    }

    public void notifyCompleted(String message) {
        String durationMessage;
        long currentTime = System.nanoTime();
        long durationSeconds = (currentTime - this._activityDurationStartTime) / 1000000000L;
        if (durationSeconds > 9L) {
            durationMessage = NLS.bind((String)Messages.TaskDetailedFeedback_ACTIVITY_DURATION, (Object)message, (Object[])new Object[]{durationSeconds});
        } else {
            long durationMilli = (currentTime - this._activityDurationStartTime) / 1000000L;
            durationMessage = NLS.bind((String)Messages.TaskDetailedFeedback_ACTIVITY_DURATION_MILLI, (Object)message, (Object[])new Object[]{durationMilli});
        }
        this._out.println(durationMessage);
        this._activityDurationStartTime = currentTime;
        if (durationSeconds > 60L) {
            this.ensureBuildIsStillActive();
        }
        super.notifyCompleted(message);
    }

    private void ensureBuildIsStillActive() {
        if (this._buildResult != null && !this._abortRequestedOnce && !this._buildResult.isBuildStillActive()) {
            this._abortRequestedOnce = true;
            this.abortRequested(true);
        }
    }

    public void notifyWarning(String message) {
        this._out.println(NLS.bind((String)Messages.TaskDetailedFeedback_WARNING, (Object)message, (Object[])new Object[0]));
        super.notifyWarning(message);
    }
}

