/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.Messages;
import com.ibm.team.scm.client.VisibilityEnum;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IPrivateScope;
import com.ibm.team.scm.common.dto.IProcessAreaScope;
import com.ibm.team.scm.common.dto.IPublicScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.ITeamAreaPrivateScope;
import com.ibm.team.scm.common.internal.dto.ContributorDeferringScope;
import com.ibm.team.scm.common.internal.dto.PrivateScope;
import com.ibm.team.scm.common.internal.dto.ProcessAreaScope;
import com.ibm.team.scm.common.internal.dto.PublicScope;

public class Visibility {
    private final VisibilityEnum viz;
    private final IProjectAreaHandle scope;
    private final IReadScope readScope;
    public static final Visibility PUBLIC = new Visibility(VisibilityEnum.PUBLIC_TO_ALL, null);
    public static final Visibility PRIVATE = new Visibility(VisibilityEnum.PRIVATE_TO_OWNER, null);

    public Visibility(VisibilityEnum v, IProjectAreaHandle ph) {
        this.viz = v;
        this.scope = ph;
        if (v == VisibilityEnum.PRIVATE_TO_OWNER) {
            this.readScope = IReadScope.FACTORY.createPrivateScope();
        } else if (v == VisibilityEnum.PUBLIC_TO_ALL) {
            this.readScope = IReadScope.FACTORY.createPublicScope();
        } else if (v == VisibilityEnum.PROTECTED) {
            IContributorDeferringScope deferring = IReadScope.FACTORY.createContributorDeferringScope();
            deferring.setScope((IAuditableHandle)ph);
            this.readScope = deferring;
        } else {
            this.readScope = null;
        }
    }

    public Visibility(IReadScope scope) {
        if (scope instanceof PrivateScope) {
            this.viz = VisibilityEnum.PRIVATE_TO_OWNER;
            this.scope = null;
        } else if (scope instanceof PublicScope) {
            this.viz = VisibilityEnum.PUBLIC_TO_ALL;
            this.scope = null;
        } else if (scope instanceof ContributorDeferringScope) {
            this.viz = VisibilityEnum.PROTECTED;
            this.scope = (IProjectAreaHandle)((ContributorDeferringScope)scope).getScope();
        } else {
            this.viz = null;
            this.scope = null;
        }
        this.readScope = scope;
    }

    public VisibilityEnum getVisibility() {
        return this.viz;
    }

    public IProjectAreaHandle getProjectAreaScope() {
        return this.scope;
    }

    public IReadScope getReadScope() {
        return this.readScope;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Visibility)) {
            return false;
        }
        Visibility other = (Visibility)o;
        if (this.getVisibility() != other.getVisibility()) {
            return false;
        }
        if (this.getProjectAreaScope() != null && !this.getProjectAreaScope().sameItemId((IItemHandle)other.getProjectAreaScope())) {
            return false;
        }
        if (this.getReadScope() == null) {
            return other.getReadScope() == null;
        }
        if (!this.getReadScope().getClass().equals(other.getReadScope().getClass())) {
            return false;
        }
        if (this.getReadScope() instanceof ContributorDeferringScope) {
            ContributorDeferringScope mine = (ContributorDeferringScope)this.getReadScope();
            ContributorDeferringScope yours = (ContributorDeferringScope)other.getReadScope();
            if (mine.getScope() == null) {
                return yours.getScope() == null;
            }
            return mine.getScope().sameItemId((IItemHandle)yours.getScope());
        }
        if (this.getReadScope() instanceof ProcessAreaScope) {
            ProcessAreaScope mine = (ProcessAreaScope)this.getReadScope();
            ProcessAreaScope yours = (ProcessAreaScope)other.getReadScope();
            if (mine.getProcessArea() == null) {
                return yours.getProcessArea() == null;
            }
            return mine.getProcessArea().sameItemId((IItemHandle)yours.getProcessArea());
        }
        return true;
    }

    public String toString() {
        if (this.readScope != null) {
            if (this.readScope instanceof IPrivateScope) {
                return Messages.Visibility_0;
            }
            if (this.readScope instanceof IPublicScope) {
                return Messages.Visibility_1;
            }
            if (this.readScope instanceof IContributorDeferringScope) {
                return Messages.Visibility_2;
            }
            if (this.readScope instanceof IProcessAreaScope) {
                return Messages.Visibility_2;
            }
            if (this.readScope instanceof ITeamAreaPrivateScope) {
                return Messages.Visibility_TEAM_PRIVATE;
            }
            return Messages.Visibility_3;
        }
        if (this.viz == VisibilityEnum.PRIVATE_TO_OWNER) {
            return Messages.Visibility_0;
        }
        if (this.viz == VisibilityEnum.PUBLIC_TO_ALL) {
            return Messages.Visibility_1;
        }
        if (this.viz == VisibilityEnum.PROTECTED) {
            return Messages.Visibility_2;
        }
        return Messages.Visibility_3;
    }
}

