/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet;

import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_value.PropValue;
import com.urbancode.air.property.web.rest.PropDefResource;
import com.urbancode.air.property.web.rest.PropValueResource;
import com.urbancode.commons.webext.util.JSONOutputType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropSheetDiffReport {
    private Map<String, PropValue> leftProps = new HashMap<String, PropValue>();
    private Map<String, PropDef> leftPropDefs = new HashMap<String, PropDef>();
    private Map<String, PropValue> rightProps = new HashMap<String, PropValue>();
    private Map<String, PropDef> rightPropDefs = new HashMap<String, PropDef>();
    private List<String> newInLeft = new ArrayList<String>();
    private List<String> newInRight = new ArrayList<String>();
    private List<String> differentValues = new ArrayList<String>();
    private List<String> allNames = new ArrayList<String>();

    public PropSheetDiffReport(Collection<PropSheet> left, Collection<PropSheet> right) {
        String propName;
        PropSheetDef propSheetDef;
        for (PropSheet propSheet : left) {
            if (propSheet == null) continue;
            propSheetDef = propSheet.getPropSheetDef();
            if (propSheetDef != null) {
                for (PropDef propDef : propSheetDef.getPropDefList()) {
                    propName = propDef.getName();
                    this.leftPropDefs.put(propName, propDef);
                    this.leftProps.put(propName, propSheet.getPropValueObject(propName));
                }
                continue;
            }
            for (PropValue propValue : propSheet.getPropValueList()) {
                propName = propValue.getName();
                this.leftProps.put(propName, propValue);
                this.leftPropDefs.put(propName, null);
            }
        }
        for (PropSheet propSheet : right) {
            if (propSheet == null) continue;
            propSheetDef = propSheet.getPropSheetDef();
            if (propSheetDef != null) {
                for (PropDef propDef : propSheetDef.getPropDefList()) {
                    propName = propDef.getName();
                    this.rightPropDefs.put(propName, propDef);
                    this.rightProps.put(propName, propSheet.getPropValueObject(propName));
                }
                continue;
            }
            for (PropValue propValue : propSheet.getPropValueList()) {
                propName = propValue.getName();
                this.rightProps.put(propName, propValue);
                this.rightPropDefs.put(propName, null);
            }
        }
        HashSet<String> allKeys = new HashSet<String>();
        allKeys.addAll(this.leftProps.keySet());
        allKeys.addAll(this.rightProps.keySet());
        allKeys.addAll(this.leftPropDefs.keySet());
        allKeys.addAll(this.rightPropDefs.keySet());
        this.allNames.addAll(allKeys);
        Collections.sort(this.allNames);
        for (String name : this.allNames) {
            String leftValue = null;
            if (this.leftProps.get(name) != null) {
                leftValue = this.leftProps.get(name).getValue();
            } else if (this.leftPropDefs.get(name) != null) {
                leftValue = this.leftPropDefs.get(name).getDefaultValue();
            }
            String rightValue = null;
            if (this.rightProps.get(name) != null) {
                rightValue = this.rightProps.get(name).getValue();
            } else if (this.rightPropDefs.get(name) != null) {
                rightValue = this.rightPropDefs.get(name).getDefaultValue();
            }
            if (rightValue == null) {
                this.newInLeft.add(name);
                continue;
            }
            if (leftValue == null) {
                this.newInRight.add(name);
                continue;
            }
            if (StringUtils.equals((String)leftValue, (String)rightValue)) continue;
            this.differentValues.add(name);
        }
        Collections.sort(this.newInLeft);
        Collections.sort(this.newInRight);
        Collections.sort(this.differentValues);
    }

    public boolean arePropSheetsEquivalent() {
        boolean result = false;
        if (this.differentValues.isEmpty() && this.newInLeft.isEmpty() && this.newInRight.isEmpty()) {
            result = true;
        }
        return result;
    }

    public List<PropValue> getNewLeftPropValues() {
        ArrayList<PropValue> result = new ArrayList<PropValue>();
        for (String key : this.newInLeft) {
            result.add(this.leftProps.get(key));
        }
        return result;
    }

    public List<PropValue> getNewRightPropValues() {
        ArrayList<PropValue> result = new ArrayList<PropValue>();
        for (String key : this.newInRight) {
            result.add(this.rightProps.get(key));
        }
        return result;
    }

    public List<String> getDifferentPropValueNames() {
        return Collections.unmodifiableList(this.differentValues);
    }

    public JSONArray toJSON() throws Exception {
        JSONArray result = new JSONArray();
        for (String name : this.allNames) {
            result.put((Object)new JSONObject().put("name", (Object)name).put("leftPropValue", (Object)new PropValueResource().toJSON(this.leftProps.get(name), new JSONOutputType[0])).put("leftPropDef", (Object)new PropDefResource().toJSON(this.leftPropDefs.get(name), new JSONOutputType[0])).put("rightPropValue", (Object)new PropValueResource().toJSON(this.rightProps.get(name), new JSONOutputType[0])).put("rightPropDef", (Object)new PropDefResource().toJSON(this.rightPropDefs.get(name), new JSONOutputType[0])).put("different", this.differentValues.contains(name) || this.newInRight.contains(name) || this.newInLeft.contains(name)));
        }
        return result;
    }
}

