/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet_group;

import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet.PropSheetFactoryRegistry;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactoryRegistry;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.PersistenceData;
import com.urbancode.air.vc.Persistent;
import com.urbancode.persistence.IDGenerator;
import com.urbancode.persistence.hibernate.AbstractEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="propSheetsCache")
@Entity
@Table(name="ps_prop_sheet_group")
public class PropSheetGroup
extends AbstractEntity<UUID>
implements Persistent {
    private static final long serialVersionUID = -6676786342302221908L;
    private static final Logger log = Logger.getLogger(PropSheetGroup.class);
    @Transient
    private PersistenceData persistenceData = new PersistenceData((Persistent)this, true);
    @Id
    @Column(name="id")
    @Type(type="uuid-char")
    UUID id = IDGenerator.createID();
    @OneToMany(mappedBy="propSheetGroup", orphanRemoval=true)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.DELETE})
    private Set<PropSheet> propSheets = new HashSet<PropSheet>();
    @Transient
    Set<Handle> propSheetHandles = new HashSet<Handle>();
    @Transient
    transient Set<PropSheet> cachedPropSheets;
    @OneToMany(mappedBy="propSheetGroup", orphanRemoval=true)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.DELETE})
    private Set<PropSheetDef> propSheetDefs = new HashSet<PropSheetDef>();
    @Transient
    Set<Handle> propSheetDefHandles = new HashSet<Handle>();
    @Transient
    transient Set<PropSheetDef> cachedPropSheetDefs;

    public UUID getId() {
        return this.id;
    }

    public Set<PropSheet> getPropSheetSet() {
        Set<PropSheet> result = null;
        if (!this.propSheets.isEmpty()) {
            result = this.propSheets;
        } else if (!this.propSheetHandles.isEmpty()) {
            result = new HashSet<PropSheet>();
            for (Handle propSheetHandle : this.propSheetHandles) {
                PropSheet propSheet = PropSheetFactoryRegistry.getFactory().getPropSheetForHandle(propSheetHandle);
                if (propSheet != null) {
                    result.add(propSheet);
                    continue;
                }
                log.error((Object)("Could not restore PropSheet for PropSheetGroup by handle " + propSheetHandle));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Current stack: ", (Throwable)new Exception());
            }
        } else {
            result = new HashSet<PropSheet>();
        }
        return Collections.unmodifiableSet(result);
    }

    public void addPropSheet(PropSheet propSheet) {
        if (this.isVersioned()) {
            if (!propSheet.isVersioned()) {
                throw new IllegalArgumentException("Cannot add unversioned PropSheets to a versioned PropSheetGroup");
            }
            Handle propSheetHandle = new Handle(propSheet.getPersistenceData().getPath(), Integer.valueOf(-1));
            this.propSheetHandles.add(propSheetHandle);
        } else {
            if (propSheet.isVersioned()) {
                throw new IllegalArgumentException("Cannot add versioned PropSheets to an unversioned PropSheetGroup");
            }
            this.propSheets.add(propSheet);
        }
        if (!ObjectUtils.equals((Object)((Object)this), (Object)((Object)propSheet.getPropSheetGroup()))) {
            propSheet.setPropSheetGroup(this);
        }
        if (this.cachedPropSheets != null) {
            this.cachedPropSheets.add(propSheet);
        }
        this.persistenceData.setDirty(true);
    }

    public PropSheet getPropSheet(String name) {
        PropSheet result = null;
        if (name == null) {
            throw new UnsupportedOperationException("Cannot get a PropSheet by a null name");
        }
        ArrayList<PropSheet> toRemove = new ArrayList<PropSheet>();
        for (PropSheet propSheet : this.getPropSheetSet()) {
            if (!name.equals(propSheet.getName())) continue;
            if (result == null) {
                result = propSheet;
                continue;
            }
            toRemove.add(propSheet);
        }
        for (PropSheet propSheet : toRemove) {
            this.removePropSheet(propSheet);
        }
        return result;
    }

    public PropSheet getPropSheet(PropSheetDef propSheetDef) {
        PropSheet result = null;
        if (propSheetDef == null) {
            throw new UnsupportedOperationException("Cannot get a PropSheet by a null propSheetDef");
        }
        for (PropSheet propSheet : this.getPropSheetSet()) {
            if (!propSheetDef.equals((Object)propSheet.getPropSheetDef())) continue;
            result = propSheet;
            break;
        }
        return result;
    }

    public void removePropSheet(String name) {
        PropSheet propSheet = this.getPropSheet(name);
        if (propSheet != null) {
            if (this.cachedPropSheets != null) {
                this.cachedPropSheets.remove((Object)propSheet);
            }
            this.propSheets.remove((Object)propSheet);
            if (this.isVersioned()) {
                Handle propSheetHandle = new Handle(propSheet.getPersistenceData().getPath(), Integer.valueOf(-1));
                this.propSheetHandles.remove(propSheetHandle);
            }
        }
        this.persistenceData.setDirty(true);
    }

    public void removePropSheet(PropSheetDef propSheetDef) {
        PropSheet propSheet = this.getPropSheet(propSheetDef);
        if (propSheet != null) {
            if (this.cachedPropSheets != null) {
                this.cachedPropSheets.remove((Object)propSheet);
            }
            this.propSheets.remove((Object)propSheet);
            if (this.isVersioned()) {
                Handle propSheetHandle = new Handle(propSheet.getPersistenceData().getPath(), Integer.valueOf(-1));
                this.propSheetHandles.remove(propSheetHandle);
            }
        }
        this.persistenceData.setDirty(true);
    }

    public void removePropSheet(PropSheet propSheet) {
        if (this.isVersioned()) {
            Handle propSheetHandle = new Handle(propSheet.getPersistenceData().getPath(), Integer.valueOf(-1));
            this.propSheetHandles.remove(propSheetHandle);
        } else {
            this.propSheets.remove((Object)propSheet);
        }
        propSheet.setPropSheetGroup(null);
        if (this.cachedPropSheets != null) {
            this.cachedPropSheets.remove((Object)propSheet);
        }
        this.persistenceData.setDirty(true);
    }

    public Set<PropSheetDef> getPropSheetDefSet() {
        Set<PropSheetDef> result = null;
        if (!this.propSheetDefs.isEmpty()) {
            result = this.propSheetDefs;
        } else if (!this.propSheetDefHandles.isEmpty()) {
            result = new HashSet<PropSheetDef>();
            for (Handle propSheetDefHandle : this.propSheetDefHandles) {
                PropSheetDef propSheetDef = PropSheetDefFactoryRegistry.getFactory().getPropSheetDefForHandle(propSheetDefHandle);
                if (propSheetDef != null) {
                    result.add(propSheetDef);
                    continue;
                }
                log.error((Object)("Could not restore PropSheetDef for PropSheetGroup by handle " + propSheetDefHandle));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Current stack: ", (Throwable)new Exception());
            }
        } else {
            result = new HashSet<PropSheetDef>();
        }
        return Collections.unmodifiableSet(result);
    }

    public void addPropSheetDef(PropSheetDef propSheetDef) {
        if (this.isVersioned()) {
            if (!propSheetDef.isVersioned()) {
                throw new IllegalArgumentException("Cannot add unversioned PropSheetDefs to a versioned PropSheetGroup");
            }
            Handle propSheetDefHandle = new Handle(propSheetDef.getPersistenceData().getPath(), Integer.valueOf(-1));
            this.propSheetDefHandles.add(propSheetDefHandle);
        } else {
            if (propSheetDef.isVersioned()) {
                throw new IllegalArgumentException("Cannot add versioned PropSheetDefs to an unversioned PropSheetGroup");
            }
            this.propSheetDefs.add(propSheetDef);
        }
        if (!ObjectUtils.equals((Object)((Object)this), (Object)((Object)propSheetDef.getPropSheetGroup()))) {
            propSheetDef.setPropSheetGroup(this);
        }
        if (this.cachedPropSheetDefs != null) {
            this.cachedPropSheetDefs.add(propSheetDef);
        }
        this.persistenceData.setDirty(true);
    }

    public PropSheetDef getPropSheetDef(String name) {
        PropSheetDef result = null;
        if (name == null) {
            throw new UnsupportedOperationException("Cannot get a PropSheetDef by a null name");
        }
        ArrayList<PropSheetDef> toRemove = new ArrayList<PropSheetDef>();
        for (PropSheetDef propSheetDef : this.getPropSheetDefSet()) {
            if (!name.equals(propSheetDef.getName())) continue;
            if (result == null) {
                result = propSheetDef;
                continue;
            }
            toRemove.add(propSheetDef);
        }
        for (PropSheetDef propSheetDef : toRemove) {
            this.removePropSheetDef(propSheetDef);
        }
        return result;
    }

    public void removePropSheetDef(String name) {
        PropSheetDef propSheetDef = this.getPropSheetDef(name);
        if (propSheetDef != null) {
            this.propSheetDefs.remove((Object)propSheetDef);
        }
    }

    public void removePropSheetDef(PropSheetDef propSheetDef) {
        if (this.isVersioned()) {
            Handle propSheetDefHandle = new Handle(propSheetDef.getPersistenceData().getPath(), Integer.valueOf(-1));
            this.propSheetDefHandles.remove(propSheetDefHandle);
        } else {
            this.propSheetDefs.remove((Object)propSheetDef);
        }
        propSheetDef.setPropSheetGroup(null);
        if (this.cachedPropSheetDefs != null) {
            this.cachedPropSheetDefs.remove((Object)propSheetDef);
        }
        this.persistenceData.setDirty(true);
    }

    public void setPropValue(String name, String value) {
        String rawName = null;
        PropSheet propSheet = null;
        for (PropSheet child : this.propSheets) {
            if (!name.startsWith(propSheet.getName() + "/")) continue;
            rawName = name.substring(propSheet.getName().length() + 1);
            propSheet = child;
        }
        if (propSheet == null) {
            throw new IllegalArgumentException("Property sheet not found to set property '" + name + "'.");
        }
        propSheet.setPropValue(rawName, value);
    }

    public boolean isVersioned() {
        return this.persistenceData.getPath() != null;
    }

    public PersistenceData getPersistenceData() {
        return this.persistenceData;
    }
}

