/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.web.rest;

import com.urbancode.air.property.prop_value.PropValue;
import com.urbancode.commons.util.crypto.CryptStringUtil;
import com.urbancode.commons.webext.util.AbstractResource;
import com.urbancode.commons.webext.util.JSONUtilities;
import javax.ws.rs.Path;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="propValue")
public class PropValueResource
extends AbstractResource<PropValue> {
    private static PropValueResource instance = new PropValueResource();

    public static PropValueResource getInstance() {
        return instance;
    }

    protected JSONObject getBasicJSON(PropValue propValue) throws Exception {
        JSONObject result = new JSONObject();
        result.put("id", (Object)propValue.getId());
        result.put("name", (Object)propValue.getName());
        result.put("value", (Object)propValue.getSafeValue());
        result.put("label", (Object)propValue.getLabel());
        result.put("description", (Object)propValue.getDescription());
        result.put("secure", (Object)propValue.isSecure());
        return result;
    }

    protected JSONObject getExtendedJSON(PropValue propValue) throws Exception {
        JSONObject result = new JSONObject();
        result.put("usingDefault", propValue.isUsingDefault());
        return result;
    }

    protected JSONObject getExportJSON(PropValue propValue) throws Exception {
        JSONObject result = this.getBasicJSON(propValue);
        String rawValue = propValue.getRawValue();
        if (propValue.isSecure().booleanValue() && !CryptStringUtil.isEncrypted((String)rawValue)) {
            String encryptedValue = CryptStringUtil.encrypt((String)rawValue);
            result.put("value", (Object)encryptedValue);
        } else {
            result.put("value", (Object)rawValue);
        }
        result.remove("id");
        return result;
    }

    public void setValuesFromJSON(PropValue propValue, JSONObject submittedJson) throws Exception {
        String label;
        String description = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"description");
        Boolean secure = JSONUtilities.getBooleanFromJsonObject((JSONObject)submittedJson, (String)"secure");
        String value = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"value");
        if (StringUtils.isEmpty((String)value)) {
            value = "";
        }
        if (StringUtils.isEmpty((String)(label = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"label")))) {
            label = "";
        }
        propValue.setDescription(description);
        propValue.setSecure(secure);
        propValue.setValue(value);
        propValue.setLabel(label);
    }
}

