/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.ControllableFolderImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.rational.wvcm.ri.srvc.SrvcUtils;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoBaseline;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoRootVersion;
import com.ibm.team.connector.scm.client.JzRepoSymbolicLink;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.wvcm.ControllableFolder;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.WvcmException;

public class JzRepoControllableFolder
extends JzRepoControllableResource {
    public static final String CHILD_LIST_SEPARATOR_STRING = String.valueOf(',');

    public JzRepoControllableFolder(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ControllableFolderImpl.class;
    }

    public static JzRepoResource doCreate(JzProvider provider, JzLocation location, SrvcFeedback feedback) throws WvcmException {
        IVersionable resource = (IVersionable)IFolder.ITEM_TYPE.createItem();
        JzLocation actualAddedItemLocation = JzRepoControllableResource.doAddItemToParent(provider, location, resource, feedback);
        JzRepoControllableFolder result = new JzRepoControllableFolder(provider, (Location)actualAddedItemLocation);
        return result;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Folder.CHILD_MAP)) {
            return this.childMap(false, this.getConfiguration(feedback), feedback);
        }
        if (propertyName.equals((Object)Folder.CHILD_LIST)) {
            return this.computeChildList(feedback);
        }
        if (propertyName.equals((Object)ControllableFolder.ROOT_FOLDER_OF)) {
            return null;
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private List<JzRepoResource> computeChildList(SrvcFeedback feedback) throws WvcmException {
        Map<String, JzRepoResource> map = this.childMap(false, this.getConfiguration(feedback), feedback);
        ArrayList<JzRepoResource> result = new ArrayList<JzRepoResource>();
        result.addAll(map.values());
        return result;
    }

    public void doBindChild(String newBindingName, Location genericLocation, Folder.BindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits(feedback);
        JzLocation currentLoc = JzLocation.create(genericLocation);
        JzRepoControllableResource childCR = (JzRepoControllableResource)this.provider().lookup((Location)currentLoc, feedback);
        if (childCR == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoControllableFolder_ERROR_NO_CHILD_AT_LOCATION, (Object)currentLoc.string(), (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        this.rebindChildHelper((IVersionableHandle)childCR.getItemHandle(feedback), newBindingName, feedback);
    }

    public void doRebindChild(String bindingName, Location currentParentLocation, String sourceBindingName, Folder.RebindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits(feedback);
        JzProvider provider = this.provider();
        JzRepoControllableFolder currentParent = (JzRepoControllableFolder)provider.get(currentParentLocation, feedback);
        IVersionableHandle childHandle = currentParent.getChild(sourceBindingName, feedback);
        this.rebindChildHelper(childHandle, bindingName, feedback);
    }

    public void doRebindAll(String bindingName, Location sourceLocation, Folder.RebindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits(feedback);
        JzProvider provider = this.provider();
        JzRepoControllableResource sourceCR = (JzRepoControllableResource)provider.get(sourceLocation, feedback);
        IVersionableHandle sourceHandle = (IVersionableHandle)sourceCR.getItemHandle(feedback);
        this.rebindChildHelper(sourceHandle, bindingName, feedback);
    }

    private void rebindChildHelper(IVersionableHandle childHandle, String newBindingName, SrvcFeedback feedback) throws WvcmException {
        IConfiguration config = this.getConfiguration(feedback.nest(10));
        try {
            IVersionable itemToRebind = (IVersionable)config.fetchCompleteItem(childHandle, JzProvider.getMonitor(feedback, 20)).getWorkingCopy();
            itemToRebind.setName(newBindingName);
            itemToRebind.setParent((IFolderHandle)this.getItemHandle(feedback.nest(40)));
            JzLocation reboundLocation = this.location().child(newBindingName);
            this.commit(itemToRebind, reboundLocation, feedback);
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException(e.getMessage(), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public void doUnbindChild(String bindingName, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits(feedback.nest(40));
        IVersionableHandle deleteMe = this.getChild(bindingName, feedback.nest(55));
        boolean itemToUnbindIsAFolder = deleteMe.getItemType().equals(IFolder.ITEM_TYPE);
        IWorkspaceConnection wsConn = this.getWorkspaceConnection(feedback.nest(70));
        IWorkspaceConnection.IDeleteOp configurationOp = itemToUnbindIsAFolder ? wsConn.configurationOpFactory().deleteSubtree((IFolderHandle)deleteMe) : wsConn.configurationOpFactory().delete(deleteMe);
        this.commit((IWorkspaceConnection.IConfigurationOp)configurationOp, this.location().child(bindingName), feedback);
    }

    public IVersionableHandle getChild(String bindingName, SrvcFeedback feedback) throws WvcmException {
        try {
            IVersionableHandle result = this.getConfiguration(feedback.nest(20)).resolvePath((IFolderHandle)this.getItemHandle(feedback.nest(40)), new String[]{bindingName}, JzProvider.getMonitor(feedback, 100));
            if (result == null) {
                throw new WvcmException(NLS.bind((String)Messages.JzRepoControllableFolder_ERROR_CHILD_NOT_FOUND_WITH_NAME, (Object)bindingName, (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static SrvcResource doCreateVersionControlledResource(JzProvider provider, Location genericNewLocation, Location genericVersionToRestoreLoc, boolean deferCommit, SrvcFeedback feedback) throws WvcmException {
        JzLocation newLocation = JzLocation.create(genericNewLocation);
        JzLocation parent = newLocation.parent();
        JzRepoControllableFolder restoreToThisFolder = (JzRepoControllableFolder)provider.get((Location)parent, feedback.nest(5));
        JzRepoComponent restoreToThisComponent = restoreToThisFolder.getJzRepoComponent(feedback.nest(10));
        JzLocation versionToRestoreLoc = JzLocation.create(genericVersionToRestoreLoc);
        JzRepoVersion versionToRestore = (JzRepoVersion)provider.get((Location)versionToRestoreLoc, feedback.nest(15));
        JzRepoComponent versionToRestoreComponent = versionToRestore.getJzRepoComponent(feedback.nest(20));
        JzRepoWorkspace ws = (JzRepoWorkspace)provider.get((Location)newLocation.getWorkspaceLocation(), feedback.nest(40));
        if (!restoreToThisComponent.isSameObject(versionToRestoreComponent, feedback.nest(45))) {
            IFolderHandle rootFolderHandle = versionToRestoreComponent.getRootFolderHandle(feedback.nest(50));
            IFolderHandle parentFolderHandle = versionToRestore.getParentFolderHandle(feedback.nest(55));
            if (!parentFolderHandle.sameItemId((IItemHandle)rootFolderHandle)) {
                throw new WvcmException(Messages.JzRepoControllableFolder_ERROR_NO_CROSS_COMPONENT_MOVES, WvcmException.ReasonCode.FORBIDDEN);
            }
            ws.ensureComponentInConfiguration(versionToRestoreComponent, feedback.nest(60));
            restoreToThisComponent = versionToRestoreComponent;
            JzLocation parentLoc = ws.computeBcfLoc(versionToRestoreComponent);
            restoreToThisFolder = (JzRepoControllableFolder)JzRepoControllableFolder.createFromVersionable(provider, parentLoc, (IVersionableHandle)rootFolderHandle);
        }
        IWorkspaceConnection wsConn = ws.getConnection(feedback.nest(70));
        return restoreToThisFolder.doCreateVersionControlledResourceInternal(wsConn, newLocation, versionToRestore, deferCommit, feedback);
    }

    public static SrvcResource doCreateBaselineControlledFolder(JzProvider provider, Location genericNewLocation, Location genericBaselineToRestoreLoc, SrvcFeedback feedback) throws WvcmException {
        JzLocation newLocation = JzLocation.create(genericNewLocation);
        JzRepoBaseline bl = (JzRepoBaseline)provider.get(genericBaselineToRestoreLoc, feedback.nest(10));
        JzRepoWorkspace ws = (JzRepoWorkspace)provider.get((Location)newLocation.getWorkspaceLocation(), feedback.nest(20));
        JzRepoWorkspace.doUpdate(provider, newLocation, (IFlowNodeConnection)ws.getConnection(feedback.nest(30)), bl.getConnection(feedback.nest(40)), feedback.nest(50));
        JzLocation resultLoc = ws.computeBcfLoc(bl.getComponent(feedback.nest(60)));
        JzRepoControllableFolder result = (JzRepoControllableFolder)provider.get((Location)resultLoc, feedback.nest(100));
        return result;
    }

    public JzRepoControllableResource doCreateVersionControlledResourceInternal(IWorkspaceConnection wsConn, JzLocation newLocationHint, JzRepoVersion versionToRestore, boolean deferCommit, SrvcFeedback feedback) throws WvcmException {
        IVersionable itemToCatalog = versionToRestore.getWorkingCopy(feedback.nest(10));
        return this.doCreateVersionControlledResourceInternal(wsConn, newLocationHint.lastSegment(), itemToCatalog, deferCommit, feedback);
    }

    private JzRepoControllableResource doCreateVersionControlledResourceInternal(IWorkspaceConnection wsConn, String bindingName, IVersionable itemToCatalog, boolean deferCommit, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        IFolderHandle newParentHandle = (IFolderHandle)this.getItemHandle(feedback.nest(20));
        JzLocation newLocation = this.location().child(bindingName);
        itemToCatalog.setName(bindingName);
        itemToCatalog.setParent(newParentHandle);
        IWorkspaceConnection.ISaveOp saveOp = wsConn.configurationOpFactory().save(itemToCatalog);
        if (deferCommit) {
            JzRepoControllableFolder.deferOrCommitOperation(provider, newLocation, (IWorkspaceConnection.IConfigurationOp)saveOp, feedback);
        } else {
            this.commit((IWorkspaceConnection.IConfigurationOp)saveOp, newLocation, feedback);
        }
        return JzRepoControllableFolder.createFromVersionable(provider, newLocation, (IVersionableHandle)itemToCatalog);
    }

    public JzLocation doAddItem(String bindingName, IVersionable addMe, SrvcFeedback feedback) throws WvcmException {
        IFolderHandle parentHandle = (IFolderHandle)this.getItemHandle(feedback.nest(50));
        addMe.setName(bindingName);
        addMe.setParent(parentHandle);
        JzLocation resultLoc = this.location().child(bindingName);
        this.commit(addMe, resultLoc, feedback);
        return resultLoc;
    }

    public IVersionableHandle getVersionableHandle(String[] path, SrvcFeedback feedback) throws WvcmException {
        IVersionableHandle result = this.lookupVersionableHandle(path, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoControllableFolder_ERROR_PATHNAME_NOT_FOUND, (Object)JzProvider.myToString(JzProvider.FWDSLASH, path), (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public IVersionableHandle lookupVersionableHandle(String[] path, SrvcFeedback feedback) throws WvcmException {
        JzLocation myLoc = this.location();
        JzRepoWorkspace ws = this.getWvcmWorkspace(feedback.nest(10));
        JzRepoComponent comp = ws.lookupJzRepoComponent(myLoc.getComponentLocation(), feedback.nest(25));
        IVersionableHandle result = null;
        if (comp != null) {
            IFolderHandle rootFolderHandle = comp.getRootFolderHandle(feedback.nest(50));
            IConfiguration config = ws.ensureComponentInConfiguration(comp, feedback.nest(40));
            result = JzRepoControllableFolder.lookupVersionableHandles(this.provider(), rootFolderHandle, config, Collections.singletonList(path), feedback).get(0);
        }
        return result;
    }

    private static List<IVersionableHandle> lookupVersionableHandles(JzProvider provider, IFolderHandle rootFolderHandle, IConfiguration config, List<String[]> paths, SrvcFeedback feedback) throws WvcmException {
        ArrayList<IVersionableHandle> results = new ArrayList<IVersionableHandle>(paths.size());
        for (Object[] objectArray : paths) {
            IVersionableHandle result = null;
            try {
                result = config.resolvePath(rootFolderHandle, (String[])objectArray, JzProvider.getMonitor(feedback, 100));
            }
            catch (ItemNotFoundException e) {
                String msg = NLS.bind((String)Messages.JzRepoControllableFolder_ERROR_UNRESOLVED_PATHNAME, (Object[])objectArray, (Object[])new Object[0]);
                provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoControllable.lookupVersionableHandle", (Exception)((Object)e), msg);
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
            results.add(result);
        }
        return results;
    }

    public int findBigFolders(int threshold, List<JzRepoControllableFolder> results, SrvcFeedback feedback) throws WvcmException {
        int mySize = 0;
        List<JzRepoResource> members = this.computeChildList(feedback.nest(10));
        int memberCount = members.size();
        TreeMap<Integer, ArrayList<JzRepoControllableFolder>> memberMap = new TreeMap<Integer, ArrayList<JzRepoControllableFolder>>();
        int i = 0;
        for (JzRepoResource resource : members) {
            int subFolderMemberCount;
            ArrayList<JzRepoControllableFolder> chain;
            if (!(resource instanceof JzRepoControllableFolder) || resource instanceof JzRepoSymbolicLink) continue;
            JzRepoControllableFolder subFolder = (JzRepoControllableFolder)resource;
            if ((chain = (ArrayList<JzRepoControllableFolder>)memberMap.get(subFolderMemberCount = subFolder.findBigFolders(threshold, results, feedback.nest(SrvcUtils.LP((int)98, (int)i++, (int)memberCount, (int)15, (int)90))))) == null) {
                chain = new ArrayList<JzRepoControllableFolder>();
                memberMap.put(subFolderMemberCount, chain);
            }
            chain.add(subFolder);
            mySize += subFolderMemberCount;
        }
        mySize += memberCount;
        while (mySize >= threshold && !memberMap.isEmpty()) {
            Integer subFolderMemberCount = (Integer)memberMap.lastKey();
            List folders = (List)memberMap.remove(subFolderMemberCount);
            while (mySize >= threshold && !folders.isEmpty()) {
                results.add((JzRepoControllableFolder)((Object)folders.remove(0)));
                mySize -= 1 + subFolderMemberCount;
            }
        }
        return mySize;
    }

    public static List<Object> doCreateVersionControlledResources(JzProvider jzProvider, List<Location> newLocations, List<Location> genericVersionLocations, SrvcFeedback feedback) throws WvcmException {
        int verLocCount;
        int count = newLocations.size();
        if (count != (verLocCount = genericVersionLocations.size())) {
            throw new IllegalArgumentException(NLS.bind((String)"number of new locations {0} must equal number of version locations {1}", (Object)count, (Object[])new Object[]{verLocCount}));
        }
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<JzLocation> parentLocs = new ArrayList<JzLocation>(count);
        ArrayList<String> bindingNames = new ArrayList<String>(count);
        ArrayList<JzRepoRootVersion> rootVersionsToRestore = new ArrayList<JzRepoRootVersion>(count);
        JzLocation firstLocation = JzLocation.create(newLocations.get(0));
        JzLocation wsLoc = firstLocation.getWorkspaceLocation();
        JzLocation compLoc = firstLocation.getComponentLocation();
        int i = 0;
        while (i < count) {
            Location location = newLocations.get(i);
            JzLocation parentLocation = JzLocation.create(location.parent());
            JzLocation thisWsLoc = parentLocation.getWorkspaceLocation();
            JzLocation thisCompLoc = parentLocation.getComponentLocation();
            JzRepoControllableFolder.assertLocationsEqual("workspace", wsLoc, thisWsLoc);
            JzRepoControllableFolder.assertLocationsEqual("component", compLoc, thisCompLoc);
            parentLocs.add(parentLocation);
            bindingNames.add(location.lastSegment());
            JzLocation verLoc = JzLocation.create(genericVersionLocations.get(i));
            JzRepoResource resource = jzProvider.get((Location)verLoc, feedback);
            if (!(resource instanceof JzRepoRootVersion)) {
                throw new IllegalStateException("require a JzRepoRootVersion resource, but got something else from location: " + verLoc.string());
            }
            JzRepoRootVersion verToRestore = (JzRepoRootVersion)resource;
            JzLocation verCompLoc = verToRestore.getComponentLocation();
            JzRepoControllableFolder.assertLocationsEqual("component", compLoc, verCompLoc);
            rootVersionsToRestore.add(verToRestore);
            ++i;
        }
        ArrayList<Object> results = new ArrayList<Object>(count);
        JzRepoWorkspace ws = (JzRepoWorkspace)jzProvider.get((Location)wsLoc, feedback);
        JzRepoComponent comp = (JzRepoComponent)jzProvider.get((Location)compLoc, feedback);
        List<JzRepoControllableFolder> parents = JzRepoControllableFolder.batchLookupCRs(ws, comp, parentLocs, feedback);
        List<IVersionable> workingCopies = JzRepoRootVersion.getWorkingCopies(comp, rootVersionsToRestore, feedback);
        IWorkspaceConnection wsConn = ws.getConnection(feedback);
        int i2 = 0;
        while (i2 < count) {
            JzRepoControllableFolder parent = parents.get(i2);
            String bindingName = (String)bindingNames.get(i2);
            IVersionable itemToCatalogWorkingCopy = workingCopies.get(i2);
            JzRepoControllableResource result = parent.doCreateVersionControlledResourceInternal(wsConn, bindingName, itemToCatalogWorkingCopy, true, feedback);
            results.add((Object)result);
            ++i2;
        }
        return results;
    }

    private static List<JzRepoControllableFolder> batchLookupCRs(JzRepoWorkspace ws, JzRepoComponent comp, List<JzLocation> locations, SrvcFeedback feedback) throws WvcmException {
        int count = locations.size();
        ArrayList<JzRepoControllableFolder> results = new ArrayList<JzRepoControllableFolder>(count);
        IConfiguration config = ws.ensureComponentInConfiguration(comp, feedback);
        ArrayList<String[]> paths = new ArrayList<String[]>(count);
        for (JzLocation loc : locations) {
            paths.add(loc.getPath());
        }
        List<IVersionableHandle> handles = JzRepoControllableFolder.lookupVersionableHandles(ws.provider(), comp.getRootFolderHandle(feedback), config, paths, feedback);
        JzProvider provider = ws.provider();
        int i = 0;
        while (i < count) {
            JzLocation loc = locations.get(i);
            JzRepoControllableFolder cr = new JzRepoControllableFolder(provider, (Location)loc);
            IVersionableHandle h = handles.get(i);
            if (h != null) {
                IItemType actualItemType = h.getItemType();
                if (!IFolder.ITEM_TYPE.equals(actualItemType)) {
                    throw new IllegalStateException("expected IFolder itemType, but got: " + actualItemType.getName());
                }
                cr.setItemHandle((IItemHandle)h);
            }
            results.add(cr);
            ++i;
        }
        return results;
    }

    protected static void assertLocationsEqual(String kind, JzLocation wsLoc, JzLocation thisWsLoc) {
        if (!wsLoc.equals((Object)thisWsLoc)) {
            throw new IllegalArgumentException(NLS.bind((String)"all {0} locations must be equal. expected {1} actual {2}", (Object)kind, (Object[])new Object[]{wsLoc.toString(), thisWsLoc}));
        }
    }
}

