/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.advice.IItemsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.internal.client.ProcessClientService;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProcessItemSaveRunnable
extends ProcessRunnable {
    private ProcessClientService fProcessClient;
    protected IProcessItem fItemToSave;
    private IProcessItem fSavedItem;
    private boolean fRequestAdministrativeOverride;

    public static ProcessItemSaveRunnable newRunnable(IProcessItem item, ProcessClientService processClient, boolean requestAdministrativeOverride) {
        return new ProcessItemSaveRunnable(item, processClient, requestAdministrativeOverride);
    }

    public static ProcessItemSaveRunnable newRunnable(IProcessItem item, ProcessClientService processClient, boolean requestAdministrativeOverride, String operationId) {
        return new ProcessItemSaveRunnable(item, processClient, requestAdministrativeOverride, operationId);
    }

    private ProcessItemSaveRunnable(IProcessItem processItem, ProcessClientService context, boolean requestAdministrativeOverride) {
        this.fItemToSave = processItem;
        this.fProcessClient = context;
        this.fRequestAdministrativeOverride = requestAdministrativeOverride;
    }

    private ProcessItemSaveRunnable(IProcessItem processItem, ProcessClientService context, boolean requestAdministrativeOverride, String operationId) {
        super(operationId);
        this.fItemToSave = processItem;
        this.fProcessClient = context;
        this.fRequestAdministrativeOverride = requestAdministrativeOverride;
    }

    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
        IItemsResponse response = this.fProcessClient.doSaveProcessItem(this.fItemToSave, this.fRequestAdministrativeOverride, monitor);
        this.fSavedItem = (IProcessItem)response.getClientItems()[0];
        return response.getOperationReport();
    }

    public IProcessItem getSavedItem() {
        return this.fSavedItem;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProcessItemSaveRunnable) {
            return ((ProcessItemSaveRunnable)((Object)obj)).fItemToSave.sameItemId((IItemHandle)this.fItemToSave);
        }
        return false;
    }

    public int hashCode() {
        return this.fItemToSave.getItemId().hashCode();
    }

    public IProcessItem getItemToSave() {
        return this.fItemToSave;
    }
}

