/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.internal.client.workingcopies.ExecUtil;
import com.ibm.team.process.internal.client.workingcopies.Messages;
import com.ibm.team.process.internal.client.workingcopies.PropertyWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.ServerRequest;
import com.ibm.team.process.internal.client.workingcopies.SynchronizableDocument;
import com.ibm.team.process.internal.client.workingcopies.UpdateRequest;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public class ContentWorkingCopy
extends PropertyWorkingCopy {
    private final ITeamRepository fTeamRepository;
    private final String fStandardContentType;
    private final String fStandardEncoding;
    private String fContentType;
    private String fEncoding;
    private IContent fUnderlyingProperty;
    private IContent fUncommittedUnderlyingProperty;
    private final IDocumentListener fDirtyListener = new DirtyListener();
    private IDocument fDocument = new SynchronizableDocument(new Object());

    public ContentWorkingCopy(ITeamRepository teamRepository, String contentType, String encoding) {
        this.fTeamRepository = teamRepository;
        this.fStandardContentType = contentType;
        this.fStandardEncoding = encoding;
        this.fDocument.addDocumentListener(this.fDirtyListener);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    @Override
    public void dispose() {
        this.fDocument = null;
        this.fUnderlyingProperty = null;
        this.fUncommittedUnderlyingProperty = null;
        super.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.fDocument == null;
    }

    public void asyncUpdate(final IContent content, int flags, IUpdateContext context, IProgressMonitor monitor) {
        if (this.isDisposed()) {
            return;
        }
        if ((flags & 1) == 0 && this.equals(content, this.fUnderlyingProperty)) {
            return;
        }
        UpdateRequest request = new UpdateRequest(Messages.getString("ContentWorkingCopy.0")){

            @Override
            public IStatus execute(IUpdateContext context, IProgressMonitor monitor) {
                if (ContentWorkingCopy.this.isDisposed()) {
                    return Status.OK_STATUS;
                }
                try {
                    final String stringContent = ContentWorkingCopy.this.createStringFromContent(content, monitor);
                    final boolean isDirty = ContentWorkingCopy.this.isDirty();
                    ContentWorkingCopy.this.fUnderlyingProperty = content;
                    ContentWorkingCopy.this.fUncommittedUnderlyingProperty = null;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!ContentWorkingCopy.this.isDisposed() && ContentWorkingCopy.this.isDirty() == isDirty && !stringContent.equals(ContentWorkingCopy.this.fDocument.get())) {
                                ContentWorkingCopy.this.fDocument.removeDocumentListener(ContentWorkingCopy.this.fDirtyListener);
                                ContentWorkingCopy.this.fDocument.set(stringContent);
                                ContentWorkingCopy.this.fDocument.addDocumentListener(ContentWorkingCopy.this.fDirtyListener);
                            }
                        }
                    };
                    if (context != null) {
                        context.execute(runnable);
                    } else {
                        runnable.run();
                    }
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException x) {
                    if (ContentWorkingCopy.this.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "com.ibm.team.process.client", 0, this.getName(), (Throwable)x);
                }
            }
        };
        ExecUtil.asyncExec(request, context, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createStringFromContent(IContent content, IProgressMonitor monitor) throws TeamRepositoryException {
        String string;
        if (content == null) {
            this.fContentType = null;
            this.fEncoding = null;
            return "";
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.fTeamRepository.contentManager().retrieveContent(content, (OutputStream)stream, monitor);
        try {
            this.fContentType = content.getContentType();
            this.fEncoding = content.getCharacterEncoding();
            string = new String(stream.toByteArray(), this.fEncoding);
        }
        catch (UnsupportedEncodingException x) {
            try {
                this.fContentType = null;
                this.fEncoding = null;
                throw new TeamRepositoryException((Throwable)x);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    public IContent syncSave(IProgressMonitor monitor) throws TeamRepositoryException {
        final IContent[] content = new IContent[1];
        ServerRequest saveRequest = new ServerRequest(Messages.getString("ContentWorkingCopy.2")){

            @Override
            public void execute(IProgressMonitor monitor) throws TeamRepositoryException {
                IDocument document = ContentWorkingCopy.this.fDocument;
                if (document != null) {
                    IContentManager manager = ContentWorkingCopy.this.fTeamRepository.contentManager();
                    String stringContent = document.get();
                    try {
                        if (stringContent != null && stringContent.length() > 0) {
                            UUID predecessorUUID = null;
                            if (ContentWorkingCopy.this.fUnderlyingProperty != null) {
                                predecessorUUID = ContentWorkingCopy.this.fUnderlyingProperty.getContentId();
                            }
                            content[0] = manager.storeContent(ContentWorkingCopy.this.getContentType(), ContentWorkingCopy.this.getEncoding(), LineDelimiter.LINE_DELIMITER_NONE, (InputStream)new ByteArrayInputStream(stringContent.getBytes(ContentWorkingCopy.this.getEncoding())), predecessorUUID, monitor);
                        }
                    }
                    catch (UnsupportedEncodingException x) {
                        throw new TeamRepositoryException((Throwable)x);
                    }
                }
            }
        };
        ExecUtil.syncExec(saveRequest, monitor);
        this.fUncommittedUnderlyingProperty = content[0];
        return content[0];
    }

    private String getContentType() {
        if (this.fContentType != null) {
            return this.fContentType;
        }
        return this.fStandardContentType;
    }

    private String getEncoding() {
        if (this.fEncoding != null) {
            return this.fEncoding;
        }
        return this.fStandardEncoding;
    }

    @Override
    protected void updateUnderlyingPropertyState() {
        this.fUnderlyingProperty = this.fUncommittedUnderlyingProperty;
        this.fUncommittedUnderlyingProperty = null;
    }

    private boolean equals(IContent left, IContent right) {
        if (left == null && right == null) {
            return true;
        }
        if (left != null && right == null) {
            return false;
        }
        if (left == null && right != null) {
            return false;
        }
        if (left != null && right != null) {
            return left.getContentId().equals((Object)right.getContentId());
        }
        return false;
    }

    private class DirtyListener
    implements IDocumentListener {
        private DirtyListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            ContentWorkingCopy.this.setDirty(true, true);
        }
    }
}

