/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.ArtifactToken;
import com.ibm.team.fulltext.common.TokenizerTypes;
import com.ibm.team.fulltext.common.internal.StandardTokenTypes;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttribute;
import com.ibm.team.fulltext.common.internal.analysis.SplitTokenFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.eclipse.core.runtime.Assert;

public final class CamelCaseFilter
extends SplitTokenFilter {
    private final boolean fExpandTokens;

    public CamelCaseFilter(TokenStream stream, boolean expandTokens) {
        super(stream);
        this.fExpandTokens = expandTokens;
    }

    @Override
    protected void splitToken(ArtifactAttribute token) {
        if (token.isArtifact() && !token.applies(TokenizerTypes.EXPAND_CAMELCASE)) {
            this.addToQueue(token);
            return;
        }
        String termText = token.term();
        int length = termText.length();
        String caps = this.getCaps(termText);
        if (caps != null && caps.length() > 1) {
            ArtifactToken camelCaseToken = this.internalCreateToken(termText, token, 1, StandardTokenTypes.CAMELCASE, null);
            this.addToQueue((TermAttribute)camelCaseToken);
            if (!caps.equals(termText) && this.fExpandTokens) {
                this.addToQueue((TermAttribute)this.createReplacement(caps, token, StandardTokenTypes.ACRONYM, camelCaseToken));
                int offset = 0;
                while (offset < length) {
                    Run run = this.consumeRun(termText, offset);
                    if (run.length != 0) {
                        String camelCaseRun = termText.substring(offset, offset + run.length);
                        if (!termText.equals(camelCaseRun)) {
                            this.addToQueue((TermAttribute)this.createReplacement(camelCaseRun, token, StandardTokenTypes.CAMELCASE_PART, camelCaseToken));
                        }
                        offset += run.length;
                        continue;
                    }
                    break;
                }
            }
        } else {
            this.addToQueue(token);
        }
    }

    private Run consumeRun(String text, int offset) {
        char ch = text.charAt(offset);
        int length = text.length();
        CamelCaseIdentifier run = new CamelCaseIdentifier();
        ((Run)run).init();
        while (((Run)run).consume(ch) && offset < length - 1) {
            ch = text.charAt(++offset);
        }
        return run;
    }

    private String getCaps(String text) {
        if (text.length() == 0 || !Character.isUpperCase(text.charAt(0))) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                return null;
            }
            if (Character.isUpperCase(ch) || Character.isDigit(ch)) {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    private Token createReplacement(String termText, ArtifactAttribute token, StandardTokenTypes type, Token createdFrom) {
        return this.internalCreateToken(termText, token, 0, type, createdFrom);
    }

    private ArtifactToken internalCreateToken(String termText, ArtifactAttribute token, int increment, StandardTokenTypes type, Token createdFrom) {
        if (termText == null) {
            return null;
        }
        ArtifactToken newToken = new ArtifactToken(termText, token.startOffset(), token.endOffset(), type.getId(), createdFrom);
        newToken.setPositionIncrement(increment);
        return newToken;
    }

    static final class CamelCaseIdentifier
    extends Run {
        private static final int S_INIT = 0;
        private static final int S_LOWER = 1;
        private static final int S_ONE_CAP = 2;
        private static final int S_ALL_CAPS = 3;
        private static final int S_EXIT = 4;
        private static final int S_EXIT_MINUS_ONE = 5;
        private static final int K_INVALID = 0;
        private static final int K_LOWER = 1;
        private static final int K_UPPER = 2;
        private static final int K_OTHER = 3;
        private int fState;
        private static final int[][] MATRIX = new int[][]{{4, 1, 2, 1}, {4, 1, 4, 1}, {4, 1, 3, 1}, {4, 5, 3, 1}};

        CamelCaseIdentifier() {
        }

        @Override
        protected void init() {
            super.init();
            this.fState = 0;
        }

        @Override
        protected boolean consume(char ch) {
            int kind = this.getKind(ch);
            this.fState = MATRIX[this.fState][kind];
            switch (this.fState) {
                case 1: 
                case 2: 
                case 3: {
                    ++this.length;
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    --this.length;
                    return false;
                }
            }
            Assert.isTrue((boolean)false);
            return false;
        }

        private int getKind(char ch) {
            if (Character.isUpperCase(ch)) {
                return 2;
            }
            if (Character.isLowerCase(ch)) {
                return 1;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                return 3;
            }
            return 0;
        }

        @Override
        protected boolean isValid(char ch) {
            return Character.isJavaIdentifierPart(ch);
        }
    }

    protected static abstract class Run {
        protected int length;

        public Run() {
            this.init();
        }

        protected boolean consume(char ch) {
            if (this.isValid(ch)) {
                ++this.length;
                return true;
            }
            return false;
        }

        protected abstract boolean isValid(char var1);

        protected void init() {
            this.length = 0;
        }
    }
}

