/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.service;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.common.model.IInformationArtifact;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.IOException;
import java.util.Collection;
import java.util.zip.ZipOutputStream;

public interface IFullTextService {
    public void index(Collection<IInformationArtifact> var1, boolean var2) throws TeamRepositoryException;

    public void delete(URIReference var1, URIReference var2) throws TeamRepositoryException;

    public IScoredResult[] find(String var1, String[] var2, String var3, UUID[] var4) throws TeamRepositoryException;

    public IScoredResult[] findRelatedByReference(String var1, String var2) throws TeamRepositoryException;

    public IScoredResult[] findRelated(String var1, String var2) throws TeamRepositoryException;

    public IScoredResult[] findDuplicateByReference(String var1, String var2, String var3, String var4, String[] var5, UUID[] var6) throws TeamRepositoryException;

    public IScoredResult[] findDuplicate(String var1, String var2, String var3, String[] var4, UUID[] var5) throws TeamRepositoryException;

    public IScoredResult[] search(SearchOptions var1) throws TeamRepositoryException;

    public void updateIndex() throws TeamRepositoryException;

    public void backup(ZipOutputStream var1) throws IOException;

    public String getIndexLocation();

    public String getFullIndexName();

    public static class SearchOptions {
        public SearchType searchType = SearchType.FIND;
        public String name;
        public String content;
        public String language;
        public String[] searchScope;
        public String constrainType;
        public UUID[] owners;
        public String type;
        public String id;
    }

    public static enum SearchType {
        FIND,
        FIND_DUPLICATE,
        FIND_DUPLICATE_BY_REFERENCE,
        FIND_RELATED,
        FIND_RELATED_BY_REFERENCE;

    }
}

