/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyMethodsSupport;

public class ProcessGroovyMethods
extends DefaultGroovyMethodsSupport {
    public static InputStream getIn(Process self) {
        return self.getInputStream();
    }

    public static String getText(Process self) throws IOException {
        return DefaultGroovyMethods.getText(new BufferedReader(new InputStreamReader(self.getInputStream())));
    }

    public static InputStream getErr(Process self) {
        return self.getErrorStream();
    }

    public static OutputStream getOut(Process self) {
        return self.getOutputStream();
    }

    public static Writer leftShift(Process self, Object value) throws IOException {
        return DefaultGroovyMethods.leftShift(self.getOutputStream(), value);
    }

    public static OutputStream leftShift(Process self, byte[] value) throws IOException {
        return DefaultGroovyMethods.leftShift(self.getOutputStream(), value);
    }

    public static void waitForOrKill(Process self, long numberOfMillis) {
        ProcessRunner runnable = new ProcessRunner(self);
        Thread thread = new Thread(runnable);
        thread.start();
        runnable.waitForOrKill(numberOfMillis);
    }

    public static void consumeProcessOutput(Process self) {
        ProcessGroovyMethods.consumeProcessOutput(self, (OutputStream)null, (OutputStream)null);
    }

    public static void consumeProcessOutput(Process self, Appendable output, Appendable error) {
        ProcessGroovyMethods.consumeProcessOutputStream(self, output);
        ProcessGroovyMethods.consumeProcessErrorStream(self, error);
    }

    public static void consumeProcessOutput(Process self, OutputStream output, OutputStream error) {
        ProcessGroovyMethods.consumeProcessOutputStream(self, output);
        ProcessGroovyMethods.consumeProcessErrorStream(self, error);
    }

    public static void waitForProcessOutput(Process self) {
        ProcessGroovyMethods.waitForProcessOutput(self, (OutputStream)null, (OutputStream)null);
    }

    public static void waitForProcessOutput(Process self, Appendable output, Appendable error) {
        Thread tout = ProcessGroovyMethods.consumeProcessOutputStream(self, output);
        Thread terr = ProcessGroovyMethods.consumeProcessErrorStream(self, error);
        try {
            tout.join();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        try {
            terr.join();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        try {
            self.waitFor();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        try {
            self.getErrorStream().close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            self.getInputStream().close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    public static void waitForProcessOutput(Process self, OutputStream output, OutputStream error) {
        Thread tout = ProcessGroovyMethods.consumeProcessOutputStream(self, output);
        Thread terr = ProcessGroovyMethods.consumeProcessErrorStream(self, error);
        try {
            tout.join();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        try {
            terr.join();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        try {
            self.waitFor();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        try {
            self.getErrorStream().close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            self.getInputStream().close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    public static Thread consumeProcessErrorStream(Process self, OutputStream err) {
        Thread thread = new Thread(new ByteDumper(self.getErrorStream(), err));
        thread.start();
        return thread;
    }

    public static Thread consumeProcessErrorStream(Process self, Appendable error) {
        Thread thread = new Thread(new TextDumper(self.getErrorStream(), error));
        thread.start();
        return thread;
    }

    public static Thread consumeProcessOutputStream(Process self, Appendable output) {
        Thread thread = new Thread(new TextDumper(self.getInputStream(), output));
        thread.start();
        return thread;
    }

    public static Thread consumeProcessOutputStream(Process self, OutputStream output) {
        Thread thread = new Thread(new ByteDumper(self.getInputStream(), output));
        thread.start();
        return thread;
    }

    public static void withWriter(final Process self, final Closure closure) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    DefaultGroovyMethods.withWriter(new BufferedOutputStream(ProcessGroovyMethods.getOut(self)), closure);
                }
                catch (IOException e) {
                    throw new GroovyRuntimeException("exception while reading process stream", e);
                }
            }
        }).start();
    }

    public static void withOutputStream(final Process self, final Closure closure) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    DefaultGroovyMethods.withStream(new BufferedOutputStream(ProcessGroovyMethods.getOut(self)), closure);
                }
                catch (IOException e) {
                    throw new GroovyRuntimeException("exception while reading process stream", e);
                }
            }
        }).start();
    }

    public static Process pipeTo(final Process left, final Process right) throws IOException {
        new Thread(new Runnable(){

            public void run() {
                BufferedInputStream in = new BufferedInputStream(ProcessGroovyMethods.getIn(left));
                BufferedOutputStream out = new BufferedOutputStream(ProcessGroovyMethods.getOut(right));
                byte[] buf = new byte[8192];
                try {
                    int next;
                    while ((next = ((InputStream)in).read(buf)) != -1) {
                        ((OutputStream)out).write(buf, 0, next);
                    }
                }
                catch (IOException e) {
                    throw new GroovyRuntimeException("exception while reading process stream", e);
                }
                finally {
                    DefaultGroovyMethodsSupport.closeWithWarning(out);
                }
            }
        }).start();
        return right;
    }

    public static Process or(Process left, Process right) throws IOException {
        return ProcessGroovyMethods.pipeTo(left, right);
    }

    private static class ByteDumper
    implements Runnable {
        InputStream in;
        OutputStream out;

        public ByteDumper(InputStream in, OutputStream out) {
            this.in = new BufferedInputStream(in);
            this.out = out;
        }

        public void run() {
            byte[] buf = new byte[8192];
            try {
                int next;
                while ((next = this.in.read(buf)) != -1) {
                    if (this.out == null) continue;
                    this.out.write(buf, 0, next);
                }
            }
            catch (IOException e) {
                throw new GroovyRuntimeException("exception while dumping process stream", e);
            }
        }
    }

    private static class TextDumper
    implements Runnable {
        InputStream in;
        Appendable app;

        public TextDumper(InputStream in, Appendable app) {
            this.in = in;
            this.app = app;
        }

        public void run() {
            InputStreamReader isr = new InputStreamReader(this.in);
            BufferedReader br = new BufferedReader(isr);
            try {
                String next;
                while ((next = br.readLine()) != null) {
                    if (this.app == null) continue;
                    this.app.append(next);
                    this.app.append("\n");
                }
            }
            catch (IOException e) {
                throw new GroovyRuntimeException("exception while reading process stream", e);
            }
        }
    }

    protected static class ProcessRunner
    implements Runnable {
        Process process;
        private boolean finished;

        public ProcessRunner(Process process) {
            this.process = process;
        }

        private void doProcessWait() {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.doProcessWait();
            ProcessRunner processRunner = this;
            synchronized (processRunner) {
                this.notifyAll();
                this.finished = true;
            }
        }

        public synchronized void waitForOrKill(long millis) {
            if (!this.finished) {
                try {
                    this.wait(millis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.finished) {
                    this.process.destroy();
                    this.doProcessWait();
                }
            }
        }
    }
}

