/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common;

import com.ibm.team.calm.foundation.common.ContentType;
import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.IResponseContent;
import com.ibm.team.calm.foundation.common.Namespaces;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.internal.StreamUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLHelper
implements IResponseContent {
    public static final String EMPTY = "";
    public static final Attributes NO_ATTRIBUTES = new AttributesImpl();
    private static final int EXPECTED_SIZE = 8192;
    private ByteArrayOutputStream fOutputStream;
    private String fDefaultNamespace;
    private final Set<String> fUsedNamespaces = new HashSet<String>();
    private final ContentType fContentType;
    private final Charset fCharset;
    private final List<Object> fRecords;
    private CustomNamespaceContext fNamespaceContext;
    private static final String EMPTY_STRING = new String();

    public XMLHelper(ContentType contentType, Charset charset) {
        this.fContentType = contentType;
        this.fCharset = charset;
        this.fOutputStream = null;
        this.fRecords = new ArrayList<Object>();
        this.fNamespaceContext = Namespaces.createDefaultContext();
    }

    public XMLHelper(ContentType contentType, Charset charset, CustomNamespaceContext namespaceContext) {
        this(contentType, charset);
        this.fNamespaceContext = namespaceContext;
    }

    public void setDefaultNamespaceURI(String nsUri) {
        this.fDefaultNamespace = nsUri;
    }

    public XMLHelper startDocument() {
        return this;
    }

    public XMLHelper endDocument() {
        return this;
    }

    protected XMLHelper startElement(String nsUri, String localName, String qName, Attributes attributes) {
        this.fRecords.add(new Record(true, nsUri, localName, qName, attributes));
        return this;
    }

    protected XMLHelper endElement(String nsUri, String localName, String qName) {
        this.fRecords.add(new Record(false, nsUri, localName, qName, null));
        return this;
    }

    public XMLHelper startElement(String element, Attributes attributes) {
        return this.startElement(EMPTY, EMPTY, element, attributes);
    }

    public XMLHelper startElement(String element) {
        return this.startElement(element, NO_ATTRIBUTES);
    }

    public XMLHelper startElement(Property property) {
        return this.startElement(property.getNamespaceURI(), property.getName());
    }

    public XMLHelper startElement(String nsUri, String element) {
        return this.startElement(nsUri, element, NO_ATTRIBUTES);
    }

    public XMLHelper startElement(Property property, Attributes attributes) {
        return this.startElement(property.getNamespaceURI(), property.getName(), attributes);
    }

    public XMLHelper startElement(String nsUri, String element, Attributes attributes) {
        if (nsUri == null) {
            this.startElement(element, attributes);
            return this;
        }
        this.fUsedNamespaces.add(nsUri);
        String qName = this.qualify(nsUri, element);
        this.fRecords.add(new Record(true, nsUri, element, qName, attributes));
        return this;
    }

    public XMLHelper element(Property property, Attributes attributes) {
        return this.element(property.getNamespaceURI(), property.getName(), attributes);
    }

    public XMLHelper element(String nsUri, String element, Attributes attributes) {
        this.fUsedNamespaces.add(nsUri);
        String qName = this.qualify(nsUri, element);
        this.startElement(nsUri, element, qName, attributes);
        this.endElement(nsUri, element, qName);
        return this;
    }

    public XMLHelper textElement(Property property, String text) {
        return this.textElement(property.getNamespaceURI(), property.getName(), text);
    }

    public XMLHelper textElement(String nsUri, String element, String text) {
        return this.textElement(nsUri, element, null, text);
    }

    public XMLHelper textElement(Property property, Attributes attributes, String text) {
        return this.textElement(property.getNamespaceURI(), property.getName(), attributes, text);
    }

    public XMLHelper textElement(String nsUri, String element, Attributes attributes, String text) {
        this.fUsedNamespaces.add(nsUri);
        String qName = this.qualify(nsUri, element);
        this.startElement(nsUri, element, qName, attributes);
        this.characters(text);
        this.endElement(nsUri, element, qName);
        return this;
    }

    public XMLHelper endElement(String element) {
        return this.endElement(EMPTY, EMPTY, element);
    }

    public XMLHelper endElement(Property property) {
        return this.endElement(property.getNamespaceURI(), property.getName());
    }

    public XMLHelper endElement(String nsUri, String element) {
        if (nsUri == null) {
            this.endElement(element);
            return this;
        }
        String qName = this.qualify(nsUri, element);
        this.endElement(nsUri, element, qName);
        return this;
    }

    public XMLHelper characters(String value) {
        if (value != null) {
            this.fRecords.add(value);
        }
        return this;
    }

    public AttributesImpl createAttribute(Property property, String value) {
        return this.createAttribute(property.getNamespaceURI(), property.getName(), value);
    }

    public AttributesImpl createAttribute(String nsUri, String name, String value) {
        AttributesImpl attributes = new AttributesImpl();
        this.addAttribute(attributes, nsUri, name, value);
        return attributes;
    }

    public AttributesImpl createAttribute(String name, String value) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, EMPTY, name, EMPTY, value);
        return attributes;
    }

    public void addAttribute(AttributesImpl attributes, Property property, String value) {
        this.addAttribute(attributes, property.getNamespaceURI(), property.getName(), value);
    }

    public void addAttribute(AttributesImpl attributes, String nsUri, String name, String value) {
        this.fUsedNamespaces.add(nsUri);
        String qName = this.qualify(nsUri, name);
        attributes.addAttribute(nsUri, name, qName, EMPTY, value);
    }

    public void addAttribute(AttributesImpl attributes, String name, String value) {
        attributes.addAttribute(EMPTY, EMPTY, name, EMPTY, value);
    }

    @Override
    public Charset getCharset() {
        return this.fCharset;
    }

    @Override
    public ContentType getContentType() {
        return this.fContentType;
    }

    private ByteArrayOutputStream getOutputStream() throws TransformerConfigurationException, SAXException {
        if (this.fOutputStream == null) {
            this.fOutputStream = new ByteArrayOutputStream(8192);
            BufferedOutputStream buffered = new BufferedOutputStream(this.fOutputStream);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buffered, this.fCharset);
            StreamResult result = new StreamResult(writer);
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = factory.newTransformerHandler();
            Transformer transformer = handler.getTransformer();
            transformer.setOutputProperty("encoding", this.fCharset.name());
            transformer.setOutputProperty("indent", "yes");
            handler.setResult(result);
            handler.startDocument();
            if (this.fDefaultNamespace != null) {
                handler.startPrefixMapping(EMPTY, this.fDefaultNamespace);
            }
            for (String nsUri : this.fUsedNamespaces) {
                String prefix = this.fNamespaceContext.getPrefix(nsUri);
                handler.startPrefixMapping(prefix, nsUri);
            }
            for (Object entry : this.fRecords) {
                if (entry instanceof Record) {
                    Record data = (Record)entry;
                    if (data.isAdd()) {
                        handler.startElement(data.getNsUri(), data.getLocalName(), data.getQName(), data.getAttributes());
                        continue;
                    }
                    handler.endElement(data.getNsUri(), data.getLocalName(), data.getQName());
                    continue;
                }
                String value = XMLHelper.sanitizeXmlString((String)entry);
                handler.characters(value.toCharArray(), 0, value.length());
            }
            handler.endDocument();
            StreamUtils.silentClose(writer);
        }
        return this.fOutputStream;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (!this.fRecords.isEmpty()) {
            try {
                this.getOutputStream().writeTo(outputStream);
            }
            catch (TransformerConfigurationException e) {
                throw new IOException(e.getMessage());
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public String getString() throws XMLSerializeException {
        try {
            return this.getOutputStream().toString(this.fCharset.toString());
        }
        catch (TransformerConfigurationException e) {
            throw new XMLSerializeException(e);
        }
        catch (SAXException e) {
            throw new XMLSerializeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLSerializeException(e);
        }
    }

    private String qualify(String nsUri, String localName) {
        if (nsUri.equals(this.fDefaultNamespace)) {
            return localName;
        }
        return this.fNamespaceContext.qualify(nsUri, localName);
    }

    public void declareNS(String ... nsUris) {
        String[] stringArray = nsUris;
        int n = nsUris.length;
        int n2 = 0;
        while (n2 < n) {
            String nsUri = stringArray[n2];
            this.fUsedNamespaces.add(nsUri);
            ++n2;
        }
    }

    public static String sanitizeXmlString(String xmlString) {
        if (xmlString == null || xmlString.isEmpty()) {
            return xmlString;
        }
        StringBuffer buffer = new StringBuffer();
        XmlCharacterRule xmlCharacterRule = new XmlCharacterRule();
        int i = 0;
        while (i < xmlString.length()) {
            char ch = xmlString.charAt(i);
            String replacement = xmlCharacterRule.replacement(ch);
            if (replacement != null) {
                buffer.append(replacement);
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    private static class Record {
        private final boolean fIdAdd;
        private final String fNsUri;
        private final String fLocalName;
        private final String fQName;
        private final Attributes fAttributes;

        public Record(boolean idAdd, String nsUri, String localName, String qName, Attributes attributes) {
            this.fIdAdd = idAdd;
            this.fNsUri = nsUri;
            this.fLocalName = localName;
            this.fQName = qName;
            this.fAttributes = attributes;
        }

        public boolean isAdd() {
            return this.fIdAdd;
        }

        public String getNsUri() {
            return this.fNsUri;
        }

        public String getLocalName() {
            return this.fLocalName;
        }

        public String getQName() {
            return this.fQName;
        }

        public Attributes getAttributes() {
            return this.fAttributes;
        }
    }

    public static class XMLSerializeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public XMLSerializeException(Exception e) {
            super(e);
        }

        public XMLSerializeException(String message) {
            super(message);
        }
    }

    public static class XmlCharacterRule {
        public String replacement(int ch) {
            if (ch == 0) {
                return EMPTY_STRING;
            }
            if (ch < 65536) {
                if (ch < 160) {
                    if (this.inRange(ch, 1, 8)) {
                        return EMPTY_STRING;
                    }
                    if (this.inRange(ch, 11, 12)) {
                        return EMPTY_STRING;
                    }
                    if (this.inRange(ch, 14, 31)) {
                        return EMPTY_STRING;
                    }
                    if (this.inRange(ch, 127, 132)) {
                        return EMPTY_STRING;
                    }
                    if (this.inRange(ch, 134, 159)) {
                        return EMPTY_STRING;
                    }
                } else if (this.inRange(ch, 64976, 64991)) {
                    return EMPTY_STRING;
                }
            } else if (ch <= 0x10FFFF && ((ch & 0xFFFE) == 65534 || (ch & 0xFFFF) == 65535 && ch >> 16 <= 16)) {
                return EMPTY_STRING;
            }
            return null;
        }

        private boolean inRange(int value, int min, int max) {
            return min <= value && value <= max;
        }
    }
}

