/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.dto;

import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.ConfigurationHandle;
import com.ibm.team.scm.common.internal.dto.ConfigurationProvider;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;

public interface ServiceConfigurationProvider {
    public static final IConfigurationProviderFactory FACTORY = new IConfigurationProviderFactory(){

        @Override
        public ServiceConfigurationProvider create(IWorkspaceHandle ws, IComponentHandle c) {
            if (ws == null || c == null) {
                throw new IllegalArgumentException();
            }
            ConfigurationProvider p = ScmDtoFactory.eINSTANCE.createConfigurationProvider();
            p.setWorkspaceComponentPair(ScmDtoFactory.eINSTANCE.createWorkspaceComponentPair());
            p.getWorkspaceComponentPair().setWorkspace(ws);
            p.getWorkspaceComponentPair().setComponent(c);
            return p;
        }

        @Override
        public ServiceConfigurationProvider create(IBaselineHandle bh) {
            if (bh == null) {
                throw new IllegalArgumentException();
            }
            ConfigurationProvider p = ScmDtoFactory.eINSTANCE.createConfigurationProvider();
            p.setBaseline(bh);
            return p;
        }

        @Override
        public ServiceConfigurationProvider create(ChangeHistoryHandle chh) {
            if (chh == null) {
                throw new IllegalArgumentException();
            }
            ConfigurationProvider p = ScmDtoFactory.eINSTANCE.createConfigurationProvider();
            p.setChangeHistory(chh);
            return p;
        }

        @Override
        public ServiceConfigurationProvider create(ConfigurationHandle ch) {
            if (ch == null) {
                throw new IllegalArgumentException();
            }
            ConfigurationProvider p = ScmDtoFactory.eINSTANCE.createConfigurationProvider();
            p.setConfiguration(ch);
            return p;
        }
    };

    public static interface IConfigurationProviderFactory {
        public ServiceConfigurationProvider create(IWorkspaceHandle var1, IComponentHandle var2);

        public ServiceConfigurationProvider create(IBaselineHandle var1);

        public ServiceConfigurationProvider create(ChangeHistoryHandle var1);

        public ServiceConfigurationProvider create(ConfigurationHandle var1);
    }
}

