/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.process;

import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Iterator;

public class ConvertingIterator<SourceType, TargetType>
implements Iterator<TargetType> {
    private final Iterator<SourceType> source;
    private final Converter<SourceType, TargetType> converter;

    public ConvertingIterator(Iterator<SourceType> source, Converter<SourceType, TargetType> converter) {
        this.source = source;
        this.converter = converter;
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public TargetType next() {
        try {
            return this.converter.convert(this.source.next());
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        this.source.remove();
    }

    public static interface Converter<Src, Tgt> {
        public Tgt convert(Src var1) throws TeamRepositoryException;
    }
}

