/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.process;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.ConfigUtil;
import com.ibm.team.scm.common.internal.dto.CommitParameter;
import com.ibm.team.scm.common.internal.dto.ICommitParameter;
import com.ibm.team.scm.common.process.ProcessProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DeliverOperationData {
    private final IWorkspace fSourceWorkspace;
    private final IWorkspace fDestWorkspace;
    private final List<IBaselineHandle> fBaselines;
    private final List<IChangeSetHandle> fChangeSets;
    private final ICommitParameter fUpdateCommitParm;
    private final String fUpdateChangeSetComment;
    private final ProcessProxy proxy;

    public DeliverOperationData(ProcessProxy proxy, IWorkspace sourceWorkspace, IWorkspace destWorkspace, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSetHandles, ICommitParameter parm, String updateChangeSetComment) {
        this.proxy = proxy;
        this.fSourceWorkspace = sourceWorkspace;
        this.fDestWorkspace = destWorkspace;
        this.fBaselines = baselines;
        this.fChangeSets = changeSetHandles;
        this.fUpdateChangeSetComment = updateChangeSetComment;
        this.fUpdateCommitParm = parm;
    }

    public DeliverOperationData(ProcessProxy proxy, IWorkspace sourceWorkspace, IWorkspace destWorkspace, IBaselineHandle[] baselines, IChangeSetHandle[] changeSetHandles) {
        this(proxy, sourceWorkspace, destWorkspace, new ArrayList<IBaselineHandle>(Arrays.asList(baselines)), new ArrayList<IChangeSetHandle>(Arrays.asList(changeSetHandles)), null, null);
    }

    public DeliverOperationData(ProcessProxy proxy, IWorkspace sourceWorkspace, IWorkspace destWorkspace, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSetHandles) {
        this(proxy, sourceWorkspace, destWorkspace, baselines, changeSetHandles, null, null);
    }

    public List<IBaselineHandle> getBaselines() {
        return this.fBaselines;
    }

    public List<IChangeSetHandle> getChangeSetHandles() {
        return this.fChangeSets;
    }

    public IWorkspace getDestWorkspace() {
        return this.fDestWorkspace;
    }

    public IWorkspace getSourceWorkspace() {
        return this.fSourceWorkspace;
    }

    public ProcessProxy getProcessProxy() {
        return this.proxy;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DeliverOperationData) {
            DeliverOperationData other = (DeliverOperationData)object;
            return this.equalsCheckNull(this.fSourceWorkspace, other.getSourceWorkspace()) && this.fDestWorkspace.sameItemId((IItemHandle)other.getDestWorkspace()) && this.equalItemLists(this.fChangeSets, other.getChangeSetHandles()) && this.equalItemLists(this.fBaselines, other.getBaselines()) && this.equalCheckNull(this.fUpdateCommitParm, other.getAtomicUpdateParm()) && this.equalCheckNull(this.fUpdateChangeSetComment, other.getAtomicUpdateComment());
        }
        return false;
    }

    private boolean equalsCheckNull(IWorkspace s1, IWorkspace s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.sameItemId((IItemHandle)s2);
    }

    private boolean equalCheckNull(String c1, String c2) {
        if (c1 == null) {
            return c2 == null;
        }
        return c1.equals(c2);
    }

    private boolean equalCheckNull(ICommitParameter c1, ICommitParameter c2) {
        if (c1 == null) {
            return c2 == null;
        }
        CommitParameter cc1 = (CommitParameter)c1;
        CommitParameter cc2 = (CommitParameter)c2;
        return ConfigUtil.getItemIds(cc1.getFoldersToDeleteSubtree()).equals(ConfigUtil.getItemIds(cc2.getFoldersToDeleteSubtree())) && ConfigUtil.getItemIds(cc1.getItemsToDelete()).equals(ConfigUtil.getItemIds(cc2.getItemsToDelete())) && ConfigUtil.getItemIds(cc1.getItemsToMarkAsMerged()).equals(ConfigUtil.getItemIds(cc2.getItemsToMarkAsMerged())) && ConfigUtil.getItemIds(cc1.getItemsToRevert()).equals(ConfigUtil.getItemIds(cc2.getItemsToRevert())) && ConfigUtil.getItemIds(cc1.getItemsToSave()).equals(ConfigUtil.getItemIds(cc2.getItemsToSave())) && ConfigUtil.getItemIds(cc1.getItemsToUndo()).equals(ConfigUtil.getItemIds(cc2.getItemsToUndo()));
    }

    public ICommitParameter getAtomicUpdateParm() {
        return this.fUpdateCommitParm;
    }

    public String getAtomicUpdateComment() {
        return this.fUpdateChangeSetComment;
    }

    private boolean equalItemLists(List listA, List listB) {
        if (listA.size() == listB.size()) {
            Iterator iterA = listA.iterator();
            Iterator iterB = listB.iterator();
            while (iterA.hasNext() && iterB.hasNext()) {
                IItemHandle handleB;
                IItemHandle handleA = (IItemHandle)iterA.next();
                if (handleA == (handleB = (IItemHandle)iterB.next()) || handleA != null && handleB != null && handleA.sameItemId(handleB)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

