/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IPrivateScope;
import com.ibm.team.scm.common.dto.IProcessAreaScope;
import com.ibm.team.scm.common.dto.IPublicScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.ITeamAreaPrivateScope;
import com.ibm.team.scm.common.internal.dto.PrivateScope;
import com.ibm.team.scm.common.internal.dto.ProcessAreaScope;
import com.ibm.team.scm.common.internal.dto.PublicScope;
import com.ibm.team.scm.common.internal.dto.TeamAreaPrivateScope;

public abstract class ReadScopeUtils {
    public static final UUID CUSTOM_PRIVATE = UUID.valueOf((String)"_p57xQODvEd2JvqtXLuqiiw");
    public static final UUID CUSTOM_PUBLIC = null;

    private static IAuditableHandle computeProcessAreaScope(UUID customContext) {
        if (customContext == null) {
            return null;
        }
        if (customContext.equals((Object)CUSTOM_PRIVATE)) {
            return null;
        }
        return (IAuditableHandle)IProjectArea.ITEM_TYPE.createItemHandle(customContext, null);
    }

    public static IReadScope computeReadScope(IAuditableHandle owner, int readPermissionMode, UUID context) {
        switch (readPermissionMode) {
            case 0: {
                if (owner instanceof IContributorHandle) {
                    if (context == null) {
                        PublicScope pub = (PublicScope)IReadScope.FACTORY.createPublicScope();
                        pub.setOwner(owner);
                        return pub;
                    }
                    if (CUSTOM_PRIVATE.equals((Object)context)) {
                        PrivateScope pri = (PrivateScope)IReadScope.FACTORY.createPrivateScope();
                        pri.setOwner(owner);
                        return pri;
                    }
                    IAuditableHandle item = ReadScopeUtils.computeProcessAreaScope(context);
                    if (item == null) {
                        return IReadScope.FACTORY.createUnknownScope();
                    }
                    IContributorDeferringScope cds = IReadScope.FACTORY.createContributorDeferringScope();
                    cds.setScope(item);
                    return cds;
                }
                if (owner instanceof IProcessAreaHandle) {
                    ProcessAreaScope pas = (ProcessAreaScope)IReadScope.FACTORY.createProcessAreaScope();
                    pas.setProcessArea(owner);
                    return pas;
                }
                return IReadScope.FACTORY.createUnknownScope();
            }
            case 1: {
                TeamAreaPrivateScope taps = (TeamAreaPrivateScope)IReadScope.FACTORY.createTeamAreaPrivateScope();
                taps.setTeamArea(owner);
                return taps;
            }
        }
        return IReadScope.FACTORY.createUnknownScope();
    }

    public static boolean equals(IReadScope rs1, IReadScope rs2) {
        if (rs1 == null && rs2 == null) {
            return true;
        }
        if (rs1 == null || rs2 == null) {
            return false;
        }
        if (rs1 instanceof IContributorDeferringScope && rs2 instanceof IContributorDeferringScope) {
            return ((IContributorDeferringScope)rs1).getScope().sameItemId((IItemHandle)((IContributorDeferringScope)rs2).getScope());
        }
        if (rs1 instanceof IPrivateScope && rs2 instanceof IPrivateScope) {
            return true;
        }
        if (rs1 instanceof IProcessAreaScope && rs2 instanceof IProcessAreaScope) {
            return ((IProcessAreaScope)rs1).getProcessArea().sameItemId((IItemHandle)((IProcessAreaScope)rs2).getProcessArea());
        }
        if (rs1 instanceof IPublicScope && rs2 instanceof IPublicScope) {
            return true;
        }
        if (rs1 instanceof ITeamAreaPrivateScope && rs2 instanceof ITeamAreaPrivateScope) {
            return ((ITeamAreaPrivateScope)rs1).getTeamArea().sameItemId((IItemHandle)((ITeamAreaPrivateScope)rs2).getTeamArea());
        }
        return false;
    }
}

