/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.AuditableCache;
import com.ibm.team.workitem.common.internal.AuditableCommon;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.internal.util.CacheState;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeliverableCache
extends CacheHelper {
    private final AuditableCache.ScopedItemTypeCache<IDeliverable> fDeliverableCache = new AuditableCache.ScopedItemTypeCache(IDeliverable.ITEM_TYPE, IDeliverable.PROJECT_AREA_PROPERTY, Integer.MAX_VALUE);

    public DeliverableCache(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IDeliverableHandle> handles = WorkItemQueries.deliverableByProjectArea(auditableCommon, projectAreaHandle).toList(monitor);
        ItemProfile profile = ItemProfile.createFullProfile(IDeliverable.ITEM_TYPE);
        ArrayList deliverables = new ArrayList(auditableCommon.resolveAuditables2(handles, profile, 3, monitor));
        int i = 0;
        while (i < handles.size()) {
            IDeliverableHandle handle = handles.get(i);
            IDeliverable deliverable = (IDeliverable)deliverables.get(i);
            if (handle.getStateId() != null && deliverable != null && !deliverable.sameStateId((IItemHandle)handle)) {
                deliverables.set(i, (IDeliverable)((AuditableCommon)auditableCommon).fetchCurrentAuditable(handle, profile, monitor));
            }
            ++i;
        }
        this.removeNulls(deliverables);
        this.fDeliverableCache.cacheAll((IAuditableHandle)projectAreaHandle, deliverables, profile);
    }

    private void removeNulls(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
    }

    public List<IDeliverable> getCachedDeliverables(IProjectAreaHandle projectAreaHandle, ItemProfile<IDeliverable> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectAreaHandle, monitor);
        return this.fDeliverableCache.getAll((IAuditableHandle)projectAreaHandle, profile);
    }

    public AuditableCache.IItemTypeCache<? extends IAuditable> getCache() {
        return this.fDeliverableCache;
    }

    @Override
    protected CacheState getCacheState(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return super.getCacheStateForItemType(IDeliverable.ITEM_TYPE, projectAreaHandle, auditableCommon, monitor);
    }
}

