/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.ConfigurationItemManager;
import com.ibm.team.workitem.common.internal.Enumeration;
import com.ibm.team.workitem.common.internal.EnumerationsHelper;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.internal.model.ExternalValueRepresentationItem;
import com.ibm.team.workitem.common.internal.model.Priority;
import com.ibm.team.workitem.common.internal.model.Severity;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.internal.util.CacheState;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class EnumerationManager {
    public static final String ENUMERATIONS_CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.enumerations";
    public static final String ENUMERATION_ELEMENT = "enumeration";
    public static final String ATTRIBUTE_TYPE_ID_ATTRIBUTE = "attributeTypeId";
    public static final String LITERAL_ELEMENT = "literal";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String EXTERNAL_VALUE_ATTRIBUTE = "externalValue";
    public static final String ICON_ATTRIBUTE = "icon";
    public static final String DEFAULT_ATTRIBUTE = "default";
    public static final String NULL_ATTRIBUTE = "null";
    public static final String ARCHIVED_ATTRIBUTE = "archived";
    private final IAuditableCommon fAuditableCommon;
    private final ProcessEnumerationsCache fProcessEnumerations;
    private final PersistedEnumerationsCache fPersistedEnumerations;

    public EnumerationManager(IAuditableCommon auditableCommon) {
        this(new ProcessEnumerationsCache(auditableCommon), new PersistedEnumerationsCache(auditableCommon), auditableCommon);
    }

    public EnumerationManager(ProcessEnumerationsCache processEnumerations, PersistedEnumerationsCache persistedEnumerations, IAuditableCommon auditableCommon) {
        this.fAuditableCommon = auditableCommon;
        this.fProcessEnumerations = processEnumerations;
        this.fPersistedEnumerations = persistedEnumerations;
    }

    public IEnumeration<?> resolve(IAttributeHandle attributeHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute attribute = this.fAuditableCommon.resolveAuditable(attributeHandle, IAttribute.SMALL_PROFILE, monitor);
        return this.internalResolve(attribute.getProjectArea(), this.getEnumerationAttributeType(attribute.getAttributeType()), monitor);
    }

    public IEnumeration<?> internalResolve(IProjectAreaHandle projectArea, String attributeType, IProgressMonitor monitor) throws TeamRepositoryException {
        attributeType = this.getEnumerationAttributeType(attributeType);
        IEnumeration<ILiteral> resolvedEnumeration = null;
        EnumerationItem processEnumeration = (EnumerationItem)this.fProcessEnumerations.findConfigurationItem(projectArea, attributeType, monitor);
        resolvedEnumeration = processEnumeration != null ? new Enumeration<ILiteral>(processEnumeration.getLiterals(), false) : this.fPersistedEnumerations.getEnumeration(attributeType, projectArea, this.fAuditableCommon, monitor);
        if (resolvedEnumeration == null) {
            resolvedEnumeration = new Enumeration(Collections.emptyList(), false);
        }
        return resolvedEnumeration;
    }

    public IEnumeration<? extends ILiteral> internalFindPersisted(IProjectAreaHandle projectArea, String attributeType, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fPersistedEnumerations.getEnumeration(this.getEnumerationAttributeType(attributeType), projectArea, this.fAuditableCommon, monitor);
    }

    public IEnumeration<? extends ILiteral> findCached(IAttribute attribute) {
        return this.internalFindChached(attribute.getProjectArea(), this.getEnumerationAttributeType(attribute.getAttributeType()));
    }

    public IEnumeration<? extends ILiteral> internalFindChached(IProjectAreaHandle projectArea, String attributeType) {
        attributeType = this.getEnumerationAttributeType(attributeType);
        IEnumeration<ILiteral> cachedEnumeration = null;
        EnumerationItem processEnumeration = (EnumerationItem)this.fProcessEnumerations.findCachedConfigurationItem(projectArea, attributeType);
        cachedEnumeration = processEnumeration != null ? new Enumeration<ILiteral>(processEnumeration.getLiterals(), false) : this.fPersistedEnumerations.getCachedEnumeration(attributeType, projectArea);
        if (cachedEnumeration == null) {
            cachedEnumeration = new Enumeration<ILiteral>(Collections.emptyList(), false);
        }
        return cachedEnumeration;
    }

    public void flushCache(IProjectAreaHandle projectArea) {
        this.fProcessEnumerations.flushCache(projectArea);
        this.fPersistedEnumerations.flushCache(projectArea);
    }

    private String getEnumerationAttributeType(String attributeType) {
        String type = AttributeTypes.isEnumerationListAttributeType(attributeType) ? AttributeTypes.getContainedType(attributeType) : attributeType;
        Assert.isTrue((boolean)AttributeTypes.isEnumerationAttributeType(type));
        return type;
    }

    public static class EnumerationItem
    extends ConfigurationItem {
        private final List<ILiteral> fLiterals;

        public EnumerationItem(List<ILiteral> literals, IProjectAreaHandle projectArea, String identifier, String name, URL iconURL, int sequenceValue) {
            super(projectArea, identifier, name, iconURL, sequenceValue);
            this.fLiterals = literals;
        }

        public List<ILiteral> getLiterals() {
            return this.fLiterals;
        }
    }

    public static class PersistedEnumerationsCache
    extends CacheHelper {
        private final ConcurrentHashMap<UUID, Map<String, IEnumeration<ILiteral>>> fPersistentEnumCache = new ConcurrentHashMap(8, 0.9f, 1);

        public PersistedEnumerationsCache(IAuditableCommon auditableCommon) {
            super(auditableCommon);
        }

        public IEnumeration<ILiteral> getEnumeration(String enumeration, IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            this.checkCache(projectAreaHandle, monitor);
            return this.getCachedEnumeration(enumeration, projectAreaHandle);
        }

        public IEnumeration<ILiteral> getCachedEnumeration(String enumeration, IProjectAreaHandle projectAreaHandle) {
            Map<String, IEnumeration<ILiteral>> enumMap = this.fPersistentEnumCache.get(projectAreaHandle.getItemId());
            return enumMap != null ? enumMap.get(enumeration) : null;
        }

        @Override
        protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            HashMap<String, IEnumeration<ILiteral>> enumerationsById = new HashMap<String, IEnumeration<ILiteral>>();
            for (com.ibm.team.workitem.common.internal.enumeration.Enumeration enumeration : auditableCommon.resolvePersistedEnumerations(projectAreaHandle, monitor)) {
                enumerationsById.put(enumeration.getIdentifier(), EnumerationsHelper.toModelledEnumeration(auditableCommon, enumeration));
            }
            if (this.fPersistentEnumCache.putIfAbsent(projectAreaHandle.getItemId(), enumerationsById) != enumerationsById) {
                this.fPersistentEnumCache.replace(projectAreaHandle.getItemId(), enumerationsById);
            }
        }

        @Override
        protected CacheState getCacheState(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            return this.getPessimisticCacheState();
        }
    }

    public static class ProcessEnumerationsCache
    extends ConfigurationItemManager<EnumerationItem> {
        public ProcessEnumerationsCache(IAuditableCommon auditableCommon) {
            super(auditableCommon);
        }

        @Override
        protected String getConfigurationDataPoint() {
            return EnumerationManager.ENUMERATIONS_CONFIGURATION_DATA_POINT;
        }

        @Override
        protected String getGroupElement() {
            return null;
        }

        @Override
        protected String getElement() {
            return EnumerationManager.ENUMERATION_ELEMENT;
        }

        @Override
        protected EnumerationItem readElement(IProjectAreaHandle projectArea, IProcessConfigurationElement configurationElement, int sequenceValue, IProgressMonitor monitor) throws TeamRepositoryException {
            EnumerationItem enumItem = null;
            String enumerationType = configurationElement.getAttribute(EnumerationManager.ATTRIBUTE_TYPE_ID_ATTRIBUTE);
            if (enumerationType != null) {
                String name = configurationElement.getAttribute(EnumerationManager.NAME_ATTRIBUTE);
                ArrayList<ILiteral> literals = new ArrayList<ILiteral>();
                int literalSequenceValue = 0;
                IProcessConfigurationElement[] iProcessConfigurationElementArray = configurationElement.getChildren();
                int n = iProcessConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILiteral literal;
                    IProcessConfigurationElement child = iProcessConfigurationElementArray[n2];
                    if (EnumerationManager.LITERAL_ELEMENT.equals(child.getName()) && (literal = this.readLiteral(enumerationType, projectArea, child, literalSequenceValue, monitor)) != null) {
                        literals.add(literal);
                        ++literalSequenceValue;
                    }
                    ++n2;
                }
                enumItem = new EnumerationItem(literals, projectArea, enumerationType, name, null, sequenceValue);
            }
            return enumItem;
        }

        private ILiteral readLiteral(String enumerationType, IProjectAreaHandle projectArea, IProcessConfigurationElement configurationElement, int sequenceValue, IProgressMonitor monitor) throws TeamRepositoryException {
            String identifier = configurationElement.getAttribute(EnumerationManager.ID_ATTRIBUTE);
            if (identifier == null) {
                return null;
            }
            String displayName = configurationElement.getAttribute(EnumerationManager.NAME_ATTRIBUTE);
            if (displayName == null) {
                return null;
            }
            ConfigurationItem literal = null;
            String externalValue = configurationElement.getAttribute(EnumerationManager.EXTERNAL_VALUE_ATTRIBUTE);
            String icon = configurationElement.getAttribute(EnumerationManager.ICON_ATTRIBUTE);
            URL iconURL = this.createResourceURL(projectArea, icon, monitor);
            String defaultValue = configurationElement.getAttribute(EnumerationManager.DEFAULT_ATTRIBUTE);
            boolean isDefault = Boolean.TRUE.toString().equalsIgnoreCase(defaultValue);
            String nullValue = configurationElement.getAttribute(EnumerationManager.NULL_ATTRIBUTE);
            boolean isNull = Boolean.TRUE.toString().equalsIgnoreCase(nullValue);
            String archivedValue = configurationElement.getAttribute(EnumerationManager.ARCHIVED_ATTRIBUTE);
            boolean isArchived = Boolean.TRUE.toString().equalsIgnoreCase(archivedValue);
            literal = enumerationType.equals("priority") ? new Priority(projectArea, identifier, displayName, externalValue, iconURL, sequenceValue, isDefault, isNull, isArchived) : (enumerationType.equals("severity") ? new Severity(projectArea, identifier, displayName, externalValue, iconURL, sequenceValue, isDefault, isNull, isArchived) : (externalValue != null && externalValue.length() > 0 ? new ExternalValueRepresentationItem(projectArea, identifier, displayName, externalValue, iconURL, sequenceValue, isDefault, isNull, isArchived) : new ConfigurationItem(projectArea, identifier, displayName, iconURL, sequenceValue, isDefault, isNull, isArchived)));
            return literal;
        }
    }
}

