/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.advice.IAdvisorDeclaration;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.AbstractAttributesByTypeAndStateAdvisor;
import com.ibm.team.workitem.common.internal.ReadOnlyAttributesByConditionAdvisor;
import com.ibm.team.workitem.common.internal.RequiredAttributesByConditionAdvisor;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class PropertiesManager {
    public static final Set<String> SUPPORTED_BUILT_IN_ATTRIBUTES_FOR_REQUIREDNESS = new HashSet<String>(Arrays.asList(IWorkItem.DESCRIPTION_PROPERTY, IWorkItem.DUE_DATE_PROPERTY, IWorkItem.DURATION_PROPERTY, IWorkItem.CATEGORY_PROPERTY, IWorkItem.FOUND_IN_PROPERTY, IWorkItem.OWNER_PROPERTY, IWorkItem.TARGET_PROPERTY, IWorkItem.SUMMARY_PROPERTY, IWorkItem.TAGS_PROPERTY, IWorkItem.PRIORITY_PROPERTY, IWorkItem.SEVERITY_PROPERTY, WorkItem.TIME_SPENT_PROPERTY, WorkItem.CORRECTED_ESTIMATE_PROPERTY));
    public static final Set<String> SUPPORTED_BUILT_IN_ATTRIBUTES_FOR_READONLYNESS = new HashSet<String>(Arrays.asList(IWorkItem.DESCRIPTION_PROPERTY, IWorkItem.DUE_DATE_PROPERTY, IWorkItem.DURATION_PROPERTY, IWorkItem.CATEGORY_PROPERTY, IWorkItem.FOUND_IN_PROPERTY, IWorkItem.OWNER_PROPERTY, IWorkItem.TARGET_PROPERTY, IWorkItem.SUMMARY_PROPERTY, IWorkItem.TAGS_PROPERTY, IWorkItem.PRIORITY_PROPERTY, IWorkItem.SEVERITY_PROPERTY, WorkItem.TIME_SPENT_PROPERTY, WorkItem.CORRECTED_ESTIMATE_PROPERTY, WorkItem.COMMENTS_PROPERTY, WorkItem.STATE_PROPERTY));
    private final IAuditableCommon fAuditableCommon;

    public static boolean isSupportedCustomAttributeType(String attributeType) {
        return AttributeTypes.isSupportedCustomAttributeType(attributeType) && !"boolean".equals(attributeType);
    }

    public PropertiesManager(IAuditableCommon auditableCommon) {
        this.fAuditableCommon = auditableCommon;
    }

    public List<String> findReadOnlyAttributes(IWorkItem workItem, String workflowAction, boolean ignoreScriptBasedAttributeAdvisors, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = this.fAuditableCommon.getPeer(IWorkItemCommon.class);
        IProcessAreaHandle processArea = workItemCommon.findProcessArea(workItem, monitor);
        IAuditableCommonProcess process = this.fAuditableCommon.getProcess(processArea, monitor);
        HashSet<String> readOnlyAttributes = new HashSet<String>();
        List<IAttribute> attributes = workItemCommon.findAttributes(workItem.getProjectArea(), monitor);
        for (IAttribute attribute : attributes) {
            if (!attribute.isReadOnly()) continue;
            readOnlyAttributes.add(attribute.getIdentifier());
        }
        readOnlyAttributes.remove(IWorkItem.STATE_PROPERTY);
        List<IAdvisorDeclaration> advisorDeclarations1 = process.findAdvisorDeclarations(processArea, "com.ibm.team.workitem.operation.workItemSave", "com.ibm.team.workitem.advisor.readOnlyAttributesByTypeAndState", monitor);
        for (IAdvisorDeclaration advisorDeclaration1 : advisorDeclarations1) {
            readOnlyAttributes.addAll(AbstractAttributesByTypeAndStateAdvisor.getConfiguredAttributes(workItemCommon, workItem, workflowAction, advisorDeclaration1.getConfigurationElement(), monitor));
        }
        List<IAdvisorDeclaration> advisorDeclarations2 = process.findAdvisorDeclarations(processArea, "com.ibm.team.workitem.operation.workItemSave", "com.ibm.team.workitem.advisor.readOnlyAttributes", monitor);
        for (IAdvisorDeclaration advisorDeclaration2 : advisorDeclarations2) {
            readOnlyAttributes.addAll(ReadOnlyAttributesByConditionAdvisor.getReadOnlyAttributes(workItem, workItemCommon, workflowAction, advisorDeclaration2.getConfigurationElement(), ignoreScriptBasedAttributeAdvisors, monitor));
        }
        return new ArrayList<String>(readOnlyAttributes);
    }

    public List<String> findRequiredAttributes(IWorkItem workItem, String workflowAction, boolean ignoreScriptBasedAttributeAdvisors, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = this.fAuditableCommon.getPeer(IWorkItemCommon.class);
        if (!IWorkItem.FULL_PROFILE.isMatched(workItem)) {
            workItem = this.fAuditableCommon.resolveAuditable(workItem, IWorkItem.FULL_PROFILE, monitor);
        }
        IProcessAreaHandle processArea = workItemCommon.findProcessArea(workItem, monitor);
        IAuditableCommonProcess process = this.fAuditableCommon.getProcess(processArea, monitor);
        HashSet<String> requiredAttributes = new HashSet<String>();
        List<IAdvisorDeclaration> advisorDeclarations1 = process.findAdvisorDeclarations(processArea, "com.ibm.team.workitem.operation.workItemSave", "com.ibm.team.workitem.advisor.requiredProperties", monitor);
        for (IAdvisorDeclaration advisorDeclaration1 : advisorDeclarations1) {
            requiredAttributes.addAll(AbstractAttributesByTypeAndStateAdvisor.getConfiguredAttributes(workItemCommon, workItem, workflowAction, advisorDeclaration1.getConfigurationElement(), monitor));
        }
        List<IAdvisorDeclaration> advisorDeclarations2 = process.findAdvisorDeclarations(processArea, "com.ibm.team.workitem.operation.workItemSave", "com.ibm.team.workitem.advisor.requiredAttributes", monitor);
        for (IAdvisorDeclaration advisorDeclaration2 : advisorDeclarations2) {
            requiredAttributes.addAll(RequiredAttributesByConditionAdvisor.getRequiredAttributes(workItem, workItemCommon, workflowAction, advisorDeclaration2.getConfigurationElement(), ignoreScriptBasedAttributeAdvisors, monitor));
        }
        return new ArrayList<String>(requiredAttributes);
    }

    public List<String> findRequiredWorkflowProperties(IWorkItem workItem, String stateId, String resolutionId, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemType workItemType;
        IWorkItemCommon workItemCommon = this.fAuditableCommon.getPeer(IWorkItemCommon.class);
        if (!IWorkItem.FULL_PROFILE.isMatched(workItem)) {
            workItem = this.fAuditableCommon.resolveAuditable(workItem, IWorkItem.FULL_PROFILE, monitor);
        }
        if ((workItemType = workItemCommon.findWorkItemType(workItem.getProjectArea(), workItem.getWorkItemType(), monitor)) == null) {
            return Collections.emptyList();
        }
        IProcessAreaHandle processArea = workItemCommon.findProcessArea(workItem, monitor);
        IAuditableCommonProcess process = this.fAuditableCommon.getProcess(processArea, monitor);
        List<IAdvisorDeclaration> advisorDeclarations = process.findAdvisorDeclarations(processArea, "com.ibm.team.workitem.operation.workItemSave", "com.ibm.team.workitem.advisor.requiredProperties", monitor);
        HashSet<String> attributes = new HashSet<String>();
        for (IAdvisorDeclaration advisorDeclaration : advisorDeclarations) {
            attributes.addAll(AbstractAttributesByTypeAndStateAdvisor.readWorkflowAdvisorConfiguration(workItemType, stateId, resolutionId, advisorDeclaration.getConfigurationElement()));
        }
        return new ArrayList<String>(attributes);
    }
}

