/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.foundation.common.internal.util.ExceptionDescription;
import com.ibm.team.foundation.common.internal.util.ITeamFoundationExceptionDescriptor;
import com.ibm.team.foundation.common.internal.util.TeamFoundationException;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.workflow.WorkflowException;
import com.ibm.team.workitem.common.model.CycleDetectedException;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.osgi.util.NLS;

public class WorkItemExceptionDescriptionFactory
implements IAdapterFactory {
    public static final String ESTIMATE_ID = "com.ibm.team.workitem.consistency.estimate";
    public static final String TIME_SPENT_ID = "com.ibm.team.workitem.consistency.timeSpent";
    public static final String TIME_REMAINING_ID = "com.ibm.team.workitem.consistency.timeRemaining";
    public static final String TIME_DURATION_ID = "com.ibm.team.workitem.consistency.timeDuration";
    public static final String CORRECTED_ESTIMATE_ID = "com.ibm.team.workitem.consistency.correctedEstimate";
    public static final String MULTIPLE_REFERENCES_ID = "com.ibm.team.workitem.consistency.multipleReferences";
    public static final String SPECIFY_DUPLICATE_ID = "com.ibm.team.workitem.consistency.specifyDuplicate";
    public static final String PROJECT_AREA_NOT_INITIALIZED_ID = "com.ibm.team.workitem.projectAreaNotInitialized";
    private static final Class[] ADAPTERS = new Class[]{ExceptionDescription.class};

    public static ITeamFoundationExceptionDescriptor createEstimateDescriptor() {
        return TeamFoundationException.createDescriptor((String)ESTIMATE_ID, (String)Messages.getString("WorkItemExceptionDescriptionFactory.ESTIMATE_NOT_VALID_SUMMARY"), (String)Messages.getString("WorkItemExceptionDescriptionFactory.ESTIMATE_NOT_VALID_DESCRIPTION"), (boolean)true);
    }

    public static ITeamFoundationExceptionDescriptor createCorrectedEstimateDescriptor() {
        return TeamFoundationException.createDescriptor((String)CORRECTED_ESTIMATE_ID, (String)Messages.getString("WorkItemExceptionDescriptionFactory.CORRECTED_ESTIMATE_NOT_VALID_SUMMARY"), (String)Messages.getString("WorkItemExceptionDescriptionFactory.CORRECTED_ESTIMATE_NOT_VALID_DESCRIPTION"), (boolean)true);
    }

    public static ITeamFoundationExceptionDescriptor createTimeSpentDescriptor() {
        return TeamFoundationException.createDescriptor((String)TIME_SPENT_ID, (String)Messages.getString("WorkItemExceptionDescriptionFactory.TIME_SPENT_NOT_VALID_SUMMARY"), (String)Messages.getString("WorkItemExceptionDescriptionFactory.TIME_SPENT_NOT_VALID_DESCRIPTION"), (boolean)true);
    }

    public static ITeamFoundationExceptionDescriptor createTimeRemainingDescriptor() {
        return TeamFoundationException.createDescriptor((String)TIME_REMAINING_ID, (String)Messages.getString("WorkItemExceptionDescriptionFactory.TIME_REMAINING_NOT_VALID_SUMMARY"), (String)Messages.getString("WorkItemExceptionDescriptionFactory.TIME_REMAINING_NOT_VALID_DESCRIPTION"), (boolean)true);
    }

    public static ITeamFoundationExceptionDescriptor createTimeDurationDescriptor(IAttribute attribute) {
        return TeamFoundationException.createDescriptor((String)TIME_DURATION_ID, (String)NLS.bind((String)Messages.getString("WorkItemExceptionDescriptionFactory.TIME_DURATION_NOT_VALID_SUMMARY"), (Object)attribute.getDisplayName()), (String)NLS.bind((String)Messages.getString("WorkItemExceptionDescriptionFactory.TIME_DURATION_NOT_VALID_DESCRIPTION"), (Object)attribute.getDisplayName()), (boolean)true);
    }

    public static ITeamFoundationExceptionDescriptor createMultipleReferencesDescriptor(IEndPointDescriptor descriptor, IWorkItem workItem) {
        String summary = NLS.bind((String)Messages.getString("WorkItemExceptionDescriptionFactory.CHANGE_WOULD_INTRODUCE_MULTIPLE_REFERENCES_SUMMARY"), (Object)descriptor.getDisplayName(), (Object)WorkItemTextUtilities.getWorkItemId(workItem));
        String description = NLS.bind((String)Messages.getString("WorkItemExceptionDescriptionFactory.CHANGE_WOULD_INTRODUCE_MULTIPLE_REFERENCES_DESCRIPTION"), (Object)descriptor.getDisplayName(), (Object)WorkItemTextUtilities.getWorkItemId(workItem));
        return TeamFoundationException.createDescriptor((String)MULTIPLE_REFERENCES_ID, (String)summary, (String)description, (boolean)true);
    }

    public static ITeamFoundationExceptionDescriptor createSpecifyDuplicateDescriptor() {
        String summary = Messages.getString("WorkItemExceptionDescriptionFactory.SPECIFY_DUPLICATE_SUMMARY");
        String description = Messages.getString("WorkItemExceptionDescriptionFactory.SPECIFY_DUPLICATE_DESCRIPTION");
        return TeamFoundationException.createDescriptor((String)SPECIFY_DUPLICATE_ID, (String)summary, (String)description, (boolean)true);
    }

    public static ITeamFoundationExceptionDescriptor createProjectAreaNotInitializedDescriptor() {
        String summary = Messages.getString("WorkItemExceptionDescriptionFactory.PROJECT_AREA_NOT_INITIALIZED_SUMMARY");
        String description = Messages.getString("WorkItemExceptionDescriptionFactory.PROJECT_AREA_NOT_INITIALIZED_DESCRIPTION");
        return TeamFoundationException.createDescriptor((String)PROJECT_AREA_NOT_INITIALIZED_ID, (String)summary, (String)description, (boolean)true);
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof Throwable && ExceptionDescription.class.equals((Object)adapterType)) {
            return this.findExceptionDescription((Throwable)adaptableObject);
        }
        return null;
    }

    private ExceptionDescription findExceptionDescription(Throwable x) {
        if (x instanceof MultiStaleDataException) {
            return ExceptionDescription.createDescription((String)Messages.getString("WorkItemExceptionDescriptionFactory.STALE_DATA_SUMMARY"), (String)Messages.getString("WorkItemExceptionDescriptionFactory.STALE_DATA_DESCRIPTION"));
        }
        if (x instanceof CycleDetectedException) {
            String description = x.getMessage() != null && x.getMessage().length() > 0 ? x.getMessage() : Messages.getString("WorkItemExceptionDescriptionFactory.CIRCULAR_DEPENDENCY_DESCRIPTION");
            return ExceptionDescription.createDescription((String)Messages.getString("WorkItemExceptionDescriptionFactory.CIRCULAR_DEPENDENCY_SUMMARY"), (String)description);
        }
        if (x instanceof WorkflowException) {
            return ExceptionDescription.createDescription((String)Messages.getString("WorkItemExceptionDescriptionFactory.STATE_TRANSITION_PROBLEM_SUMMARY"), (String)Messages.getString("WorkItemExceptionDescriptionFactory.STATE_TRANSITION_PROBLEM_DESCRIPTION"));
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTERS;
    }
}

