/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IDefaultValueProvider;
import com.ibm.team.workitem.common.internal.model.EnumerationAttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CustomDefaultEnumerationListProvider
implements IDefaultValueProvider<Collection<?>> {
    @Override
    public Collection<?> getDefaultValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<Identifier<? extends ILiteral>> result = new ArrayList<Identifier<? extends ILiteral>>();
        IConfiguration child = configuration.getChild("enumeration");
        if (child == null) {
            return result;
        }
        String enumerationType = child.getString("id");
        if (enumerationType == null || !AttributeTypes.isEnumerationAttributeType(enumerationType)) {
            return result;
        }
        String containedType = AttributeTypes.getContainedType(attribute.getAttributeType());
        if (!containedType.equals(enumerationType)) {
            return result;
        }
        IEnumeration<? extends ILiteral> enumeration = workItemCommon.resolveEnumeration(attribute, null);
        Class<? extends ILiteral> enumerationClass = ((EnumerationAttributeType)AttributeTypes.getAttributeType(enumerationType)).getEnumerationType();
        List<IConfiguration> children = configuration.getChildren("value");
        for (IConfiguration config : children) {
            String enumerationId = config.getString("content");
            Identifier<? extends ILiteral> enumerationIdentifier = Identifier.create(enumerationClass, enumerationId);
            if (enumeration.findEnumerationLiteral(enumerationIdentifier, true) == null) continue;
            result.add(enumerationIdentifier);
        }
        return result;
    }
}

