/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IRole;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IDefaultValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ValueProviderUtil;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class RoleBasedLiteralProvider
implements IDefaultValueProvider<Identifier<? extends ILiteral>> {
    @Override
    public Identifier<? extends ILiteral> getDefaultValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!AttributeTypes.isEnumerationAttributeType(attribute.getAttributeType())) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        IAuditableCommon auditableCommon = workItemCommon.getAuditableCommon();
        IAuditableCommonProcess process = workItemCommon.getAuditableCommon().getProcess((IProcessAreaHandle)workItem.getProjectArea(), (IProgressMonitor)progress.newChild(1));
        IProjectArea projectArea = auditableCommon.resolveAuditable((IAuditableHandle)workItem.getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, (IProgressMonitor)progress.newChild(1));
        IContributorHandle loggedInUser = workItemCommon.getAuditableCommon().getUser();
        List<IRole> roles = process.getContributorRoles(loggedInUser, (IProcessArea)projectArea, (IProgressMonitor)progress.newChild(1));
        IEnumeration<? extends ILiteral> enumeration = workItemCommon.resolveEnumeration(attribute, (IProgressMonitor)progress.newChild(1));
        for (IRole role : roles) {
            String literalId = ValueProviderUtil.getMappedLiteral(configuration, role.getId());
            if (literalId == null) continue;
            for (ILiteral iLiteral : enumeration.getEnumerationLiterals(false)) {
                if (!literalId.equals(iLiteral.getIdentifier2().getStringIdentifier())) continue;
                return iLiteral.getIdentifier2();
            }
        }
        ILiteral defaultLiteral = enumeration.findDefaultEnumerationLiteral();
        if (defaultLiteral != null) {
            return defaultLiteral.getIdentifier2();
        }
        ILiteral nullLiteral = enumeration.findNullEnumerationLiteral();
        if (nullLiteral != null) {
            return nullLiteral.getIdentifier2();
        }
        throw new IllegalStateException();
    }
}

