/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.identifiers;

import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.AuditableCommon;
import com.ibm.team.workitem.common.internal.identifiers.IAttributeType;
import com.ibm.team.workitem.common.internal.identifiers.IIdentifierMapping;
import com.ibm.team.workitem.common.internal.identifiers.IPublicAttribute;
import com.ibm.team.workitem.common.internal.identifiers.IPublicItem;
import com.ibm.team.workitem.common.internal.identifiers.IPublicType;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierMapping;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierRegistry;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AttributeFacade {
    private final IWorkItemCommon fItemCommon;
    private final IdentifierMapping fRegistry;
    private final IProjectAreaHandle fProjectArea;

    protected AttributeFacade(Class<IdentifierRegistry> identifierRegistry, IProjectAreaHandle projectArea, IWorkItemCommon itemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fRegistry = (IdentifierMapping)IdentifierMapping.create(identifierRegistry);
        this.fProjectArea = projectArea;
        this.fItemCommon = itemCommon;
        List<IAttribute> attrs = this.fItemCommon.findAttributes(projectArea, monitor);
        for (IAttribute curAttr : attrs) {
            Identifier pubAttrId;
            Identifier pubTypeId;
            if (curAttr.isInternal()) continue;
            Identifier<IAttributeType> intTypeId = IdentifierMapping.createInternalTypeIdentifier(curAttr);
            Identifier<IAttribute> intAttrId = IdentifierMapping.createInternalAttributeIdentifier(curAttr);
            if (intTypeId != null) {
                this.fRegistry.declareAttributeType(intAttrId, intTypeId);
            }
            if (!this.fRegistry.hasIdentifier(intAttrId) || (pubTypeId = this.getAttributeType(pubAttrId = this.fRegistry.getPublicIdentifier(intAttrId))) == null || intTypeId == null) continue;
            this.fRegistry.declareInternalIdentifier(pubTypeId, intTypeId);
            this.fRegistry.declarePublicIdentifier(intTypeId, pubTypeId, this.fRegistry.getNamespace(pubTypeId));
        }
    }

    protected IIdentifierMapping getRegistry() {
        return this.fRegistry;
    }

    protected IProjectArea getProjectArea(IProgressMonitor monitor) {
        if (this.fProjectArea.hasFullState()) {
            return (IProjectArea)this.fProjectArea.getFullState();
        }
        try {
            return (IProjectArea)this.getAuditableCommon().fetchCurrentAuditable((IAuditableHandle)this.fProjectArea, ItemProfile.PROCESS_AREA_DEFAULT, monitor);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            return null;
        }
    }

    public IWorkItemCommon getItemCommon() {
        return this.fItemCommon;
    }

    public <T extends IItem> Identifier<T> getInternalIdentifier(Identifier<? extends IPublicItem> id) {
        return this.fRegistry.getInternalIdentifier(id);
    }

    public Set<Identifier<? extends IItem>> getAllInternalIdentifiers() {
        return this.fRegistry.getAllInternalIdentifiers();
    }

    public <T extends IPublicItem> Identifier<T> getPublicIdentifier(Identifier<? extends IItem> id) {
        return this.fRegistry.getPublicIdentifier(id);
    }

    public Set<Identifier<? extends IPublicItem>> getAllPublicIdentifiers() {
        return this.fRegistry.getAllPublicIdentifiers();
    }

    public <T> Identifier<T> getAttributeType(Identifier<?> id) {
        return this.fRegistry.getAttributeType(id);
    }

    public Set<Identifier<?>> getAllAttributeTypes() {
        return this.fRegistry.getAllAttributeTypes();
    }

    public String getDisplayName(Identifier<?> id) {
        return this.fRegistry.getDisplayName(id);
    }

    public String getNamespace(String prefix) {
        return this.fRegistry.getNamespace(prefix);
    }

    public String getNamespace(Identifier<? extends IPublicItem> id) {
        return this.fRegistry.getNamespace(id);
    }

    public String qualify(Identifier<? extends IPublicItem> id) {
        return this.fRegistry.qualify(id);
    }

    public abstract Object getInternalValue(Identifier<? extends IItem> var1, String var2);

    public abstract String getPublicValue(Identifier<? extends IItem> var1, Object var2);

    public abstract boolean isMultiValueAttribute(Identifier<IAttribute> var1);

    public Identifier<IPublicAttribute> getAttributeIdentifier(UUID itemId, IProgressMonitor monitor) throws TeamRepositoryException {
        IItem item = this.getAuditableCommon().fetchItem(itemId, monitor);
        if (item != null) {
            if (item instanceof IAttribute) {
                IAttribute attr = (IAttribute)item;
                Identifier<IAttribute> internalId = IdentifierMapping.createInternalAttributeIdentifier(attr);
                return this.fRegistry.getPublicIdentifier(internalId);
            }
            if (item instanceof ILink) {
                ILink link = (ILink)item;
                IEndPointDescriptor target = link.getThisEndpointDescriptor(link.getTargetRef());
                IEndPointDescriptor source = link.getThisEndpointDescriptor(link.getSourceRef());
                Identifier<IPublicAttribute> result = this.fRegistry.getPublicIdentifier(IdentifierMapping.createInternalLinkIdentifier(target));
                if (result == null) {
                    result = this.fRegistry.getPublicIdentifier(IdentifierMapping.createInternalLinkIdentifier(source));
                }
                return result;
            }
        }
        return null;
    }

    public Identifier<IPublicType> getTypeIdentifier(IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        return attribute != null ? this.getTypeIdentifier(attribute.getItemId(), monitor) : null;
    }

    public Identifier<IPublicType> getTypeIdentifier(ILink link, IProgressMonitor monitor) throws TeamRepositoryException {
        return link != null ? this.getTypeIdentifier(link.getItemId(), monitor) : null;
    }

    protected AuditableCommon getAuditableCommon() {
        IAuditableCommon result = this.fItemCommon.getAuditableCommon();
        try {
            return (AuditableCommon)result;
        }
        catch (ClassCastException classCastException) {
            return (AuditableCommon)result.getPeer(IAuditableCommon.class);
        }
    }

    private Identifier<IPublicType> getTypeIdentifier(UUID itemId, IProgressMonitor monitor) throws TeamRepositoryException {
        IItem item = this.getAuditableCommon().fetchItem(itemId, monitor);
        if (item != null) {
            if (item instanceof IAttribute) {
                IAttribute attribute = (IAttribute)item;
                Identifier<IAttributeType> interalId = IdentifierMapping.createInternalTypeIdentifier(attribute);
                return this.fRegistry.getPublicIdentifier(interalId);
            }
            if (item instanceof ILink) {
                ILink link = (ILink)item;
                Identifier<IAttributeType> internalId = IdentifierMapping.createInternalTypeIdentifier(link.getLinkType());
                return this.fRegistry.getPublicIdentifier(internalId);
            }
        }
        return null;
    }
}

